/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.border.MutableLineBorder;
import com.github.weisj.darklaf.components.tabframe.TabFrameTabbedPopupUI;
import com.github.weisj.darklaf.components.tabframe.TabbedPopup;
import com.github.weisj.darklaf.components.uiresource.JPanelUIResource;
import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.MoreTabsButton;
import com.github.weisj.darklaf.ui.tabbedpane.NewTabButton;
import com.github.weisj.darklaf.ui.tabbedpane.TabButtonContainer;
import com.github.weisj.darklaf.ui.tabframe.DarkPanelPopupUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;

public class DarkTabbedPopupUI
extends DarkPanelPopupUI
implements TabFrameTabbedPopupUI {
    protected Color headerHoverBackground;
    protected Color headerSelectedBackground;
    protected Color headerSelectedHoverBackground;
    protected Color headerFocusHoverBackground;
    protected Color headerFocusSelectedBackground;
    protected Color headerFocusSelectedHoverBackground;
    protected Color tabBorderColor;
    private TabbedPopup popupComponent;
    private JTabbedPane tabbedPane;
    private MutableLineBorder border;
    private JPanel holder;
    private JButton newTabButton;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTabbedPopupUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.popupComponent = (TabbedPopup)c;
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.headerHoverBackground = UIManager.getColor("TabFramePopup.headerHoverBackground");
        this.headerSelectedBackground = UIManager.getColor("TabFramePopup.headerSelectedBackground");
        this.headerSelectedHoverBackground = UIManager.getColor("TabFramePopup.headerSelectedHoverBackground");
        this.headerFocusHoverBackground = UIManager.getColor("TabFramePopup.headerFocusHoverBackground");
        this.headerFocusSelectedBackground = UIManager.getColor("TabFramePopup.headerFocusSelectedBackground");
        this.headerFocusSelectedHoverBackground = UIManager.getColor("TabFramePopup.headerFocusSelectedHoverBackground");
        this.tabBorderColor = UIManager.getColor("TabFramePopup.borderColor");
    }

    @Override
    protected void installComponents() {
        this.closeButton = this.createCloseButton();
        this.label = this.createLabel();
        this.customButtonArea = this.createCustomButtonArea();
        this.tabbedPane = this.getTabbedPane();
        this.setupTabbedPane();
        this.border = this.createBorder();
        this.holder = new JPanel(new BorderLayout());
        this.holder.add((Component)this.tabbedPane, "Center");
        this.holder.setBorder(this.border);
        this.popupComponent.add(this.holder);
    }

    protected JTabbedPane getTabbedPane() {
        JTabbedPane tabbedPane = this.popupComponent.getTabbedPane();
        tabbedPane.setTabLayoutPolicy(1);
        if (tabbedPane instanceof UIDelegateTabbedPane) {
            ((UIDelegateTabbedPane)tabbedPane).setUiSupplier(() -> new DarkTabFrameTabbedPaneUI());
            tabbedPane.updateUI();
        } else {
            tabbedPane.setUI(new DarkTabFrameTabbedPaneUI());
        }
        return tabbedPane;
    }

    @Override
    public JTabbedPane createTabbedPane() {
        return new UIDelegateTabbedPane(null);
    }

    protected void setupTabbedPane() {
        this.label.setBorder(new EmptyBorder(0, 5, 0, 5));
        JPanelUIResource buttonHolder = new JPanelUIResource();
        buttonHolder.setLayout(new BoxLayout(buttonHolder, 0));
        buttonHolder.add(Box.createHorizontalStrut(1));
        buttonHolder.add(this.customButtonArea);
        buttonHolder.add(this.closeButton);
        buttonHolder.add(Box.createHorizontalStrut(1));
        buttonHolder.setBorder(UIManager.getBorder("TabFramePopup.headerBorder"));
        buttonHolder.setOpaque(false);
        this.tabbedPane.setOpaque(false);
        this.tabbedPane.putClientProperty("JTabbedPane.leadingComponent", this.label);
        this.tabbedPane.putClientProperty("JTabbedPane.trailingComponent", buttonHolder);
    }

    @Override
    protected void setHeaderBackground(boolean focus) {
        boolean oldFocus = this.hasFocus();
        super.setHeaderBackground(focus);
        if (oldFocus != focus) {
            if (this.newTabButton != null) {
                this.newTabButton.putClientProperty("JButton.borderless.hover", focus ? this.headerButtonFocusHoverBackground : this.headerButtonHoverBackground);
                this.newTabButton.putClientProperty("JButton.borderless.click", focus ? this.headerButtonFocusClickBackground : this.headerButtonClickBackground);
                this.newTabButton.repaint();
            }
            this.holder.setBackground(focus ? this.headerFocusBackground : this.headerBackground);
            this.holder.repaint();
        }
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        this.popupComponent.remove(this.tabbedPane);
    }

    @Override
    protected void applyBorderInsets(Insets insets) {
        this.border.setInsets(insets.top, insets.left, insets.bottom, insets.right);
    }

    protected static class UIDelegateTabbedPane
    extends JTabbedPane {
        private Supplier<TabbedPaneUI> uiSupplier;

        protected UIDelegateTabbedPane(Supplier<TabbedPaneUI> uiSupplier) {
            this.setUiSupplier(uiSupplier);
        }

        public void setUiSupplier(Supplier<TabbedPaneUI> uiSupplier) {
            this.uiSupplier = uiSupplier;
        }

        @Override
        public void updateUI() {
            if (this.uiSupplier != null) {
                this.setUI(this.uiSupplier.get());
            } else {
                super.updateUI();
            }
        }
    }

    protected class DarkTabFrameTabbedPaneUI
    extends DarkTabbedPaneUI {
        protected DarkTabFrameTabbedPaneUI() {
        }

        @Override
        protected Color getAccentColor(boolean focus) {
            return super.getAccentColor(focus || DarkTabbedPopupUI.this.hasFocus());
        }

        @Override
        protected Color getTabBorderColor() {
            return this.tabBorderColor;
        }

        @Override
        public Color getTabBackgroundColor(int tabIndex, boolean isSelected, boolean hover) {
            if (DarkTabbedPopupUI.this.hasFocus()) {
                if (isSelected) {
                    return hover ? DarkTabbedPopupUI.this.headerFocusSelectedHoverBackground : DarkTabbedPopupUI.this.headerFocusSelectedBackground;
                }
                return hover ? DarkTabbedPopupUI.this.headerFocusHoverBackground : DarkTabbedPopupUI.this.headerFocusBackground;
            }
            if (isSelected) {
                return hover ? DarkTabbedPopupUI.this.headerSelectedHoverBackground : DarkTabbedPopupUI.this.headerSelectedBackground;
            }
            return hover ? DarkTabbedPopupUI.this.headerHoverBackground : DarkTabbedPopupUI.this.headerBackground;
        }

        @Override
        protected Color getTabAreaBackground() {
            return DarkTabbedPopupUI.this.hasFocus() ? DarkTabbedPopupUI.this.headerFocusBackground : DarkTabbedPopupUI.this.headerBackground;
        }

        @Override
        public TabButtonContainer createNewTabButton() {
            TabFrameNewTabButton b = new TabFrameNewTabButton(this);
            DarkTabbedPopupUI.this.newTabButton = b.getButton();
            return b;
        }

        @Override
        protected int getFallBackSize() {
            return this.trailingComp != null ? this.trailingComp.getPreferredSize().height + 1 : super.getFallBackSize();
        }

        @Override
        public TabButtonContainer createMoreTabsButton() {
            return new TabFrameMoreTabsButton(this);
        }
    }

    protected class TabFrameNewTabButton
    extends NewTabButton {
        protected TabFrameNewTabButton(DarkTabbedPaneUI ui) {
            super(ui);
        }

        public JButton getButton() {
            return this.button;
        }

        @Override
        protected JButton createButton() {
            DarkPanelPopupUI.HeaderButton button = new DarkPanelPopupUI.HeaderButton(this.tabbedPaneUI.getNewTabIcon(), DarkTabbedPopupUI.this);
            button.putClientProperty("JButton.variant", "borderless");
            button.putClientProperty("JButton.square", true);
            button.putClientProperty("JButton.thin", Boolean.TRUE);
            button.setRolloverEnabled(true);
            button.setOpaque(false);
            return button;
        }
    }

    protected static class TabFrameMoreTabsButton
    extends MoreTabsButton {
        public TabFrameMoreTabsButton(DarkTabbedPaneUI ui) {
            super(ui);
        }
    }
}

