/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes;

import codechicken.nei.ItemList;
import codechicken.nei.RestartableTask;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import craftedMods.recipes.provider.NEIIntegrationManager;
import craftedMods.recipes.provider.NEIRecipeHandlersConfiguration;
import craftedMods.utils.SemanticVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="neirecipehandlers", name="NEI Recipe Handlers", version="1.1.0-BETA", acceptableRemoteVersions="*", guiFactory="craftedMods.recipes.ConfigurationGuiFactory")
public class NEIRecipeHandlers {
    @Mod.Instance(value="neirecipehandlers")
    public static NEIRecipeHandlers mod = new NEIRecipeHandlers();
    private NEIRecipeHandlersConfiguration config;
    public static final String MODID = "neirecipehandlers";
    public static final String MODNAME = "NEI Recipe Handlers";
    public static final String VERSION = "1.1.0-BETA";
    public static final SemanticVersion SEMANTIC_VERSION = SemanticVersion.of("1.1.0-BETA");
    public static final String MOD_DIR_NAME = "neiRecipeHandlers";
    public static final String ENVIRONMENT_CACHE_FILE_NAME = "environmentCache.dat";
    public static final String RECIPE_CACHE_FILE_NAME = "recipeCache.dat";
    private Logger logger;
    private NEIIntegrationManager neiIntegrationManager;
    private File modDir;
    private File environmentCache;
    private File recipeCache;
    private boolean worldLoaded = false;

    public NEIRecipeHandlersConfiguration getConfig() {
        return this.config;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public NEIIntegrationManager getNEIIntegrationManager() {
        return this.neiIntegrationManager;
    }

    public File getRecipeCache() {
        return this.recipeCache;
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) throws IOException {
        this.logger = event.getModLog();
        this.config = new NEIRecipeHandlersConfiguration(event.getSuggestedConfigurationFile());
        this.logger.info("NEI Integration enabled: " + !this.config.isDisabled());
        try {
            this.modDir = new File(Minecraft.func_71410_x().field_71412_D.getPath() + File.separator + MOD_DIR_NAME);
            if (!this.modDir.exists()) {
                this.modDir.mkdir();
                this.logger.debug("Successfully created the data directory of the mod");
            }
        }
        catch (Exception e) {
            this.logger.error("Couldn't create the data directory: ");
            throw e;
        }
        try {
            this.environmentCache = new File(this.modDir.getPath() + File.separator + ENVIRONMENT_CACHE_FILE_NAME);
            if (!this.environmentCache.exists()) {
                this.environmentCache.createNewFile();
                this.logger.debug("Successfully created the environment cache file");
            }
        }
        catch (Exception e) {
            this.logger.error("Couldn't create the environment cache file: ");
            throw e;
        }
        try {
            this.recipeCache = new File(this.modDir.getPath() + File.separator + RECIPE_CACHE_FILE_NAME);
            if (!this.recipeCache.exists()) {
                this.recipeCache.createNewFile();
                this.logger.debug("Successfully created the recipe cache file");
            }
        }
        catch (Exception e) {
            this.logger.error("Couldn't create the recipe cache file: ");
            throw e;
        }
        this.logger.debug("Version checker enabled: " + this.config.isUseVersionChecker());
        if (!this.config.isDisabled()) {
            this.neiIntegrationManager = new NEIIntegrationManager(this.config, this.logger);
            this.neiIntegrationManager.preInit();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        if (!this.config.isDisabled()) {
            try {
                ItemList.loadItems.restart();
                Thread thread = (Thread)ReflectionHelper.getPrivateValue(RestartableTask.class, (Object)ItemList.loadItems, (String[])new String[]{"thread"});
                if (thread != null) {
                    thread.join();
                }
            }
            catch (Exception e) {
                this.logger.fatal("Couldn't load the NEI item list - the mod cannot be started", (Throwable)e);
            }
        }
        this.neiIntegrationManager.init(this.checkEnvironmentCache());
    }

    private boolean checkEnvironmentCache() {
        boolean canCacheBeUsed = false;
        this.logger.info("Recipe caching enabled: " + this.config.isComplicatedStaticRecipeLoadingCacheEnabled());
        if (this.config.isComplicatedStaticRecipeLoadingCacheEnabled()) {
            Throwable throwable;
            NBTTagCompound currentEnvironmentListTag = new NBTTagCompound();
            for (ModContainer mod : Loader.instance().getModList()) {
                NBTTagCompound modTag = new NBTTagCompound();
                modTag.func_74778_a("Name", mod.getName());
                modTag.func_74778_a("Version", mod.getVersion());
                currentEnvironmentListTag.func_74782_a(mod.getModId(), (NBTBase)modTag);
            }
            boolean recreateEnvironmentCache = true;
            try {
                throwable = null;
                try (FileInputStream in = new FileInputStream(this.environmentCache);){
                    NBTTagCompound savedItemListTag = CompressedStreamTools.func_74796_a((InputStream)in);
                    recreateEnvironmentCache = !savedItemListTag.equals((Object)currentEnvironmentListTag);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                this.logger.warn("The environment cache couldn't be loaded: ", (Throwable)e);
            }
            if (recreateEnvironmentCache) {
                this.logger.info("The environment cache has to be (re)created");
                try {
                    throwable = null;
                    try (FileOutputStream out = new FileOutputStream(this.environmentCache);){
                        CompressedStreamTools.func_74799_a((NBTTagCompound)currentEnvironmentListTag, (OutputStream)out);
                        this.logger.info("Wrote the environment cache to the filesystem");
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Couldn't write the environment cache to the filesystem: ", (Throwable)e);
                }
            }
            canCacheBeUsed = !recreateEnvironmentCache;
        }
        return canCacheBeUsed;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MODID)) {
            this.config.update();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.worldLoaded = true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (this.worldLoaded && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null) {
            this.neiIntegrationManager.onWorldLoad();
            this.worldLoaded = false;
        }
    }
}

