/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.base;

import craftedMods.recipes.api.Recipe;
import craftedMods.recipes.api.RecipeHandlerConfiguration;
import craftedMods.recipes.base.AbstractRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMTRecipeHandler<T extends Recipe>
extends AbstractRecipeHandler<T> {
    protected final Supplier<Collection<IRecipe>> recipesListGetter;

    protected AbstractMTRecipeHandler(String unlocalizedName) {
        super(unlocalizedName);
        this.recipesListGetter = () -> new ArrayList();
    }

    protected AbstractMTRecipeHandler(String unlocalizedName, Supplier<Collection<IRecipe>> recipesListGetter) {
        super(unlocalizedName);
        this.recipesListGetter = recipesListGetter;
    }

    @Override
    public void onPreLoad(RecipeHandlerConfiguration config, Logger logger) {
        super.onPreLoad(config, logger);
        if (this.isMineTweakerSupportEnabled()) {
            this.logger.debug("The MineTweaker API (and eventually additional MineTweaker plugins) were detected - dynamic recipe loading will be enabled");
        }
    }

    protected abstract Collection<T> loadRecipes();

    @Override
    public Collection<T> loadSimpleStaticRecipes() {
        return this.isMineTweakerSupportEnabled() ? null : this.loadRecipes();
    }

    @Override
    public Collection<T> getDynamicCraftingRecipes(ItemStack result) {
        ArrayList<Recipe> ret = new ArrayList<Recipe>();
        if (this.isMineTweakerSupportEnabled()) {
            Collection<T> recipes = this.loadRecipes();
            for (Recipe recipe : recipes) {
                if (!recipe.produces(result)) continue;
                ret.add(recipe);
            }
        }
        return ret;
    }

    @Override
    public Collection<T> getDynamicUsageRecipes(ItemStack ingredient) {
        ArrayList<Recipe> ret = new ArrayList<Recipe>();
        if (this.isMineTweakerSupportEnabled()) {
            Collection<T> recipes = this.loadRecipes();
            for (Recipe recipe : recipes) {
                if (!recipe.consumes(ingredient)) continue;
                ret.add(recipe);
            }
        }
        return ret;
    }

    protected boolean isMineTweakerSupportEnabled() {
        return false;
    }
}

