/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.base;

import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.Recipe;
import craftedMods.recipes.api.utils.ItemStackSet;
import craftedMods.recipes.api.utils.RecipeHandlerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.item.ItemStack;

public abstract class AbstractRecipe
implements Recipe {
    protected final List<ItemStackSet> ingredients = new ArrayList<ItemStackSet>();
    protected final List<ItemStackSet> results = new ArrayList<ItemStackSet>();
    protected final List<ItemStackSet> others = new ArrayList<ItemStackSet>();
    private boolean werePermutationsGenerated = false;

    protected AbstractRecipe(Collection<ItemStack> ingredients, Collection<ItemStack> results, Collection<ItemStack> otherStacks) {
        this.addAll(ingredients, this.ingredients);
        this.addAll(results, this.results);
        this.addAll(otherStacks, this.others);
        this.generatePermutations();
    }

    protected AbstractRecipe() {
    }

    public boolean werePermutationsGenerated() {
        return this.werePermutationsGenerated;
    }

    @Override
    public List<ItemStackSet> getRecipeItems(EnumRecipeItemRole role) {
        switch (role) {
            case INGREDIENT: {
                return this.ingredients;
            }
            case OTHER: {
                return this.others;
            }
            case RESULT: {
                return this.results;
            }
        }
        throw new IllegalArgumentException("Cannot handle the recipe item role \"" + (Object)((Object)role) + "\"");
    }

    protected void addAll(Collection<ItemStack> src, List<ItemStackSet> dest) {
        if (src != null) {
            for (ItemStack stack : src) {
                this.add(stack, dest);
            }
        }
    }

    protected void addAll(ItemStack[] src, List<ItemStackSet> dest) {
        if (src != null) {
            for (ItemStack stack : src) {
                this.add(stack, dest);
            }
        }
    }

    protected void add(ItemStack stack, List<ItemStackSet> dest) {
        dest.add(this.createItemStackSet(stack));
    }

    protected ItemStackSet createItemStackSet(ItemStack ... stacks) {
        return ItemStackSet.create(stacks);
    }

    @Override
    public boolean produces(ItemStack result) {
        for (ItemStackSet permutations : this.results) {
            if (permutations == null) continue;
            for (ItemStack permutation : permutations) {
                if (!RecipeHandlerUtils.getInstance().areStacksSameTypeForCrafting(permutation, result)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean consumes(ItemStack ingredient) {
        for (ItemStackSet permutations : this.ingredients) {
            if (permutations == null) continue;
            for (ItemStack permutation : permutations) {
                if (!RecipeHandlerUtils.getInstance().areStacksSameTypeForCrafting(permutation, ingredient)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getIngredientReplacement(ItemStack defaultReplacement) {
        return defaultReplacement;
    }

    @Override
    public ItemStack getResultReplacement(ItemStack defaultReplacement) {
        return null;
    }

    protected boolean generatePermutations() {
        if (!this.werePermutationsGenerated) {
            this.generatePermutationsForStacks(this.ingredients);
            this.generatePermutationsForStacks(this.results);
            this.generatePermutationsForStacks(this.others);
            this.werePermutationsGenerated = true;
            return true;
        }
        return false;
    }

    protected void generatePermutationsForStacks(List<ItemStackSet> stacks) {
        ListIterator<ItemStackSet> permutationsIterator = stacks.listIterator();
        while (permutationsIterator.hasNext()) {
            ItemStackSet permutations = permutationsIterator.next();
            if (permutations == null) continue;
            permutationsIterator.set(RecipeHandlerUtils.getInstance().generatePermutations(permutations));
        }
    }
}

