/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.base;

import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.base.AbstractMTRecipeHandler;
import craftedMods.recipes.base.AbstractRecipe;
import craftedMods.recipes.base.ShapedRecipe;
import craftedMods.recipes.base.ShapelessRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class CraftingGridRecipeHandler
extends AbstractMTRecipeHandler<AbstractRecipe> {
    public static final int[][] DEFAULT_SHAPELESS_STACKORDER = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};
    protected boolean logUndefinedRecipeTypes = true;

    protected CraftingGridRecipeHandler(String unlocalizedName) {
        super(unlocalizedName);
    }

    protected CraftingGridRecipeHandler(String unlocalizedName, Supplier<Collection<IRecipe>> recipesListGetter) {
        super(unlocalizedName, recipesListGetter);
    }

    @Override
    protected Collection<AbstractRecipe> loadRecipes() {
        ArrayList<AbstractRecipe> ret = new ArrayList<AbstractRecipe>();
        for (IRecipe recipe : (Collection)this.recipesListGetter.get()) {
            boolean isOreHandler;
            boolean nullResult = recipe.func_77571_b() == null || recipe.func_77571_b().func_77973_b() == null;
            boolean undefinedRecipeType = false;
            if (recipe instanceof ShapedOreRecipe) {
                if (nullResult) continue;
                ShapedOreRecipe shapedOreRecipe = (ShapedOreRecipe)recipe;
                isOreHandler = false;
                for (Object ingred : shapedOreRecipe.getInput()) {
                    if (!(ingred instanceof List) || !((List)ingred).isEmpty()) continue;
                    isOreHandler = true;
                    break;
                }
                if (isOreHandler) continue;
                try {
                    ret.add(new ShapedRecipe(shapedOreRecipe));
                }
                catch (Exception e) {
                    this.logger.error("Couldn't load shaped ore recipe: ", (Throwable)e);
                }
            } else if (recipe instanceof ShapedRecipes) {
                if (nullResult) continue;
                ret.add(new ShapedRecipe((ShapedRecipes)recipe));
            } else if (recipe instanceof ShapelessOreRecipe) {
                if (nullResult) continue;
                ShapelessOreRecipe shapelessOreRecipe = (ShapelessOreRecipe)recipe;
                isOreHandler = false;
                for (Object ingred : shapelessOreRecipe.getInput()) {
                    if (!(ingred instanceof List) || !((List)ingred).isEmpty()) continue;
                    isOreHandler = true;
                    break;
                }
                if (isOreHandler) continue;
                ret.add(new ShapelessRecipe(shapelessOreRecipe));
            } else if (recipe instanceof ShapelessRecipes) {
                if (nullResult) continue;
                ShapelessRecipes shapelessRecipe = (ShapelessRecipes)recipe;
                if (shapelessRecipe.field_77579_b != null) {
                    ret.add(new ShapelessRecipe(shapelessRecipe));
                }
            } else {
                this.undefinedRecipeTypeFound(recipe, ret);
                undefinedRecipeType = true;
            }
            if (undefinedRecipeType || !nullResult) continue;
            this.recipeWithNullResultFound(recipe);
        }
        if (this.isMineTweakerSupportEnabled()) {
            ret.addAll(this.staticRecipes);
        }
        this.logUndefinedRecipeTypes = false;
        return ret;
    }

    protected void recipeWithNullResultFound(IRecipe recipe) {
        this.logger.warn("The recipe handler \"" + this.getUnlocalizedName() + "\" got a recipe (\"" + recipe.getClass() + "\") which has null as a result - it'll be ignored");
    }

    protected void undefinedRecipeTypeFound(IRecipe recipe, Collection<AbstractRecipe> container) {
        if (this.logUndefinedRecipeTypes) {
            this.logger.warn("The recipe handler \"" + this.getUnlocalizedName() + "\" got a recipe (\"" + recipe.getClass() + "\") which couldn't be processed");
        }
    }

    @Override
    public List<RecipeItemSlot> getSlotsForRecipeItems(AbstractRecipe recipe, EnumRecipeItemRole role) {
        return this.getSlotsForRecipeItems(recipe, role, DEFAULT_SHAPELESS_STACKORDER);
    }

    protected List<RecipeItemSlot> getSlotsForRecipeItems(AbstractRecipe recipe, EnumRecipeItemRole role, int[][] shapelessStackorder) {
        ArrayList<RecipeItemSlot> ret = new ArrayList<RecipeItemSlot>();
        switch (role) {
            case INGREDIENT: {
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    for (int x = 0; x < shapedRecipe.getWidth(); ++x) {
                        for (int y = 0; y < shapedRecipe.getHeight(); ++y) {
                            ret.add(this.createRecipeItemSlot(25 + x * 18, 6 + y * 18));
                        }
                    }
                } else {
                    if (!(recipe instanceof ShapelessRecipe)) break;
                    ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                    for (int i = 0; i < shapelessRecipe.getRecipeItems(EnumRecipeItemRole.INGREDIENT).size() && i < 9; ++i) {
                        ret.add(this.createRecipeItemSlot(25 + shapelessStackorder[i][0] * 18, 6 + shapelessStackorder[i][1] * 18));
                    }
                }
                break;
            }
            case RESULT: {
                ret.add(this.createRecipeItemSlot(119, 24));
            }
        }
        return ret;
    }
}

