/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.provider;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.Recipe;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.utils.ItemStackSet;
import craftedMods.recipes.provider.NEIRecipeHandlersTransferRectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class PluginRecipeHandler<T extends RecipeHandler<U>, U extends Recipe>
extends TemplateRecipeHandler {
    private RecipeHandler<U> innerHandler;
    private Map<TemplateRecipeHandler.CachedRecipe, Recipe> recipes = new HashMap<TemplateRecipeHandler.CachedRecipe, Recipe>();
    private final String VIEW_ALL_RECIPES_IDENTIFIER;

    public PluginRecipeHandler(RecipeHandler<U> innerHandler) {
        this.innerHandler = innerHandler;
        this.VIEW_ALL_RECIPES_IDENTIFIER = NEIRecipeHandlersTransferRectManager.getViewAllRecipedIdentifier(this.innerHandler);
    }

    public void onUpdate() {
        super.onUpdate();
        this.innerHandler.onUpdate(this.cycleticks);
    }

    public String getRecipeName() {
        return this.innerHandler.getDisplayName();
    }

    public int recipiesPerPage() {
        return this.innerHandler.getRecipesPerPage();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        } else if (outputId.equals(this.VIEW_ALL_RECIPES_IDENTIFIER)) {
            this.loadAllRecipes();
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("item")) {
            this.loadUsageRecipes((ItemStack)ingredients[0]);
        } else if (inputId.equals(this.VIEW_ALL_RECIPES_IDENTIFIER)) {
            this.loadAllRecipes();
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        this.loadRecipes(result, false);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        this.loadRecipes(ingredient, true);
    }

    private void loadRecipes(ItemStack stack, boolean isUsage) {
        this.recipes.clear();
        this.handleRecipe(stack, isUsage, false, this.innerHandler.getStaticRecipes());
        this.handleRecipe(stack, isUsage, true, isUsage ? this.innerHandler.getDynamicUsageRecipes(stack) : this.innerHandler.getDynamicCraftingRecipes(stack));
    }

    private void handleRecipe(ItemStack stack, boolean isUsage, boolean isDynamic, Collection<? extends Recipe> recipes) {
        if (recipes != null) {
            for (Recipe recipe : recipes) {
                if (!isDynamic && !(isUsage ? recipe.consumes(stack) : recipe.produces(stack))) continue;
                PluginCachedRecipe pluginRecipe = new PluginCachedRecipe(recipe);
                if (isUsage ? pluginRecipe.contains(pluginRecipe.ingredients, stack) && recipe.getIngredientReplacement(stack) != null : pluginRecipe.contains(pluginRecipe.others, stack) && recipe.getResultReplacement(stack) != null) {
                    pluginRecipe.setIngredientPermutation(isUsage ? pluginRecipe.ingredients : pluginRecipe.others, isUsage ? recipe.getIngredientReplacement(stack) : recipe.getResultReplacement(stack));
                }
                this.recipes.put(pluginRecipe, recipe);
                this.arecipes.add(pluginRecipe);
            }
        }
    }

    private void loadAllRecipes() {
        Collection<U> recipes;
        this.recipes.clear();
        if (this.innerHandler.getRecipeViewer() != null && (recipes = this.innerHandler.getRecipeViewer().getAllRecipes()) != null) {
            recipes.forEach(recipe -> {
                PluginCachedRecipe cachedRecipe = new PluginCachedRecipe((Recipe)recipe);
                this.recipes.put(cachedRecipe, (Recipe)recipe);
                this.arecipes.add(cachedRecipe);
            });
        }
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.innerHandler.getRenderer() != null) {
            this.innerHandler.getRenderer().renderBackground(this.innerHandler, this.getRecipe(recipeIndex), this.cycleticks);
        } else {
            super.drawBackground(recipeIndex);
        }
    }

    public void drawForeground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        if (this.innerHandler.getRenderer() != null) {
            this.innerHandler.getRenderer().renderForeground(this.innerHandler, this.getRecipe(recipeIndex), this.cycleticks);
        } else {
            super.drawForeground(recipeIndex);
        }
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public TemplateRecipeHandler newInstance() {
        return new PluginRecipeHandler<T, U>(this.innerHandler);
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return this.innerHandler.getCraftingHelper() != null && this.innerHandler.getCraftingHelper().getSupportedGUIClasses(this.getRecipe(recipe)).contains(gui.getClass());
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipeIndex) {
        U recipe = this.getRecipe(recipeIndex);
        return this.innerHandler.getCraftingHelper() != null && this.innerHandler.getCraftingHelper().getSupportedGUIClasses(recipe).contains(gui.getClass()) ? new OverlayHandler(this.innerHandler.getCraftingHelper().getOffsetX(gui.getClass(), recipe), this.innerHandler.getCraftingHelper().getOffsetY(gui.getClass(), recipe)) : null;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipeIndex) {
        U recipe = this.getRecipe(recipeIndex);
        return this.innerHandler.getCraftingHelper() != null && this.innerHandler.getCraftingHelper().getSupportedGUIClasses(recipe).contains(gui.getClass()) ? new DefaultOverlayRenderer(this.getIngredientStacks(recipeIndex), (IStackPositioner)new DefaultIStackPositioner(this.innerHandler.getCraftingHelper().getOffsetX(gui.getClass(), recipe), this.innerHandler.getCraftingHelper().getOffsetY(gui.getClass(), recipe))) : null;
    }

    private U getRecipe(int index) {
        return (U)this.recipes.get(this.arecipes.get(index));
    }

    public RecipeHandler<U> getInnerHandler() {
        return this.innerHandler;
    }

    private class PluginCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final Recipe recipe;
        private final List<PositionedStack> ingredients;
        private final List<PositionedStack> others;
        private final boolean isDynamic;

        public PluginCachedRecipe(Recipe recipe) {
            this(recipe, false);
        }

        public PluginCachedRecipe(Recipe recipe, boolean isDynamic) {
            super((TemplateRecipeHandler)PluginRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.others = new ArrayList<PositionedStack>();
            this.recipe = recipe;
            this.isDynamic = isDynamic;
            this.initIngreds();
            this.initOthers();
        }

        private void initIngreds() {
            this.ingredients.clear();
            this.addRecipeItems(this.recipe.getRecipeItems(EnumRecipeItemRole.INGREDIENT), this.ingredients, this.recipe, PluginRecipeHandler.this.innerHandler.getSlotsForRecipeItems(this.recipe, EnumRecipeItemRole.INGREDIENT));
        }

        private void initOthers() {
            this.others.clear();
            this.addRecipeItems(this.recipe.getRecipeItems(EnumRecipeItemRole.RESULT), this.others, this.recipe, PluginRecipeHandler.this.innerHandler.getSlotsForRecipeItems(this.recipe, EnumRecipeItemRole.RESULT));
            this.addRecipeItems(this.recipe.getRecipeItems(EnumRecipeItemRole.OTHER), this.others, this.recipe, PluginRecipeHandler.this.innerHandler.getSlotsForRecipeItems(this.recipe, EnumRecipeItemRole.OTHER));
        }

        private void addRecipeItems(List<ItemStackSet> source, List<PositionedStack> target, Recipe recipe, List<RecipeItemSlot> slotList) {
            for (int i = 0; i < source.size(); ++i) {
                ItemStackSet items = source.get(i);
                if (items == null) continue;
                RecipeItemSlot slot = i < slotList.size() ? slotList.get(i) : null;
                int x = 0;
                int y = 0;
                if (slot != null) {
                    x = slot.getX();
                    y = slot.getY();
                }
                target.add(new PositionedStack(new ArrayList<ItemStack>(items), x, y));
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getIngredients() {
            if (this.isDynamic && PluginRecipeHandler.this.cycleticks % 20 == 0) {
                this.initIngreds();
            }
            return this.getCycledIngredients(PluginRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public List<PositionedStack> getOtherStacks() {
            if (this.isDynamic && PluginRecipeHandler.this.cycleticks % 20 == 0) {
                this.initOthers();
            }
            return this.getCycledIngredients(PluginRecipeHandler.this.cycleticks / 20, this.others);
        }
    }

    private class DefaultIStackPositioner
    implements IStackPositioner {
        private final int offsetX;
        private final int offsetY;

        public DefaultIStackPositioner(int offsetX, int offsetY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public ArrayList<PositionedStack> positionStacks(ArrayList<PositionedStack> ingredients) {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            for (PositionedStack stack : ingredients) {
                ret.add(new PositionedStack((Object)stack.items, stack.relx + this.offsetX, stack.rely + this.offsetY, false));
            }
            return ret;
        }
    }

    private class OverlayHandler
    extends DefaultOverlayHandler {
        public OverlayHandler(int offsetX, int offsetY) {
            super(offsetX, offsetY);
        }

        protected boolean canStack(ItemStack stack1, ItemStack stack2) {
            return PluginRecipeHandler.this.innerHandler.getCraftingHelper().matches(stack1, stack2);
        }
    }
}

