/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.provider.recipeHandlers;

import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeHandlerConfiguration;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.RecipeHandlerRenderer;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.utils.RecipeHandlerRendererUtils;
import craftedMods.recipes.api.utils.RecipeHandlerUtils;
import craftedMods.recipes.base.AbstractMTRecipeHandler;
import craftedMods.recipes.base.AbstractRecipeViewer;
import craftedMods.recipes.base.FurnaceRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import org.apache.logging.log4j.Logger;

@RegisteredHandler
public class VanillaFurnaceRecipeHandler
extends AbstractMTRecipeHandler<FurnaceRecipe> {
    private final VanillaFurnaceRecipeHandlerRenderer renderer = new VanillaFurnaceRecipeHandlerRenderer();
    private final VanillaFurnaceRecipeHandlerRecipeViewer recipeViewer = new VanillaFurnaceRecipeHandlerRecipeViewer(this);

    public VanillaFurnaceRecipeHandler() {
        super("vanilla.furnace");
    }

    @Override
    public String getDisplayName() {
        return Blocks.field_150460_al.func_149732_F();
    }

    @Override
    public void onPreLoad(RecipeHandlerConfiguration config, Logger logger) {
        super.onPreLoad(config, logger);
        this.removeRecipeHandler("codechicken.nei.recipe.FurnaceRecipeHandler");
    }

    private void removeRecipeHandler(String recipeHandlerClass) {
        try {
            RecipeHandlerUtils.getInstance().removeNativeRecipeHandler(recipeHandlerClass);
        }
        catch (Exception e) {
            this.logger.error(String.format("Couldn't remove the native recipe handler \"%s\"", recipeHandlerClass));
        }
    }

    @Override
    protected Collection<FurnaceRecipe> loadRecipes() {
        ArrayList<FurnaceRecipe> ret = new ArrayList<FurnaceRecipe>();
        FurnaceRecipes.func_77602_a().func_77599_b().forEach((ingredient, result) -> ret.add(new FurnaceRecipe((ItemStack)ingredient, (ItemStack)result)));
        return ret;
    }

    @Override
    public List<RecipeItemSlot> getSlotsForRecipeItems(FurnaceRecipe recipe, EnumRecipeItemRole role) {
        ArrayList<RecipeItemSlot> ret = new ArrayList<RecipeItemSlot>();
        switch (role) {
            case INGREDIENT: {
                ret.add(this.createRecipeItemSlot(51, 6));
                break;
            }
            case OTHER: {
                ret.add(this.createRecipeItemSlot(51, 42));
                break;
            }
            case RESULT: {
                ret.add(this.createRecipeItemSlot(111, 24));
            }
        }
        return ret;
    }

    @Override
    public VanillaFurnaceRecipeHandlerRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public RecipeHandlerRecipeViewer<FurnaceRecipe> getRecipeViewer() {
        return this.recipeViewer;
    }

    @Override
    protected boolean isMineTweakerSupportEnabled() {
        return RecipeHandlerUtils.getInstance().hasMineTweaker();
    }

    @Override
    public int getDefaultOrder() {
        return 1000;
    }

    public class VanillaFurnaceRecipeHandlerRecipeViewer
    extends AbstractRecipeViewer<FurnaceRecipe, VanillaFurnaceRecipeHandler> {
        private final Collection<Class<? extends GuiContainer>> supportedGuiClasses;

        public VanillaFurnaceRecipeHandlerRecipeViewer(VanillaFurnaceRecipeHandler handler) {
            super(handler);
            this.supportedGuiClasses = new ArrayList<Class<? extends GuiContainer>>();
            this.supportedGuiClasses.addAll(AbstractRecipeViewer.RECIPE_HANDLER_GUIS);
            this.supportedGuiClasses.add(GuiFurnace.class);
        }

        @Override
        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses() {
            return this.supportedGuiClasses;
        }

        @Override
        public Collection<FurnaceRecipe> getAllRecipes() {
            return ((VanillaFurnaceRecipeHandler)this.handler).isMineTweakerSupportEnabled() ? ((VanillaFurnaceRecipeHandler)this.handler).loadRecipes() : ((VanillaFurnaceRecipeHandler)this.handler).getStaticRecipes();
        }

        @Override
        public int getOffsetX(Class<? extends GuiContainer> guiClass) {
            return guiClass == GuiFurnace.class ? 18 : 8;
        }
    }

    public class VanillaFurnaceRecipeHandlerRenderer
    implements RecipeHandlerRenderer<VanillaFurnaceRecipeHandler, FurnaceRecipe> {
        @Override
        public void renderBackground(VanillaFurnaceRecipeHandler handler, FurnaceRecipe recipe, int cycleticks) {
            RecipeHandlerRendererUtils.getInstance().bindTexture("textures/gui/container/furnace.png");
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(0, 0, 5, 11, 166, 65);
            RecipeHandlerRendererUtils.getInstance().drawRectangle(106, 19, 26, 26, -3750202);
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(106, 13, 51, 6, 22, 28);
            RecipeHandlerRendererUtils.getInstance().drawProgressBar(74, 23, 176, 14, 24, 16, (float)(cycleticks % 48) / 48.0f, RecipeHandlerRendererUtils.EnumProgressBarDirection.INCREASE_RIGHT);
            RecipeHandlerRendererUtils.getInstance().drawProgressBar(51, 25, 176, 0, 14, 14, (float)(cycleticks % 48) / 48.0f, RecipeHandlerRendererUtils.EnumProgressBarDirection.DECREASE_DOWN);
        }

        @Override
        public void renderForeground(VanillaFurnaceRecipeHandler handler, FurnaceRecipe recipe, int cycleticks) {
        }
    }
}

