/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.utils;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.guihook.GuiContainerManager;
import craftedMods.recipes.NEIRecipeHandlers;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.utils.ItemStackSet;
import craftedMods.recipes.api.utils.RecipeHandlerUtils;
import craftedMods.recipes.utils.NEIRecipeHandlersUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;

public class RecipeHandlerUtilsImpl
implements RecipeHandlerUtils {
    private List<ItemStack> fuels;
    private Boolean hasMineTweaker = null;

    @Override
    public ItemStackSet generatePermutations(ItemStack ... stacks) {
        return NEIRecipeHandlersUtils.generatePermutations(Arrays.asList(stacks));
    }

    @Override
    public ItemStackSet generatePermutations(Collection<ItemStack> stacks) {
        return NEIRecipeHandlersUtils.generatePermutations(stacks);
    }

    @Override
    public boolean areStacksSameType(ItemStack stack1, ItemStack stack2) {
        return NEIRecipeHandlersUtils.areStacksSameType(stack1, stack2);
    }

    @Override
    public boolean areStacksSameTypeForCrafting(ItemStack stack1, ItemStack stack2) {
        return NEIRecipeHandlersUtils.areStacksSameTypeForCrafting(stack1, stack2);
    }

    @Override
    public ItemStack[] extractRecipeItems(Object container) {
        return NEIRecipeHandlersUtils.extractRecipeItems(container);
    }

    @Override
    public List<ItemStack> getItemList() {
        return NEIRecipeHandlersUtils.getItemList();
    }

    @Override
    public Collection<ItemStack> readItemStackListFromNBT(NBTTagCompound compound, String tagName) {
        return NEIRecipeHandlersUtils.readItemStackListFromNBT(compound, tagName);
    }

    @Override
    public void writeItemStackListToNBT(NBTTagCompound compound, String tagName, Collection<? extends ItemStack> stacks) {
        NEIRecipeHandlersUtils.writeItemStackListToNBT(compound, tagName, stacks);
    }

    @Override
    public List<RecipeItemSlot> offset(List<RecipeItemSlot> slotsList, int xOffset, int yOffset) {
        return NEIRecipeHandlersUtils.offset(slotsList, xOffset, yOffset);
    }

    @Override
    public void forceRecipeCacheRefresh() {
        NEIRecipeHandlers.mod.getNEIIntegrationManager().refreshCache();
    }

    @Override
    public String getResourceDomain() {
        return "neirecipehandlers";
    }

    @Override
    public ItemStackSet getFuels() {
        if (this.fuels == null) {
            HashSet<Item> excludedfuels = new HashSet<Item>();
            excludedfuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
            excludedfuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
            excludedfuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
            excludedfuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
            excludedfuels.add(Item.func_150898_a((Block)Blocks.field_150466_ao));
            excludedfuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
            this.fuels = new ArrayList<ItemStack>();
            for (ItemStack item : RecipeHandlerUtils.getInstance().getItemList()) {
                int burnTime;
                if (excludedfuels.contains(item.func_77973_b()) || (burnTime = TileEntityFurnace.func_145952_a((ItemStack)item)) <= 0) continue;
                this.fuels.add(item.func_77946_l());
            }
        }
        return ItemStackSet.create(this.fuels);
    }

    @Override
    public void removeNativeRecipeHandler(String recipeHandlerClass) throws ClassNotFoundException {
        NEIRecipeHandlers.mod.getNEIIntegrationManager().removeRecipeHandler(recipeHandlerClass);
    }

    @Override
    public void writeItemStackToNBT(ItemStack stack, NBTTagCompound compound) {
        NEIRecipeHandlersUtils.writeItemStackToNBT(stack, compound);
    }

    @Override
    public ItemStack readItemStackFromNBT(NBTTagCompound compound) {
        return NEIRecipeHandlersUtils.readItemStackFromNBT(compound);
    }

    @Override
    public boolean isNEIGuiOpen() {
        return NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden() && GuiContainerManager.getManager() != null && (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainerCreative) || ((GuiContainerCreative)Minecraft.func_71410_x().field_71462_r).func_147056_g() == CreativeTabs.field_78036_m.func_78021_a());
    }

    @Override
    public boolean hasMineTweaker() {
        if (this.hasMineTweaker == null) {
            try {
                Class.forName("minetweaker.MineTweakerAPI");
                this.hasMineTweaker = Boolean.TRUE;
            }
            catch (Exception e) {
                this.hasMineTweaker = Boolean.FALSE;
            }
        }
        return this.hasMineTweaker;
    }
}

