/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium;

import com.falsepattern.falsetweaks.api.ThreadedChunkUpdates;
import com.falsepattern.falsetweaks.api.dynlights.FTDynamicLights;
import com.falsepattern.falsetweaks.modules.dynlights.base.DynamicLights;
import com.falsepattern.rple.internal.client.dynlights.ColorDynamicLights;
import cpw.mods.fml.common.Loader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import makamys.neodymium.Constants;
import makamys.neodymium.config.Config;
import makamys.neodymium.util.virtualjar.IVirtualJar;
import makamys.neodymium.util.virtualjar.VirtualJar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.launchwrapper.Launch;
import org.lwjgl.opengl.GLContext;
import shadersmod.client.Shaders;

public class Compat {
    private static boolean isGL33Supported;
    private static boolean wasAdvancedOpenGLEnabled;
    private static boolean IS_RPLE_PRESENT;
    private static boolean IS_FALSE_TWEAKS_PRESENT;
    private static boolean IS_HODGEPODGE_SPEEDUP_ANIMATIONS_ENABLED;
    private static boolean IS_ANGELICA_SPEEDUP_ANIMATIONS_ENABLED;
    private static boolean IS_SHADERS_MOD_PRESENT;
    private static boolean isShadersEnabled;

    public static void init() {
        isGL33Supported = GLContext.getCapabilities().OpenGL33;
        if (Loader.isModLoaded((String)"rple")) {
            IS_RPLE_PRESENT = true;
        }
        if (Loader.isModLoaded((String)"falsetweaks")) {
            IS_FALSE_TWEAKS_PRESENT = true;
        }
        try {
            if (Launch.classLoader.getClassBytes("shadersmod.client.Shaders") != null) {
                IS_SHADERS_MOD_PRESENT = true;
            }
        }
        catch (IOException e) {
            IS_SHADERS_MOD_PRESENT = false;
        }
        IS_HODGEPODGE_SPEEDUP_ANIMATIONS_ENABLED = Compat.checkIfHodgepodgeSpeedupAnimationsIsEnabled();
        IS_ANGELICA_SPEEDUP_ANIMATIONS_ENABLED = Compat.checkIfAngelicaSpeedupAnimationsIsEnabled();
        Constants.LOGGER.debug("speedupAnimations compat fix will " + (Compat.isSpeedupAnimationsEnabled() ? "" : "not ") + "be enabled");
    }

    public static boolean enableVanillaChunkMeshes() {
        return Config.enableVanillaChunkMeshes && !Compat.isFalseTweaksModPresent();
    }

    public static boolean keepRenderListLogic() {
        return Compat.enableVanillaChunkMeshes() || Constants.KEEP_RENDER_LIST_LOGIC;
    }

    private static boolean checkIfHodgepodgeSpeedupAnimationsIsEnabled() {
        Boolean result = null;
        if (Loader.isModLoaded((String)"hodgepodge")) {
            try {
                Boolean speedupAnimations;
                Class<?> FixesConfigCls = Class.forName("com.mitchej123.hodgepodge.config.FixesConfig");
                result = speedupAnimations = (Boolean)FixesConfigCls.getField("speedupAnimations").get(null);
            }
            catch (Exception e) {
                Constants.LOGGER.debug("Failed to determine if Hodgepodge's speedupAnimations is enabled using new config class, trying old one.", (Throwable)e);
            }
            if (result == null) {
                try {
                    Class<?> CommonCls = Class.forName("com.mitchej123.hodgepodge.Common");
                    Object config = CommonCls.getField("config").get(null);
                    Class<?> configCls = config.getClass();
                    boolean speedupAnimations = (Boolean)configCls.getField("speedupAnimations").get(config);
                    result = speedupAnimations;
                }
                catch (Exception e) {
                    Constants.LOGGER.debug("Failed to determine if Hodgepodge's speedupAnimations is enabled using old config class.", (Throwable)e);
                }
            }
            if (result != null) {
                Constants.LOGGER.debug("Hodgepodge's speedupAnimations is set to " + result);
            } else {
                Constants.LOGGER.warn("Failed to determine if Hodgepodge's speedupAnimations is enabled, assuming false");
                result = false;
            }
        } else {
            Constants.LOGGER.debug("Hodgepodge is missing, treating its speedupAnimations as false");
            result = false;
        }
        return result;
    }

    private static boolean checkIfAngelicaSpeedupAnimationsIsEnabled() {
        Boolean result = null;
        if (Loader.isModLoaded((String)"angelica")) {
            try {
                Boolean speedupAnimations;
                Class<?> AngelicaConfigCls = Class.forName("com.gtnewhorizons.angelica.config.AngelicaConfig");
                result = speedupAnimations = (Boolean)AngelicaConfigCls.getField("speedupAnimations").get(null);
            }
            catch (Exception e) {
                Constants.LOGGER.debug("Failed to determine if Angelica's speedupAnimations is enabled.", (Throwable)e);
            }
            if (result != null) {
                Constants.LOGGER.debug("Angelica's speedupAnimations is set to " + result);
            } else {
                Constants.LOGGER.warn("Failed to determine if Angelica's speedupAnimations is enabled, assuming false");
                result = false;
            }
        } else {
            Constants.LOGGER.debug("Angelica is missing, treating its speedupAnimations as false");
            result = false;
        }
        return result;
    }

    public static boolean isRPLEModPresent() {
        return IS_RPLE_PRESENT;
    }

    public static boolean isFalseTweaksModPresent() {
        return IS_FALSE_TWEAKS_PRESENT;
    }

    public static boolean ft$isDynamicLights() {
        if (IS_FALSE_TWEAKS_PRESENT) {
            return FalseTweaksCompat.isDynamicLights();
        }
        return false;
    }

    public static boolean ft$isDynamicLightsCircular() {
        if (IS_FALSE_TWEAKS_PRESENT) {
            return FalseTweaksCompat.isDynamicLightsCircular();
        }
        return false;
    }

    public static Tessellator tessellator() {
        if (IS_FALSE_TWEAKS_PRESENT) {
            return FalseTweaksCompat.getThreadTessellator();
        }
        return Tessellator.field_78398_a;
    }

    public static boolean isSpeedupAnimationsEnabled() {
        return IS_HODGEPODGE_SPEEDUP_ANIMATIONS_ENABLED || IS_ANGELICA_SPEEDUP_ANIMATIONS_ENABLED;
    }

    public static boolean isOptiFineShadersEnabled() {
        return isShadersEnabled;
    }

    public static void updateOptiFineShadersState() {
        isShadersEnabled = false;
        if (!IS_SHADERS_MOD_PRESENT) {
            return;
        }
        if (Shaders.getShaderPackName() != null) {
            isShadersEnabled = true;
        }
    }

    public static boolean isShadersShadowPass() {
        if (!IS_SHADERS_MOD_PRESENT) {
            return false;
        }
        return Shaders.isShadowPass;
    }

    public static void getCompatibilityWarnings(List<Warning> warns, List<Warning> criticalWarns, boolean statusCommand) {
        if (Minecraft.func_71410_x().field_71474_y.field_74349_h) {
            warns.add(new Warning("Advanced OpenGL is enabled, performance may be poor." + (statusCommand ? " Click here to disable it." : "")).chatAction("neodymium disable_advanced_opengl"));
        }
        if (!isGL33Supported) {
            criticalWarns.add(new Warning("OpenGL 3.3 is not supported."));
        }
    }

    public static boolean hasChanged() {
        boolean changed = false;
        boolean advGL = Minecraft.func_71410_x().field_71474_y.field_74349_h;
        if (advGL != wasAdvancedOpenGLEnabled) {
            changed = true;
        }
        wasAdvancedOpenGLEnabled = advGL;
        return changed;
    }

    public static void forceEnableOptiFineDetectionOfFastCraft() {
        if (Compat.class.getResource("/fastcraft/Tweaker.class") != null) {
            Constants.LOGGER.info("FastCraft is present, applying hack to forcingly enable FastCraft's OptiFine compat");
            VirtualJar.add(new OptiFineStubVirtualJar());
        }
    }

    public static boolean disableAdvancedOpenGL() {
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (gameSettings.field_74349_h) {
            gameSettings.field_74349_h = false;
            gameSettings.func_74303_b();
            return true;
        }
        return false;
    }

    public static class Warning {
        public String text;
        public String chatAction;

        public Warning(String text) {
            this.text = text;
        }

        public Warning chatAction(String command) {
            this.chatAction = command;
            return this;
        }
    }

    public static class RPLECompat {
        public static short getLightLevel(Entity entity) {
            return ColorDynamicLights.INSTANCE.getLightLevel(entity);
        }
    }

    public static class FalseTweaksCompat {
        public static Tessellator getThreadTessellator() {
            if (ThreadedChunkUpdates.isEnabled()) {
                return ThreadedChunkUpdates.getThreadTessellator();
            }
            return Tessellator.field_78398_a;
        }

        public static boolean isDynamicLights() {
            return FTDynamicLights.isDynamicLights();
        }

        public static boolean isDynamicLightsCircular() {
            return FTDynamicLights.isCircular();
        }

        public static int getLightLevel(Entity entity) {
            return DynamicLights.INSTANCE.getLightLevel(entity);
        }
    }

    private static class OptiFineStubVirtualJar
    implements IVirtualJar {
        private OptiFineStubVirtualJar() {
        }

        @Override
        public String getName() {
            return "optifine-stub";
        }

        @Override
        public InputStream getInputStream(String path) {
            if (path.equals("/optifine/OptiFineForgeTweaker.class")) {
                Constants.LOGGER.debug("Returning a dummy /optifine/OptiFineForgeTweaker.class to force FastCraft compat.");
                return new ByteArrayInputStream(new byte[0]);
            }
            return null;
        }
    }
}

