/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import java.util.Comparator;
import makamys.neodymium.renderer.Mesh;
import makamys.neodymium.renderer.NeoRegion;

public class Comparators {
    public static final MeshDistanceComparator MESH_DISTANCE_COMPARATOR = new MeshDistanceComparator();
    public static final RegionDistanceComparator REGION_DISTANCE_COMPARATOR = new RegionDistanceComparator();

    public static class RegionDistanceComparator
    implements Comparator<NeoRegion> {
        double x;
        double y;
        double z;

        public RegionDistanceComparator setOrigin(double x, double y, double z) {
            this.x = x / 1024.0;
            this.y = y / 1024.0;
            this.z = z / 1024.0;
            return this;
        }

        @Override
        public int compare(NeoRegion a, NeoRegion b) {
            double distSqB;
            double distSqA = a.distSq(this.x, this.y, this.z);
            if (distSqA > (distSqB = b.distSq(this.x, this.y, this.z))) {
                return 1;
            }
            if (distSqA < distSqB) {
                return -1;
            }
            return 0;
        }
    }

    public static class MeshDistanceComparator
    implements Comparator<Mesh> {
        double x;
        double y;
        double z;
        boolean inverted;

        public Comparator<? super Mesh> setInverted(boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public MeshDistanceComparator setOrigin(double x, double y, double z) {
            this.x = x / 16.0;
            this.y = y / 16.0;
            this.z = z / 16.0;
            return this;
        }

        @Override
        public int compare(Mesh a, Mesh b) {
            int mult;
            if (a.pass < b.pass) {
                return -1;
            }
            if (a.pass > b.pass) {
                return 1;
            }
            double distSqA = a.distSq(this.x, this.y, this.z);
            double distSqB = b.distSq(this.x, this.y, this.z);
            int n = mult = this.inverted ? -1 : 1;
            if (distSqA > distSqB) {
                return 1 * mult;
            }
            if (distSqA < distSqB) {
                return -1 * mult;
            }
            return 0;
        }
    }
}

