/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import lombok.Generated;
import makamys.neodymium.Neodymium;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.PolygonNormal;
import makamys.neodymium.renderer.compat.RenderUtil;
import makamys.neodymium.util.Util;
import org.lwjgl.util.vector.Vector3f;

public final class MeshPolygon {
    public static final int DEFAULT_BRIGHTNESS = Util.createBrightness(15, 15);
    public static final int DEFAULT_COLOR = -1;
    private static final ThreadLocal<Vectors> VECTORS = ThreadLocal.withInitial(() -> new Vectors());

    public static boolean processPolygon(int[] tessBuffer, int tessOffset, int[] polygonBuffer, int polygonOffset, float offsetX, float offsetY, float offsetZ, boolean triangulate, ChunkMesh.Flags flags) {
        int offset;
        RenderUtil util = Neodymium.util;
        int tessVertexSize = util.vertexSizeInTessellator();
        int polygonVertexSize = util.vertexSizeInPolygonBuffer();
        for (int i = 0; i < 3; ++i) {
            util.polygonize(tessBuffer, tessOffset + i * tessVertexSize, polygonBuffer, polygonOffset + i * polygonVertexSize, offsetX, offsetY, offsetZ, flags);
        }
        if (triangulate) {
            util.polygonize(tessBuffer, tessOffset + 3 * tessVertexSize, polygonBuffer, polygonOffset + 3 * polygonVertexSize + 1, offsetX, offsetY, offsetZ, flags);
            util.polygonize(tessBuffer, tessOffset, polygonBuffer, polygonOffset + 4 * polygonVertexSize + 1, offsetX, offsetY, offsetZ, flags);
            util.polygonize(tessBuffer, tessOffset + 2 * tessVertexSize, polygonBuffer, polygonOffset + 5 * polygonVertexSize + 1, offsetX, offsetY, offsetZ, flags);
        }
        boolean deleted = true;
        for (int i = 1; i < 3; ++i) {
            int offset2 = polygonOffset + polygonVertexSize * i;
            if (polygonBuffer[polygonOffset + 0] == polygonBuffer[offset2 + 0] && polygonBuffer[polygonOffset + 1] == polygonBuffer[offset2 + 1] && polygonBuffer[polygonOffset + 2] == polygonBuffer[offset2 + 2]) continue;
            deleted = false;
            break;
        }
        if (triangulate && (polygonBuffer[polygonOffset + 0] != polygonBuffer[(offset = polygonOffset + polygonVertexSize * 3 + 1) + 0] || polygonBuffer[polygonOffset + 1] != polygonBuffer[offset + 1] || polygonBuffer[polygonOffset + 2] != polygonBuffer[offset + 2])) {
            deleted = false;
        }
        if (deleted) {
            return true;
        }
        float X0 = Float.intBitsToFloat(polygonBuffer[polygonOffset + 0]);
        float Y0 = Float.intBitsToFloat(polygonBuffer[polygonOffset + 1]);
        float Z0 = Float.intBitsToFloat(polygonBuffer[polygonOffset + 2]);
        float X1 = Float.intBitsToFloat(polygonBuffer[polygonOffset + polygonVertexSize + 0]);
        float Y1 = Float.intBitsToFloat(polygonBuffer[polygonOffset + polygonVertexSize + 1]);
        float Z1 = Float.intBitsToFloat(polygonBuffer[polygonOffset + polygonVertexSize + 2]);
        float X2 = Float.intBitsToFloat(polygonBuffer[polygonOffset + polygonVertexSize * 2 + 0]);
        float Y2 = Float.intBitsToFloat(polygonBuffer[polygonOffset + polygonVertexSize * 2 + 1]);
        float Z2 = Float.intBitsToFloat(polygonBuffer[polygonOffset + polygonVertexSize * 2 + 2]);
        Vectors vectors = VECTORS.get();
        vectors.A.set(X1 - X0, Y1 - Y0, Z1 - Z0);
        vectors.B.set(X2 - X1, Y2 - Y1, Z2 - Z1);
        Vector3f.cross((Vector3f)vectors.A, (Vector3f)vectors.B, (Vector3f)vectors.C);
        polygonBuffer[polygonOffset + polygonVertexSize * 3] = PolygonNormal.fromVector(vectors.C).ordinal();
        if (triangulate) {
            float X3 = Float.intBitsToFloat(polygonBuffer[polygonOffset + polygonVertexSize * 3 + 1 + 0]);
            float Y3 = Float.intBitsToFloat(polygonBuffer[polygonOffset + polygonVertexSize * 3 + 1 + 1]);
            float Z3 = Float.intBitsToFloat(polygonBuffer[polygonOffset + polygonVertexSize * 3 + 1 + 2]);
            vectors.A.set(X0 - X3, Y0 - Y3, Z0 - Z3);
            vectors.B.set(X2 - X0, Y2 - Y0, Z2 - Z0);
            Vector3f.cross((Vector3f)vectors.A, (Vector3f)vectors.B, (Vector3f)vectors.C);
            polygonBuffer[polygonOffset + polygonVertexSize * 6 + 1] = PolygonNormal.fromVector(vectors.C).ordinal();
        }
        return false;
    }

    @Generated
    private MeshPolygon() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class Vectors {
        public final Vector3f A = new Vector3f();
        public final Vector3f B = new Vector3f();
        public final Vector3f C = new Vector3f();

        private Vectors() {
        }
    }
}

