/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import makamys.neodymium.renderer.Comparators;
import makamys.neodymium.renderer.GPUMemoryManager;
import makamys.neodymium.renderer.Mesh;
import makamys.neodymium.renderer.NeoChunk;
import makamys.neodymium.util.Util;
import net.minecraft.entity.Entity;

public class NeoRegion {
    public static final int SIZE = 64;
    private NeoChunk[][] data = new NeoChunk[64][64];
    private List<RenderData> renderData = new ArrayList<RenderData>();
    int regionX;
    int regionZ;
    public int meshes = 0;
    private int emptyTicks = 0;

    public RenderData getRenderData(GPUMemoryManager manager) {
        int index = manager.managerIndex;
        while (this.renderData.size() <= index) {
            this.renderData.add(new RenderData(this.regionX * 64 * 16, 0.0, this.regionZ * 64 * 16));
        }
        return this.renderData.get(index);
    }

    public NeoRegion(int regionX, int regionZ) {
        this.regionX = regionX;
        this.regionZ = regionZ;
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                this.data[i][j] = new NeoChunk(regionX * 64 + i, regionZ * 64 + j, this);
            }
        }
    }

    public static NeoRegion load(int regionX, int regionZ) {
        return new NeoRegion(regionX, regionZ);
    }

    public NeoChunk getChunkAbsolute(int chunkXAbs, int chunkZAbs) {
        return this.getChunk(chunkXAbs - this.regionX * 64, chunkZAbs - this.regionZ * 64);
    }

    public NeoChunk getChunk(int x, int z) {
        if (x >= 0 && x < 64 && z >= 0 && z < 64) {
            return this.data[x][z];
        }
        return null;
    }

    public void tick() {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                NeoChunk chunk = this.data[i][j];
                if (chunk == null) continue;
                chunk.tick();
            }
        }
        this.emptyTicks = this.meshes == 0 ? ++this.emptyTicks : 0;
    }

    public void destroy() {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                NeoChunk chunk = this.data[i][j];
                if (chunk == null) continue;
                chunk.destroy();
            }
        }
    }

    public double distanceTaxicab(Entity entity) {
        double centerX = (this.regionX * 64 + 32) * 16;
        double centerZ = (this.regionZ * 64 + 32) * 16;
        return Math.max(Math.abs(centerX - entity.field_70165_t), Math.abs(centerZ - entity.field_70161_v));
    }

    public double distSq(double x, double y, double z) {
        return Util.distSq((double)this.regionX + 0.5, 0.0, (double)this.regionZ + 0.5, x, y, z);
    }

    public static float toRelativeOffset(double d) {
        return (float)(d - Math.floor(d / 1024.0) * 64.0 * 16.0);
    }

    public String toString() {
        return "NeoRegion(" + this.regionX + ", " + this.regionZ + ")[n=" + this.meshes + "]";
    }

    public boolean shouldDelete() {
        return this.emptyTicks > 100;
    }

    @Generated
    public List<RenderData> getRenderData() {
        return this.renderData;
    }

    public static class RenderData {
        public final double originX;
        public final double originY;
        public final double originZ;
        private final List<Mesh> sentMeshes = new ArrayList<Mesh>();
        public int batchLimit;
        public int batchFirst;

        public void sort(double eyePosX, double eyePosY, double eyePosZ, boolean pass0, boolean pass1) {
            if (pass0) {
                this.sentMeshes.sort(Comparators.MESH_DISTANCE_COMPARATOR.setOrigin(eyePosX, eyePosY, eyePosZ).setInverted(false));
            }
            if (pass1) {
                this.sentMeshes.sort(Comparators.MESH_DISTANCE_COMPARATOR.setOrigin(eyePosX, eyePosY, eyePosZ).setInverted(true));
            }
        }

        @Generated
        public RenderData(double originX, double originY, double originZ) {
            this.originX = originX;
            this.originY = originY;
            this.originZ = originZ;
        }

        @Generated
        public List<Mesh> getSentMeshes() {
            return this.sentMeshes;
        }
    }
}

