/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import com.falsepattern.rple.api.common.ServerColorHelper;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import makamys.neodymium.Compat;
import makamys.neodymium.Neodymium;
import makamys.neodymium.config.Config;
import makamys.neodymium.ducks.NeodymiumWorldRenderer;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.Comparators;
import makamys.neodymium.renderer.GPUMemoryManager;
import makamys.neodymium.renderer.Mesh;
import makamys.neodymium.renderer.NeoChunk;
import makamys.neodymium.renderer.NeoRegion;
import makamys.neodymium.renderer.attribs.AttributeSet;
import makamys.neodymium.util.ChatUtil;
import makamys.neodymium.util.CheatHelper;
import makamys.neodymium.util.GuiHelper;
import makamys.neodymium.util.OFUtil;
import makamys.neodymium.util.Preprocessor;
import makamys.neodymium.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class NeoRenderer {
    public boolean hasInited = false;
    public boolean isFirstPass = true;
    public boolean destroyPending;
    public boolean reloadPending;
    public int rendererSpeedup;
    private static boolean[] wasDown = new boolean[256];
    public boolean renderWorld;
    public boolean rendererActive;
    private boolean showMemoryDebugger;
    public boolean forceRenderFog;
    public boolean hasIncompatibilities;
    private boolean fogEnabled;
    private int[] shaderProgramsFog = new int[]{0, 0};
    private int[] shaderProgramsNoFog = new int[]{0, 0};
    private List<GPUMemoryManager> mems = new ArrayList<GPUMemoryManager>();
    private Map<Integer, List<GPUMemoryManager>> memMap = new HashMap<Integer, List<GPUMemoryManager>>();
    private AttributeSet attributes;
    private Map<ChunkCoordIntPair, NeoRegion> loadedRegionsMap = new HashMap<ChunkCoordIntPair, NeoRegion>();
    private List<NeoRegion> loadedRegionsList = new ArrayList<NeoRegion>();
    public World world;
    private double eyePosX;
    private double eyePosY;
    private double eyePosZ;
    private double eyePosXT;
    private double eyePosYT;
    private double eyePosZT;
    int eyePosXTDiv;
    int eyePosYTDiv;
    int eyePosZTDiv;
    private int renderedMeshesRender;
    private int renderedPolygonsRender;
    private int renderedMeshesShadow;
    private int renderedPolygonsShadow;
    private int frameCount;
    Vector4f transformedOrigin = new Vector4f();
    private int gcCounter = 0;
    private static int frameCounter = 0;
    private static final TreeSet<DelayedTask> tasks = new TreeSet();
    FloatBuffer modelView = BufferUtils.createFloatBuffer((int)16);
    FloatBuffer projBuf = BufferUtils.createFloatBuffer((int)16);
    IntBuffer viewportBuf = BufferUtils.createIntBuffer((int)16);
    FloatBuffer projInvBuf = BufferUtils.createFloatBuffer((int)16);
    FloatBuffer fogColorBuf = BufferUtils.createFloatBuffer((int)16);
    FloatBuffer fogStartEnd = BufferUtils.createFloatBuffer((int)2);
    Matrix4f modelViewMatrix = new Matrix4f();
    Matrix4f modelViewMatrixInv = new Matrix4f();
    Matrix4f projMatrix = new Matrix4f();

    public NeoRenderer(World world) {
        this.world = world;
        if (this.shouldRenderInWorld(world)) {
            this.hasInited = this.init();
        }
        this.renderWorld = true;
        this.rendererActive = true;
    }

    public int preRenderSortedRenderers(int renderPass, double alpha, WorldRenderer[] sortedWorldRenderers) {
        boolean shouldRender;
        if (!this.hasInited) {
            return 0;
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean opaquePass = renderPass == 0;
        boolean isShadowPass = Compat.isShadersShadowPass();
        boolean bl = shouldRender = this.rendererActive && this.renderWorld;
        if (this.isFirstPass) {
            this.renderedMeshesRender = 0;
            this.renderedPolygonsRender = 0;
            this.renderedMeshesShadow = 0;
            this.renderedPolygonsShadow = 0;
            this.mainLoop();
            if (mc.field_71462_r == null) {
                this.handleKeyboard();
            }
        }
        int rendered = 0;
        if (shouldRender) {
            this.updateGLValues();
            if (opaquePass) {
                this.updateEyePos(alpha);
                if (!isShadowPass) {
                    this.sortMeshes(this.frameCount % 100 == 0, this.frameCount % Config.sortFrequency == 0);
                }
                this.initIndexBuffers(isShadowPass);
            }
            if (this.isFirstPass && !Compat.keepRenderListLogic() && !Compat.isFalseTweaksModPresent()) {
                NeoRenderer.updateRenderGlobalStats();
            }
            rendered = this.render(renderPass, alpha);
        }
        this.isFirstPass = false;
        return rendered;
    }

    private void updateEyePos(double alpha) {
        this.transformedOrigin.set(0.0f, 0.0f, 0.0f, 1.0f);
        Matrix4f.transform((Matrix4f)this.modelViewMatrixInv, (Vector4f)this.transformedOrigin, (Vector4f)this.transformedOrigin);
        EntityLivingBase rve = Minecraft.func_71410_x().field_71451_h;
        this.eyePosX = rve.field_70142_S + (rve.field_70165_t - rve.field_70142_S) * alpha;
        this.eyePosY = rve.field_70137_T + (rve.field_70163_u - rve.field_70137_T) * alpha + (double)rve.func_70047_e();
        this.eyePosZ = rve.field_70136_U + (rve.field_70161_v - rve.field_70136_U) * alpha;
        this.eyePosXT = this.eyePosX + (double)this.transformedOrigin.x;
        this.eyePosYT = this.eyePosY + (double)this.transformedOrigin.y;
        this.eyePosZT = this.eyePosZ + (double)this.transformedOrigin.z;
        this.eyePosXTDiv = Math.floorDiv((int)Math.floor(this.eyePosXT), 16);
        this.eyePosYTDiv = Math.floorDiv((int)Math.floor(this.eyePosYT), 16);
        this.eyePosZTDiv = Math.floorDiv((int)Math.floor(this.eyePosZT), 16);
    }

    public void onRenderTickEnd() {
        if (Neodymium.isActive()) {
            if (this.reloadPending) {
                Minecraft.func_71410_x().field_71438_f.func_72712_a();
                return;
            }
            if (this.gcCounter % 4 == 0) {
                for (GPUMemoryManager mem : this.mems) {
                    mem.runGC(false);
                }
            }
            ++this.gcCounter;
            if (this.showMemoryDebugger) {
                int yOff = 20;
                boolean drawing = false;
                for (GPUMemoryManager mem : this.mems) {
                    if (mem == null) continue;
                    if (!drawing) {
                        drawing = true;
                        GuiHelper.begin();
                    }
                    yOff = mem.drawDebugInfo(yOff) + 10;
                }
                if (drawing) {
                    GuiHelper.end();
                }
            }
            this.isFirstPass = true;
        } else if (this.destroyPending) {
            this.destroy();
            this.destroyPending = false;
            Neodymium.renderer = null;
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }
    }

    private void sortMeshes(boolean pass0, boolean pass1) {
        for (GPUMemoryManager mem : this.mems) {
            for (NeoRegion r : this.loadedRegionsMap.values()) {
                r.getRenderData(mem).sort(this.eyePosX, this.eyePosY, this.eyePosZ, pass0, pass1);
            }
        }
    }

    private boolean isRendererVisible(WorldRenderer wr, boolean shadowPass) {
        return shadowPass || wr.field_78936_t;
    }

    private void initIndexBuffers(boolean shadowPass) {
        this.loadedRegionsList.clear();
        this.loadedRegionsList.addAll(this.loadedRegionsMap.values());
        this.loadedRegionsList.sort(Comparators.REGION_DISTANCE_COMPARATOR.setOrigin(this.eyePosX, this.eyePosY, this.eyePosZ));
        for (GPUMemoryManager mem : this.mems) {
            int regionI;
            mem.piFirst.clear();
            mem.piCount.clear();
            int order = mem.pass == 0 ? 1 : -1;
            int n = regionI = order == 1 ? 0 : this.loadedRegionsList.size() - 1;
            while (regionI >= 0 && regionI < this.loadedRegionsList.size()) {
                NeoRegion.RenderData region = this.loadedRegionsList.get(regionI).getRenderData(mem);
                region.batchFirst = mem.piFirst.position();
                for (Mesh mesh : region.getSentMeshes()) {
                    WorldRenderer wr = ((ChunkMesh)mesh).wr;
                    if ((shadowPass || wr.field_78927_l) && mesh.visible && this.isRendererVisible(wr, shadowPass) && this.shouldRenderMesh(mesh)) {
                        if (mem.piFirst.position() >= mem.piFirst.limit() - 16) {
                            mem.growIndexBuffers();
                        }
                        int meshes = mesh.writeToIndexBuffer(mem.piFirst, mem.piCount, this.eyePosXTDiv, this.eyePosYTDiv, this.eyePosZTDiv, mem.pass);
                        if (shadowPass) {
                            this.renderedMeshesShadow += meshes;
                        } else {
                            this.renderedMeshesRender += meshes;
                        }
                        for (int j = mem.piCount.position() - meshes; j < mem.piCount.position(); ++j) {
                            int count = mem.piCount.get(j) / mem.verticesPerPolygon;
                            if (shadowPass) {
                                this.renderedPolygonsShadow += count;
                                continue;
                            }
                            this.renderedPolygonsRender += count;
                        }
                    }
                    if (!Compat.isSpeedupAnimationsEnabled() || Compat.keepRenderListLogic()) continue;
                    wr.func_78909_a(mem.pass);
                }
                region.batchLimit = mem.piFirst.position();
                regionI += order;
            }
            mem.piFirst.flip();
            mem.piCount.flip();
        }
    }

    private boolean shouldRenderMesh(Mesh mesh) {
        if (Compat.isShadersShadowPass()) {
            return true;
        }
        return (Config.maxMeshesPerFrame == -1 || this.renderedMeshesRender < Config.maxMeshesPerFrame) && (!this.isFogEnabled() && !Config.fogOcclusionWithoutFog || Config.fogOcclusion == !Config.fogOcclusion || mesh.distSq(this.eyePosX / 16.0, (double)mesh.y + 0.5, this.eyePosZ / 16.0) < Math.pow((double)this.fogStartEnd.get(1) / 16.0 + 1.0, 2.0));
    }

    public static void submitTask(Runnable task, int delayFrames) {
        tasks.add(new DelayedTask(frameCounter + delayFrames, task));
    }

    private static void updateRenderGlobalStats() {
        RenderGlobal rg = Minecraft.func_71410_x().field_71438_f;
        for (WorldRenderer wr : rg.field_72768_k) {
            if (wr == null) continue;
            ++rg.field_72751_K;
            if (wr.field_78928_m[0]) {
                ++rg.field_72747_O;
                continue;
            }
            if (!wr.field_78927_l) {
                ++rg.field_72744_L;
                continue;
            }
            if (rg.field_72774_t && !wr.field_78936_t) {
                ++rg.field_72745_M;
                continue;
            }
            ++rg.field_72746_N;
        }
    }

    private void mainLoop() {
        if (!tasks.isEmpty()) {
            DelayedTask task = tasks.first();
            if (task.timestamp - frameCounter < 0) {
                tasks.pollFirst();
                task.task.run();
            }
        }
        ++frameCounter;
        if (Minecraft.func_71410_x().field_71442_b.field_78774_b.field_147309_h) {
            Iterator<Map.Entry<ChunkCoordIntPair, NeoRegion>> it = this.loadedRegionsMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ChunkCoordIntPair, NeoRegion> kv = it.next();
                NeoRegion v = kv.getValue();
                if (v.shouldDelete()) {
                    v.destroy();
                    it.remove();
                    continue;
                }
                v.tick();
            }
        }
    }

    private void handleKeyboard() {
        if (Config.debugPrefix == 0 || Config.debugPrefix != -1 && Keyboard.isKeyDown((int)Config.debugPrefix)) {
            if (CheatHelper.canCheat()) {
                if (Keyboard.isKeyDown((int)33) && !wasDown[33]) {
                    boolean bl = this.rendererActive = !this.rendererActive;
                }
                if (Keyboard.isKeyDown((int)47) && !wasDown[47]) {
                    boolean bl = this.renderWorld = !this.renderWorld;
                }
            }
            if (Keyboard.isKeyDown((int)19) && !wasDown[19]) {
                this.reloadShader();
            }
            if (Keyboard.isKeyDown((int)50) && !wasDown[50]) {
                boolean bl = this.showMemoryDebugger = !this.showMemoryDebugger;
            }
            if (Keyboard.isKeyDown((int)25) && !wasDown[25]) {
                Util.dumpTexture();
            }
            if (Keyboard.isKeyDown((int)203) && !wasDown[203]) {
                this.reloadPending = true;
            }
            if (Keyboard.isKeyDown((int)205) && !wasDown[205]) {
                this.rendererSpeedup = this.rendererSpeedup == 0 ? 300 : 0;
            }
        }
        for (int i = 0; i < 256; ++i) {
            NeoRenderer.wasDown[i] = Keyboard.isKeyDown((int)i);
        }
    }

    private int render(int pass, double alpha) {
        List<GPUMemoryManager> mems = this.memMap.get(pass);
        if (mems == null) {
            return 0;
        }
        if (!Compat.isOptiFineShadersEnabled()) {
            int shader = this.getShaderProgram(pass);
            if (shader == 0) {
                return 0;
            }
            GL20.glUseProgram((int)shader);
            this.updateUniforms(alpha, pass);
        }
        if (NeoRenderer.isWireframeEnabled()) {
            GL11.glPolygonMode((int)1032, (int)6913);
        }
        int u_renderOffset = -1;
        if (!Compat.isOptiFineShadersEnabled()) {
            u_renderOffset = GL20.glGetUniformLocation((int)this.getShaderProgram(pass), (CharSequence)"renderOffset");
        }
        EntityRenderer er = Minecraft.func_71410_x().field_71460_t;
        er.func_78463_b(alpha);
        int rendered = 0;
        for (GPUMemoryManager mem : mems) {
            int regionI;
            GL30.glBindVertexArray((int)mem.VAO);
            int oldLimit = mem.piFirst.limit();
            int order = pass == 0 ? 1 : -1;
            int n = regionI = order == 1 ? 0 : this.loadedRegionsList.size() - 1;
            while (regionI >= 0 && regionI < this.loadedRegionsList.size()) {
                NeoRegion.RenderData region = this.loadedRegionsList.get(regionI).getRenderData(mem);
                rendered += region.batchLimit - region.batchFirst;
                Util.setPositionAndLimit(mem.piFirst, region.batchFirst, region.batchLimit);
                Util.setPositionAndLimit(mem.piCount, region.batchFirst, region.batchLimit);
                if (Compat.isOptiFineShadersEnabled()) {
                    GL11.glMatrixMode((int)5888);
                    float offsetX = (float)(region.originX - this.eyePosX);
                    float offsetY = (float)(region.originY - this.eyePosY + 0.12);
                    float offsetZ = (float)(region.originZ - this.eyePosZ);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)offsetX, (float)offsetY, (float)offsetZ);
                } else {
                    GL20.glUniform3f((int)u_renderOffset, (float)((float)(region.originX - this.eyePosX)), (float)((float)(region.originY - this.eyePosY)), (float)((float)(region.originZ - this.eyePosZ)));
                }
                GL14.glMultiDrawArrays((int)mem.drawMode, (IntBuffer)mem.piFirst, (IntBuffer)mem.piCount);
                if (Compat.isOptiFineShadersEnabled()) {
                    GL11.glPopMatrix();
                }
                regionI += order;
            }
            Util.setPositionAndLimit(mem.piFirst, 0, oldLimit);
            Util.setPositionAndLimit(mem.piCount, 0, oldLimit);
        }
        if (NeoRenderer.isWireframeEnabled()) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
        if (!Compat.isOptiFineShadersEnabled()) {
            GL20.glUseProgram((int)0);
        }
        GL30.glBindVertexArray((int)0);
        er.func_78483_a(alpha);
        return rendered;
    }

    private void updateGLValues() {
        GL11.glGetFloat((int)2982, (FloatBuffer)this.modelView);
        GL11.glGetFloat((int)2983, (FloatBuffer)this.projBuf);
        GL11.glGetInteger((int)2978, (IntBuffer)this.viewportBuf);
        this.projMatrix.load(this.projBuf);
        this.projBuf.flip();
        this.projMatrix.invert();
        this.projMatrix.store(this.projInvBuf);
        this.projInvBuf.flip();
        this.modelViewMatrix.load(this.modelView);
        this.modelView.flip();
        this.modelViewMatrixInv.load(this.modelViewMatrix).invert();
        this.fogColorBuf.limit(16);
        GL11.glGetFloat((int)2918, (FloatBuffer)this.fogColorBuf);
        this.fogColorBuf.limit(4);
        this.fogStartEnd.put(GL11.glGetFloat((int)2915));
        this.fogStartEnd.put(GL11.glGetFloat((int)2916));
        this.fogStartEnd.flip();
        this.fogEnabled = GL11.glIsEnabled((int)2912) && !OFUtil.isFogOff();
    }

    private void updateUniforms(double alpha, int pass) {
        int shaderProgram = this.getShaderProgram(pass);
        int u_modelView = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"modelView");
        int u_proj = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"proj");
        int u_playerPos = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"playerPos");
        int u_viewport = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"viewport");
        int u_projInv = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"projInv");
        int u_fogColor = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogColor");
        int u_fogStartEnd = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogStartEnd");
        int u_fogMode = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogMode");
        int u_fogDensity = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogDensity");
        GL20.glUniformMatrix4((int)u_modelView, (boolean)false, (FloatBuffer)this.modelView);
        GL20.glUniformMatrix4((int)u_proj, (boolean)false, (FloatBuffer)this.projBuf);
        GL20.glUniformMatrix4((int)u_projInv, (boolean)false, (FloatBuffer)this.projInvBuf);
        GL20.glUniform4f((int)u_viewport, (float)this.viewportBuf.get(0), (float)this.viewportBuf.get(1), (float)this.viewportBuf.get(2), (float)this.viewportBuf.get(3));
        GL20.glUniform4((int)u_fogColor, (FloatBuffer)this.fogColorBuf);
        GL20.glUniform2((int)u_fogStartEnd, (FloatBuffer)this.fogStartEnd);
        GL20.glUniform1i((int)u_fogMode, (int)GL11.glGetInteger((int)2917));
        GL20.glUniform1f((int)u_fogDensity, (float)GL11.glGetFloat((int)2914));
        GL20.glUniform3f((int)u_playerPos, (float)((float)this.eyePosX), (float)((float)this.eyePosY), (float)((float)this.eyePosZ));
        if (Compat.ft$isDynamicLights()) {
            int u_playerHandLight = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"playerHandLight");
            if (Compat.isRPLEModPresent()) {
                short light = Compat.RPLECompat.getLightLevel((Entity)Minecraft.func_71410_x().field_71451_h);
                float r = (float)ServerColorHelper.red((short)light) / 16.0f;
                float g = (float)ServerColorHelper.green((short)light) / 16.0f;
                float b = (float)ServerColorHelper.blue((short)light) / 16.0f;
                GL20.glUniform3f((int)u_playerHandLight, (float)r, (float)g, (float)b);
            } else {
                int playerLight = Compat.FalseTweaksCompat.getLightLevel((Entity)Minecraft.func_71410_x().field_71451_h);
                GL20.glUniform1f((int)u_playerHandLight, (float)((float)playerLight / 16.0f));
            }
        }
        if (Compat.isRPLEModPresent()) {
            int u_light_r = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"lightTexR");
            int u_light_g = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"lightTexG");
            int u_light_b = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"lightTexB");
            GL20.glUniform1i((int)u_light_r, (int)1);
            GL20.glUniform1i((int)u_light_g, (int)2);
            GL20.glUniform1i((int)u_light_b, (int)3);
        } else {
            int u_light = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"lightTex");
            GL20.glUniform1i((int)u_light, (int)1);
        }
        this.modelView.position(0);
        this.projBuf.position(0);
        this.viewportBuf.position(0);
        this.projInvBuf.position(0);
        this.fogColorBuf.position(0);
        this.fogStartEnd.position(0);
    }

    public boolean init() {
        Compat.updateOptiFineShadersState();
        this.attributes = new AttributeSet();
        Neodymium.util.initVertexAttributes(this.attributes);
        this.reloadShader();
        return true;
    }

    private GPUMemoryManager initMemoryManager(int pass, int drawMode, int verticesPerPolygon) throws Exception {
        GPUMemoryManager mem = new GPUMemoryManager(this.mems.size(), pass, drawMode, verticesPerPolygon);
        this.mems.add(mem);
        this.memMap.computeIfAbsent(pass, p -> new ArrayList()).add(mem);
        GL30.glBindVertexArray((int)mem.VAO);
        GL15.glBindBuffer((int)34962, (int)mem.VBO);
        Neodymium.util.applyVertexAttributes(this.attributes);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        return mem;
    }

    public int getStride() {
        return this.attributes.stride();
    }

    public void reloadShader(int pass, AttributeSet attributeSet) {
        for (int hasFog = 0; hasFog <= 1; ++hasFog) {
            HashMap<String, String> defines = new HashMap<String, String>();
            if (hasFog == 1) {
                defines.put("RENDER_FOG", "");
            }
            if (Config.shortUV) {
                defines.put("SHORT_UV", "");
            }
            if (Compat.isRPLEModPresent()) {
                defines.put("RPLE", "");
            }
            if (pass == 0) {
                defines.put("PASS_0", "");
            }
            if (Compat.ft$isDynamicLights()) {
                defines.put("DYN_LIGHTS", "");
                if (Compat.ft$isDynamicLightsCircular()) {
                    defines.put("DYN_LIGHTS_CIRCULAR", "");
                }
                if (Compat.isRPLEModPresent()) {
                    defines.put("DYN_LIGHTS_DATATYPE", "vec3");
                } else {
                    defines.put("DYN_LIGHTS_DATATYPE", "float");
                }
            }
            attributeSet.addDefines(defines);
            boolean errors = false;
            int vertexShader = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)vertexShader, (CharSequence)Preprocessor.preprocess(Util.readFile("shaders/chunk.vert"), defines));
            GL20.glCompileShader((int)vertexShader);
            if (GL20.glGetShaderi((int)vertexShader, (int)35713) == 0) {
                System.out.println("Error compiling vertex shader: " + GL20.glGetShaderInfoLog((int)vertexShader, (int)256));
                errors = true;
            }
            int fragmentShader = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)fragmentShader, (CharSequence)Preprocessor.preprocess(Util.readFile("shaders/chunk.frag"), defines));
            GL20.glCompileShader((int)fragmentShader);
            if (GL20.glGetShaderi((int)fragmentShader, (int)35713) == 0) {
                System.out.println("Error compiling fragment shader: " + GL20.glGetShaderInfoLog((int)fragmentShader, (int)256));
                errors = true;
            }
            int newShaderProgram = GL20.glCreateProgram();
            GL20.glAttachShader((int)newShaderProgram, (int)vertexShader);
            GL20.glAttachShader((int)newShaderProgram, (int)fragmentShader);
            GL20.glLinkProgram((int)newShaderProgram);
            if (GL20.glGetProgrami((int)newShaderProgram, (int)35714) == 0) {
                System.out.println("Error linking shader: " + GL20.glGetShaderInfoLog((int)newShaderProgram, (int)256));
                errors = true;
            }
            if (!errors) {
                (hasFog == 1 ? this.shaderProgramsFog : this.shaderProgramsNoFog)[pass] = newShaderProgram;
            }
            GL20.glDeleteShader((int)vertexShader);
            GL20.glDeleteShader((int)fragmentShader);
        }
    }

    public void reloadShader() {
        this.reloadShader(0, this.attributes);
        this.reloadShader(1, this.attributes);
    }

    public void destroy() {
        if (!this.hasInited) {
            return;
        }
        GL20.glDeleteProgram((int)this.shaderProgramsFog[0]);
        GL20.glDeleteProgram((int)this.shaderProgramsFog[1]);
        GL20.glDeleteProgram((int)this.shaderProgramsNoFog[0]);
        GL20.glDeleteProgram((int)this.shaderProgramsNoFog[1]);
        for (GPUMemoryManager mem : this.mems) {
            mem.destroy();
        }
        for (NeoRegion region : this.loadedRegionsList) {
            region.destroy();
        }
    }

    public void onWorldRendererChanged(WorldRenderer wr, WorldRendererChange change) {
        int x = Math.floorDiv(wr.field_78923_c, 16);
        int y = Math.floorDiv(wr.field_78920_d, 16);
        int z = Math.floorDiv(wr.field_78921_e, 16);
        NeoChunk neoChunk = this.getNeoChunk(x, z);
        boolean bl = neoChunk.isSectionVisible[y] = change == WorldRendererChange.VISIBLE;
        if (change == WorldRendererChange.DELETED) {
            this.removeMesh(neoChunk.chunkMeshes[y]);
            if (neoChunk.chunkMeshes[y] != null) {
                neoChunk.chunkMeshes[y].destroy();
                neoChunk.chunkMeshes[y] = null;
                --neoChunk.region.meshes;
            }
        }
        this.neoChunkChanged(neoChunk);
    }

    public void onWorldRendererPost(WorldRenderer wr, boolean sort) {
        int x = Math.floorDiv(wr.field_78923_c, 16);
        int y = Math.floorDiv(wr.field_78920_d, 16);
        int z = Math.floorDiv(wr.field_78921_e, 16);
        if (Minecraft.func_71410_x().field_71441_e.func_72964_e((int)x, (int)z).field_76636_d) {
            NeoChunk neoChunk = this.getNeoChunk(x, z);
            neoChunk.isSectionVisible[y] = ((NeodymiumWorldRenderer)wr).nd$isDrawn();
            neoChunk.putChunkMeshes(y, ((NeodymiumWorldRenderer)wr).nd$getChunkMeshes(), sort);
        }
    }

    public void onRenderFog() {
        this.forceRenderFog = false;
    }

    private NeoChunk getNeoChunk(int chunkX, int chunkZ) {
        return this.getRegionContaining(chunkX, chunkZ).getChunkAbsolute(chunkX, chunkZ);
    }

    private NeoRegion getRegionContaining(int chunkX, int chunkZ) {
        int regionZ;
        int regionX = Math.floorDiv(chunkX, 64);
        ChunkCoordIntPair key = new ChunkCoordIntPair(regionX, regionZ = Math.floorDiv(chunkZ, 64));
        NeoRegion region = this.loadedRegionsMap.get(key);
        if (region == null) {
            region = NeoRegion.load(regionX, regionZ);
            this.loadedRegionsMap.put(key, region);
        }
        return region;
    }

    public void setVisible(NeoChunk chunk, boolean visible) {
        this.setVisible(chunk, visible, false);
    }

    public void setVisible(NeoChunk neoChunk, boolean visible, boolean forceCheck) {
        if (!forceCheck && visible == neoChunk.visible) {
            return;
        }
        neoChunk.visible = visible;
        this.neoChunkChanged(neoChunk);
    }

    public void neoChunkChanged(NeoChunk neoChunk) {
        int newLOD = neoChunk.hasChunkMeshes() ? 2 : 0;
        for (int y = 0; y < 16; ++y) {
            for (int pass = 0; pass < 2; ++pass) {
                ChunkMesh cm = neoChunk.chunkMeshes[y * 2 + pass];
                if (cm == null) continue;
                if (neoChunk.isSectionVisible[y] && newLOD == 2) {
                    if (!cm.visible) {
                        this.setMeshVisible(cm, true);
                    }
                } else if (cm.visible) {
                    this.setMeshVisible(cm, false);
                }
                this.uploadMeshToGPU(cm);
            }
        }
    }

    protected void uploadMeshToGPU(Mesh mesh) {
        if (mesh.gpuStatus != Mesh.GPUStatus.UNSENT || mesh.buffer == null || mesh.verticesPerPolygon == -1) {
            return;
        }
        boolean sent = false;
        GPUMemoryManager mem = null;
        List<GPUMemoryManager> memArr = this.memMap.get(mesh.pass);
        if (memArr != null) {
            for (int i = 0; i < memArr.size() && !(sent = (mem = memArr.get(i)).uploadMesh(mesh)); ++i) {
            }
        }
        if (!sent) {
            try {
                mem = this.initMemoryManager(mesh.pass, mesh.drawMode, mesh.verticesPerPolygon);
            }
            catch (Exception e) {
                ChatUtil.showNeoChatMessage("Could not allocate memory buffer: " + e.getMessage(), ChatUtil.MessageVerbosity.ERROR);
                e.printStackTrace();
                Neodymium.renderer.destroyPending = true;
                return;
            }
            mem.uploadMesh(mesh);
        }
        NeoRegion region = this.getRegionContaining(mesh.x, mesh.z);
        region.getRenderData(mem).getSentMeshes().add(mesh);
        mesh.containingRegion = region;
    }

    protected void setMeshVisible(Mesh mesh, boolean visible) {
        if (mesh == null) {
            return;
        }
        if (mesh.visible != visible) {
            mesh.visible = visible;
        }
    }

    public void removeMesh(Mesh mesh) {
        if (mesh == null) {
            return;
        }
        GPUMemoryManager mem = mesh.attachedManager;
        if (mem != null) {
            mesh.attachedManager.deleteMesh(mesh);
            if (mesh.containingRegion != null) {
                mesh.containingRegion.getRenderData(mem).getSentMeshes().remove(mesh);
            }
        }
        this.setMeshVisible(mesh, false);
    }

    public List<String> getDebugText(boolean statusCommand) {
        ArrayList<String> text = new ArrayList<String>();
        text.add((!this.rendererActive ? EnumChatFormatting.RED + "(OFF) " : "") + (statusCommand ? EnumChatFormatting.LIGHT_PURPLE : "") + "Neodymium " + "0.4.3-unofficial");
        text.addAll(Arrays.asList("Meshes: " + ChunkMesh.instances.get() + " (" + ChunkMesh.usedRAM.get() / 1024L / 1024L + "MB)", "Rendered: " + this.renderedMeshesRender + " (" + this.renderedPolygonsRender / 1000 + "KQ)"));
        if (Compat.isOptiFineShadersEnabled()) {
            text.add("Shadow Rendered: " + this.renderedMeshesShadow + " (" + this.renderedPolygonsShadow / 1000 + "KQ)");
        }
        text.add("VRAM buffers:");
        for (int i = 0; i < this.mems.size(); ++i) {
            GPUMemoryManager mem = this.mems.get(i);
            text.addAll(mem.debugText());
        }
        if (this.rendererSpeedup > 0) {
            text.add(EnumChatFormatting.YELLOW + "(!) Renderer speedup active");
        }
        if (this.hasIncompatibilities) {
            text.add(EnumChatFormatting.YELLOW + "(!) Incompatibilities");
            if (!statusCommand) {
                text.add(EnumChatFormatting.YELLOW + "Type '/neodymium status'");
            }
        }
        return text;
    }

    private int getShaderProgram(int pass) {
        return (this.forceRenderFog || this.isFogEnabled() ? this.shaderProgramsFog : this.shaderProgramsNoFog)[pass];
    }

    private boolean isFogEnabled() {
        switch (Config.renderFog) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return this.fogEnabled;
    }

    private boolean shouldRenderInWorld(World world) {
        return world != null;
    }

    private static boolean isWireframeEnabled() {
        return Config.wireframe && CheatHelper.canCheat();
    }

    public static enum WorldRendererChange {
        VISIBLE,
        INVISIBLE,
        DELETED;

    }

    private static class DelayedTask
    implements Comparable<DelayedTask> {
        public final int timestamp;
        public final Runnable task;
        private final int idx;
        private static final AtomicInteger IIDX = new AtomicInteger();

        public DelayedTask(int timestamp, Runnable task) {
            this.timestamp = timestamp;
            this.task = task;
            this.idx = IIDX.getAndIncrement();
        }

        @Override
        public int compareTo(DelayedTask o) {
            if (this.timestamp == o.timestamp) {
                return Integer.compare(this.idx, o.idx);
            }
            return Integer.compare(this.timestamp, o.timestamp);
        }
    }
}

