/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer.compat;

import lombok.Generated;
import makamys.neodymium.config.Config;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.MeshPolygon;
import makamys.neodymium.renderer.attribs.AttributeSet;
import makamys.neodymium.renderer.compat.RenderUtil;
import makamys.neodymium.util.BufferWriter;

public class RenderUtilRPLE
implements RenderUtil {
    public static final RenderUtilRPLE INSTANCE = new RenderUtilRPLE();
    public static final int POLYGON_OFFSET_U = 3;
    public static final int POLYGON_OFFSET_V = 4;
    public static final int POLYGON_OFFSET_C = 5;
    public static final int POLYGON_OFFSET_BR = 6;
    public static final int POLYGON_OFFSET_BG = 7;
    public static final int POLYGON_OFFSET_BB = 8;

    @Override
    public void polygonize(int[] tessBuffer, int tessOffset, int[] polygonBuffer, int polygonOffset, float offsetX, float offsetY, float offsetZ, ChunkMesh.Flags flags) {
        polygonBuffer[polygonOffset + 0] = Float.floatToRawIntBits(Float.intBitsToFloat(tessBuffer[tessOffset]) + offsetX);
        polygonBuffer[polygonOffset + 1] = Float.floatToRawIntBits(Float.intBitsToFloat(tessBuffer[tessOffset + 1]) + offsetY);
        polygonBuffer[polygonOffset + 2] = Float.floatToRawIntBits(Float.intBitsToFloat(tessBuffer[tessOffset + 2]) + offsetZ);
        polygonBuffer[polygonOffset + 3] = tessBuffer[tessOffset + 3];
        polygonBuffer[polygonOffset + 4] = tessBuffer[tessOffset + 4];
        int n = polygonBuffer[polygonOffset + 5] = flags.hasColor ? tessBuffer[tessOffset + 5] : -1;
        if (flags.hasBrightness) {
            polygonBuffer[polygonOffset + 6] = tessBuffer[tessOffset + 7];
            polygonBuffer[polygonOffset + 7] = tessBuffer[tessOffset + 8];
            polygonBuffer[polygonOffset + 8] = tessBuffer[tessOffset + 9];
        } else {
            polygonBuffer[polygonOffset + 6] = MeshPolygon.DEFAULT_BRIGHTNESS;
            polygonBuffer[polygonOffset + 7] = MeshPolygon.DEFAULT_BRIGHTNESS;
            polygonBuffer[polygonOffset + 8] = MeshPolygon.DEFAULT_BRIGHTNESS;
        }
    }

    @Override
    public void writeMeshPolygonToBuffer(int[] meshPolygonBuffer, int polygonOffset, BufferWriter out, int expectedStride, int verticesPerPolygon) {
        int vertexSize = this.vertexSizeInPolygonBuffer();
        for (int vi = 0; vi < verticesPerPolygon; ++vi) {
            int offset = polygonOffset + vi * vertexSize;
            out.writeFloat(Float.intBitsToFloat(meshPolygonBuffer[offset + 0]));
            out.writeFloat(Float.intBitsToFloat(meshPolygonBuffer[offset + 1]));
            out.writeFloat(Float.intBitsToFloat(meshPolygonBuffer[offset + 2]));
            float u = Float.intBitsToFloat(meshPolygonBuffer[offset + 3]);
            float v = Float.intBitsToFloat(meshPolygonBuffer[offset + 4]);
            if (Config.shortUV) {
                out.writeShort((short)Math.round(u * 32768.0f));
                out.writeShort((short)Math.round(v * 32768.0f));
            } else {
                out.writeFloat(u);
                out.writeFloat(v);
            }
            out.writeInt(meshPolygonBuffer[offset + 5]);
            out.writeInt(meshPolygonBuffer[offset + 6]);
            out.writeInt(meshPolygonBuffer[offset + 7]);
            out.writeInt(meshPolygonBuffer[offset + 8]);
            assert (out.position() % expectedStride == 0);
        }
    }

    @Override
    public int vertexSizeInTessellator() {
        return 12;
    }

    @Override
    public int vertexSizeInPolygonBuffer() {
        return 9;
    }

    @Override
    public void initVertexAttributes(AttributeSet attributes) {
        attributes.addAttribute("POS", 3, 4, 5126);
        if (Config.shortUV) {
            attributes.addAttribute("TEXTURE", 2, 2, 5123);
        } else {
            attributes.addAttribute("TEXTURE", 2, 4, 5126);
        }
        attributes.addAttribute("COLOR", 4, 1, 5121);
        attributes.addAttribute("BRIGHTNESS_RED", 2, 2, 5122);
        attributes.addAttribute("BRIGHTNESS_GREEN", 2, 2, 5122);
        attributes.addAttribute("BRIGHTNESS_BLUE", 2, 2, 5122);
    }

    @Generated
    private RenderUtilRPLE() {
    }
}

