/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer.compat;

import lombok.Generated;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.MeshPolygon;
import makamys.neodymium.renderer.attribs.AttributeSet;
import makamys.neodymium.renderer.compat.RenderUtil;
import makamys.neodymium.util.BufferWriter;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class RenderUtilShaders
implements RenderUtil {
    public static final RenderUtilShaders INSTANCE = new RenderUtilShaders();
    public static final int POLYGON_OFFSET_U = 3;
    public static final int POLYGON_OFFSET_V = 4;
    public static final int POLYGON_OFFSET_C = 5;
    public static final int POLYGON_OFFSET_B = 6;
    public static final int POLYGON_OFFSET_E1 = 7;
    public static final int POLYGON_OFFSET_E2 = 8;
    public static final int POLYGON_OFFSET_XN = 9;
    public static final int POLYGON_OFFSET_YN = 10;
    public static final int POLYGON_OFFSET_ZN = 11;
    public static final int POLYGON_OFFSET_XT = 12;
    public static final int POLYGON_OFFSET_YT = 13;
    public static final int POLYGON_OFFSET_ZT = 14;
    public static final int POLYGON_OFFSET_WT = 15;
    public static final int POLYGON_OFFSET_UM = 16;
    public static final int POLYGON_OFFSET_VM = 17;
    public static final int POLYGON_OFFSET_OPTIFINE_START = 7;
    public static final int POLYGON_OFFSET_OPTIFINE_END = 17;
    public static final int POLYGON_OFFSET_OPTIFINE_COUNT = 11;

    @Override
    public void polygonize(int[] tessBuffer, int tessOffset, int[] polygonBuffer, int polygonOffset, float offsetX, float offsetY, float offsetZ, ChunkMesh.Flags flags) {
        polygonBuffer[polygonOffset + 0] = Float.floatToRawIntBits(Float.intBitsToFloat(tessBuffer[tessOffset]) + offsetX);
        polygonBuffer[polygonOffset + 1] = Float.floatToRawIntBits(Float.intBitsToFloat(tessBuffer[tessOffset + 1]) + offsetY);
        polygonBuffer[polygonOffset + 2] = Float.floatToRawIntBits(Float.intBitsToFloat(tessBuffer[tessOffset + 2]) + offsetZ);
        polygonBuffer[polygonOffset + 3] = tessBuffer[tessOffset + 3];
        polygonBuffer[polygonOffset + 4] = tessBuffer[tessOffset + 4];
        polygonBuffer[polygonOffset + 5] = flags.hasColor ? tessBuffer[tessOffset + 5] : -1;
        polygonBuffer[polygonOffset + 6] = flags.hasBrightness ? tessBuffer[tessOffset + 6] : MeshPolygon.DEFAULT_BRIGHTNESS;
        System.arraycopy(tessBuffer, tessOffset + 7, polygonBuffer, polygonOffset + 7, 11);
    }

    @Override
    public void writeMeshPolygonToBuffer(int[] meshPolygonBuffer, int polygonOffset, BufferWriter out, int expectedStride, int verticesPerPolygon) {
        int vertexSize = this.vertexSizeInPolygonBuffer();
        for (int vi = 0; vi < verticesPerPolygon; ++vi) {
            int offset = polygonOffset + vi * vertexSize;
            for (int i = 0; i < vertexSize; ++i) {
                out.writeInt(meshPolygonBuffer[offset + i]);
            }
            assert (out.position() % expectedStride == 0);
        }
    }

    @Override
    public int vertexSizeInTessellator() {
        return 18;
    }

    @Override
    public int vertexSizeInPolygonBuffer() {
        return 18;
    }

    @Override
    public void initVertexAttributes(AttributeSet attributes) {
        attributes.addAttribute("POS", 3, 4, 5126);
        attributes.addAttribute("TEXTURE", 2, 4, 5126);
        attributes.addAttribute("COLOR", 4, 1, 5121);
        attributes.addAttribute("BRIGHTNESS", 2, 2, 5122);
        attributes.addAttribute("ENTITY_DATA_1", 1, 4, 5125);
        attributes.addAttribute("ENTITY_DATA_2", 1, 4, 5125);
        attributes.addAttribute("NORMAL", 3, 4, 5126);
        attributes.addAttribute("TANGENT", 4, 4, 5126);
        attributes.addAttribute("MIDTEXTURE", 2, 4, 5126);
    }

    @Override
    public void applyVertexAttributes(AttributeSet attributes) {
        int stride = attributes.stride();
        int entityAttrib = 10;
        int midTexCoordAttrib = 11;
        int tangentAttrib = 12;
        GL11.glVertexPointer((int)3, (int)5126, (int)stride, (long)0L);
        GL11.glEnableClientState((int)32884);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)stride, (long)12L);
        GL11.glEnableClientState((int)32888);
        GL11.glColorPointer((int)4, (int)5121, (int)stride, (long)20L);
        GL11.glEnableClientState((int)32886);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GL11.glTexCoordPointer((int)2, (int)5122, (int)stride, (long)24L);
        GL11.glEnableClientState((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GL20.glVertexAttribPointer((int)10, (int)3, (int)5122, (boolean)false, (int)stride, (long)28L);
        GL20.glEnableVertexAttribArray((int)10);
        GL11.glNormalPointer((int)5126, (int)stride, (long)36L);
        GL11.glEnableClientState((int)32885);
        GL20.glVertexAttribPointer((int)12, (int)4, (int)5126, (boolean)false, (int)stride, (long)48L);
        GL20.glEnableVertexAttribArray((int)12);
        GL13.glClientActiveTexture((int)33987);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)stride, (long)64L);
        GL11.glEnableClientState((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        ARBVertexShader.glVertexAttribPointerARB((int)11, (int)2, (int)5126, (boolean)false, (int)stride, (long)64L);
        ARBVertexShader.glEnableVertexAttribArrayARB((int)11);
    }

    @Generated
    private RenderUtilShaders() {
    }
}

