/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer.compat;

import lombok.Generated;
import makamys.neodymium.config.Config;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.MeshPolygon;
import makamys.neodymium.renderer.attribs.AttributeSet;
import makamys.neodymium.renderer.compat.RenderUtil;
import makamys.neodymium.util.BufferWriter;

public class RenderUtilVanilla
implements RenderUtil {
    public static final RenderUtilVanilla INSTANCE = new RenderUtilVanilla();
    public static final int POLYGON_OFFSET_U = 3;
    public static final int POLYGON_OFFSET_V = 4;
    public static final int POLYGON_OFFSET_C = 5;
    public static final int POLYGON_OFFSET_B = 6;

    @Override
    public void polygonize(int[] tessBuffer, int tessIndex, int[] polygonBuffer, int polygonIndex, float offsetX, float offsetY, float offsetZ, ChunkMesh.Flags flags) {
        polygonBuffer[polygonIndex + 0] = Float.floatToRawIntBits(Float.intBitsToFloat(tessBuffer[tessIndex]) + offsetX);
        polygonBuffer[polygonIndex + 1] = Float.floatToRawIntBits(Float.intBitsToFloat(tessBuffer[tessIndex + 1]) + offsetY);
        polygonBuffer[polygonIndex + 2] = Float.floatToRawIntBits(Float.intBitsToFloat(tessBuffer[tessIndex + 2]) + offsetZ);
        polygonBuffer[polygonIndex + 3] = tessBuffer[tessIndex + 3];
        polygonBuffer[polygonIndex + 4] = tessBuffer[tessIndex + 4];
        polygonBuffer[polygonIndex + 5] = flags.hasColor ? tessBuffer[tessIndex + 5] : -1;
        polygonBuffer[polygonIndex + 6] = flags.hasBrightness ? tessBuffer[tessIndex + 7] : MeshPolygon.DEFAULT_BRIGHTNESS;
    }

    @Override
    public int vertexSizeInTessellator() {
        return 8;
    }

    @Override
    public int vertexSizeInPolygonBuffer() {
        return 7;
    }

    @Override
    public void writeMeshPolygonToBuffer(int[] meshPolygonBuffer, int polygonOffset, BufferWriter out, int expectedStride, int verticesPerPolygon) {
        int vertexSize = this.vertexSizeInPolygonBuffer();
        for (int vi = 0; vi < verticesPerPolygon; ++vi) {
            int offset = polygonOffset + vi * vertexSize;
            out.writeFloat(Float.intBitsToFloat(meshPolygonBuffer[offset + 0]));
            out.writeFloat(Float.intBitsToFloat(meshPolygonBuffer[offset + 1]));
            out.writeFloat(Float.intBitsToFloat(meshPolygonBuffer[offset + 2]));
            float u = Float.intBitsToFloat(meshPolygonBuffer[offset + 3]);
            float v = Float.intBitsToFloat(meshPolygonBuffer[offset + 4]);
            if (Config.shortUV) {
                out.writeShort((short)Math.round(u * 32768.0f));
                out.writeShort((short)Math.round(v * 32768.0f));
            } else {
                out.writeFloat(u);
                out.writeFloat(v);
            }
            out.writeInt(meshPolygonBuffer[offset + 5]);
            out.writeInt(meshPolygonBuffer[offset + 6]);
            assert (out.position() % expectedStride == 0);
        }
    }

    @Override
    public void initVertexAttributes(AttributeSet attributes) {
        attributes.addAttribute("POS", 3, 4, 5126);
        if (Config.shortUV) {
            attributes.addAttribute("TEXTURE", 2, 2, 5123);
        } else {
            attributes.addAttribute("TEXTURE", 2, 4, 5126);
        }
        attributes.addAttribute("COLOR", 4, 1, 5121);
        attributes.addAttribute("BRIGHTNESS", 2, 2, 5122);
    }

    @Generated
    private RenderUtilVanilla() {
    }
}

