/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.util;

import java.util.Map;
import java.util.Stack;

public class Preprocessor {
    public static String preprocess(String text, Map<String, String> defines) {
        CharSequence[] lines = text.replaceAll("\\r\\n", "\n").split("\\n");
        Stack<IfElseBlockStatus> ifElseBlockStatus = new Stack<IfElseBlockStatus>();
        ifElseBlockStatus.push(IfElseBlockStatus.NONE);
        Stack<Boolean> ifElseConditionMet = new Stack<Boolean>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            boolean commentLine = false;
            String preProcLine = line.trim();
            if (preProcLine.startsWith("#ifdef ")) {
                ifElseBlockStatus.push(IfElseBlockStatus.IF);
                boolean prev = ifElseConditionMet.isEmpty() || (Boolean)ifElseConditionMet.peek() != false;
                ifElseConditionMet.push(prev && defines.containsKey(preProcLine.split(" ")[1]));
                commentLine = true;
            } else if (preProcLine.startsWith("#else")) {
                if (ifElseBlockStatus.peek() == IfElseBlockStatus.NONE) {
                    throw new IllegalStateException("#else encountered outside of an ifdef block!");
                }
                boolean curr = (Boolean)ifElseConditionMet.pop() == false;
                boolean prev = ifElseConditionMet.isEmpty() || (Boolean)ifElseConditionMet.peek() != false;
                ifElseConditionMet.push(prev && curr);
                ifElseBlockStatus.pop();
                ifElseBlockStatus.push(IfElseBlockStatus.ELSE);
                commentLine = true;
            } else if (preProcLine.startsWith("#endif")) {
                if (ifElseBlockStatus.peek() == IfElseBlockStatus.NONE) {
                    throw new IllegalStateException("#endif encountered outside of an ifdef/else block!");
                }
                ifElseBlockStatus.pop();
                ifElseConditionMet.pop();
                commentLine = true;
            } else {
                if (ifElseBlockStatus.peek() == IfElseBlockStatus.IF && !((Boolean)ifElseConditionMet.peek()).booleanValue()) {
                    commentLine = true;
                }
                if (ifElseBlockStatus.peek() == IfElseBlockStatus.ELSE && !((Boolean)ifElseConditionMet.peek()).booleanValue()) {
                    commentLine = true;
                }
            }
            if (commentLine) {
                lines[i] = "//" + line;
                continue;
            }
            for (Map.Entry<String, String> define : defines.entrySet()) {
                line = line.replace(define.getKey(), define.getValue());
            }
            lines[i] = line;
        }
        return String.join((CharSequence)"\n", lines);
    }

    public static enum IfElseBlockStatus {
        NONE,
        IF,
        ELSE;

    }
}

