/*
 * Decompiled with CFR 0.152.
 */
package ninja.genuine.tooltips;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLModDisabledEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import ninja.genuine.tooltips.client.RenderEvent;
import ninja.genuine.tooltips.system.Tooltip;

@Mod(modid="world-tooltips", name="World-Tooltips", version="1.2.3", canBeDeactivated=true, useMetadata=true, guiFactory="ninja.genuine.tooltips.client.TooltipsGuiFactory")
public class WorldTooltips {
    @Mod.Instance(value="world-tooltips")
    public static WorldTooltips instance;
    public static Configuration config;
    public static final String MODID = "world-tooltips";
    public static final String NAME = "World-Tooltips";
    public static final String URL = "http://genuine.ninja/world-tooltips/";
    public static final String VERSION = "1.2.3";
    public static final String DESC = "Choose a color in hexidecimal (ie: 0xAB12cd or #AB12cd) \nYou can look up your favorite colors online.";
    public static final String GUIID = "worldtooltipsgui";
    public static int colorBackground;
    public static int overrideOutlineColor;
    public static int maxDistance;
    public static float alpha;
    public static boolean hideModName;
    public static boolean overrideOutline;
    private static boolean enabled;
    public RenderEvent events;

    public WorldTooltips() {
        instance = this;
    }

    @Mod.EventHandler
    public void pre(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile(), VERSION);
        enabled = config.get("Appearance", "Enable Mod", true, "Enable rendering the tooltips.").getBoolean();
        this.syncConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.events = new RenderEvent();
        Tooltip.init();
        if (enabled) {
            this.enable();
        }
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Mod.EventHandler
    public void post(FMLPostInitializationEvent event) {
        this.events.post();
    }

    public void enable() {
        MinecraftForge.EVENT_BUS.register((Object)this.events);
        enabled = true;
    }

    @Mod.EventHandler
    public void disable(FMLModDisabledEvent event) {
        MinecraftForge.EVENT_BUS.unregister((Object)this.events);
        enabled = false;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MODID) && event.configID.equals(GUIID)) {
            boolean tmp = enabled;
            if (tmp != (enabled = config.get("Appearance", "Enable Mod", true, "Enable rendering the tooltips.").getBoolean())) {
                if (enabled) {
                    this.enable();
                } else {
                    this.disable(null);
                }
            }
            this.syncConfig();
            this.events.syncColors();
        }
    }

    private void syncConfig() {
        hideModName = config.getBoolean("Hide Mod Name", "Appearance", false, "Hide mod names on tooltips.");
        maxDistance = config.getInt("Maximum Draw Distance", "Appearance", 8, 2, 64, "Set the maximum distance that tooltips should be displayed from.");
        overrideOutline = config.getBoolean("Override Outline", "Appearance", false, "If enabled outline color will be manually set instead of default behavior.");
        alpha = config.getFloat("Transparency", "Appearance", 0.8f, 0.0f, 1.0f, "Set the opacity for the tooltips; 0 being completely invisible and 1 being completely opaque.");
        try {
            colorBackground = Integer.decode(config.get("Appearance", "Background Color", "0x100010", DESC, Property.Type.COLOR).getString());
        }
        catch (NumberFormatException e) {
            colorBackground = 0x100010;
        }
        try {
            overrideOutlineColor = Integer.decode(config.get("Appearance", "Outline Color", "0x5000FF", DESC, Property.Type.COLOR).getString());
        }
        catch (NumberFormatException e) {
            overrideOutlineColor = 0x5000FF;
        }
        config.save();
    }

    static {
        enabled = false;
    }
}

