/*
 * Decompiled with CFR 0.152.
 */
package ninja.genuine.tooltips.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import ninja.genuine.tooltips.WorldTooltips;
import ninja.genuine.tooltips.system.Tooltip;

public class RenderEvent {
    private Minecraft mc;
    private EntityItem entity;
    private Tooltip cache;

    public void post() {
        this.mc = Minecraft.func_71410_x();
    }

    public void syncColors() {
        if (!Objects.isNull(this.cache)) {
            this.cache.syncSettings();
        }
    }

    @SubscribeEvent
    public void render(RenderWorldLastEvent event) {
        this.entity = RenderEvent.getMouseOver(this.mc, event.partialTicks);
        if (!Objects.isNull(this.entity)) {
            if (Objects.isNull(this.cache) || this.cache.getEntity() != this.entity) {
                this.cache = new Tooltip((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.entity);
            }
            this.cache.renderTooltip3D(this.mc, event.partialTicks);
        }
    }

    @SubscribeEvent
    public void render(RenderGameOverlayEvent.Post event) {
    }

    public static EntityItem getMouseOver(Minecraft mc, float partialTicks) {
        EntityLivingBase viewer = mc.field_71451_h;
        mc.field_71424_I.func_76320_a("world-tooltips");
        double distanceLook = WorldTooltips.maxDistance;
        Vec3 eyes = viewer.func_70666_h(partialTicks);
        Vec3 look = viewer.func_70676_i(partialTicks);
        Vec3 eyesLook = eyes.func_72441_c(look.field_72450_a * distanceLook, look.field_72448_b * distanceLook, look.field_72449_c * distanceLook);
        float distanceMax = 1.0f;
        List entityList = mc.field_71441_e.func_72872_a(EntityItem.class, viewer.field_70121_D.func_72321_a(look.field_72450_a * distanceLook, look.field_72448_b * distanceLook, look.field_72449_c * distanceLook).func_72314_b((double)distanceMax, (double)distanceMax, (double)distanceMax));
        double difference = 0.0;
        EntityItem target = null;
        for (int i = 0; i < entityList.size(); ++i) {
            double distance;
            EntityItem entity = (EntityItem)entityList.get(i);
            if (Objects.isNull(entity) || Objects.isNull(entity.field_70121_D)) continue;
            float boundSize = 0.15f;
            AxisAlignedBB aabb1 = entity.field_70121_D;
            AxisAlignedBB aabb2 = AxisAlignedBB.func_72330_a((double)aabb1.field_72340_a, (double)aabb1.field_72338_b, (double)aabb1.field_72339_c, (double)aabb1.field_72336_d, (double)aabb1.field_72337_e, (double)aabb1.field_72334_f);
            AxisAlignedBB expandedAABB = aabb2.func_72317_d(0.0, 0.25, 0.0).func_72314_b(0.15, 0.1, 0.15).func_72314_b((double)boundSize, (double)boundSize, (double)boundSize);
            MovingObjectPosition objectInVector = expandedAABB.func_72327_a(eyes, eyesLook);
            if (expandedAABB.func_72318_a(eyes)) {
                if (!(0.0 <= difference)) continue;
                target = entity;
                difference = 0.0;
                continue;
            }
            if (objectInVector == null || !((distance = eyes.func_72438_d(objectInVector.field_72307_f)) < difference) && difference != 0.0) continue;
            target = entity;
            difference = distance;
        }
        mc.field_71424_I.func_76319_b();
        return target;
    }
}

