/*
 * Decompiled with CFR 0.152.
 */
package ninja.genuine.tooltips.system;

import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import ninja.genuine.tooltips.WorldTooltips;
import ninja.genuine.tooltips.client.render.RenderHelper;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;

public class Tooltip {
    private static final Map<String, String> itemIdToModName = new HashMap<String, String>();
    private static final Map<EnumChatFormatting, Integer> formattingToColorCode = new HashMap<EnumChatFormatting, Integer>();
    private static Class<?> nei;
    private static Method info;
    private static boolean useNei;
    int colorBackground;
    int overrideOutlineColor;
    int alpha;
    int width;
    int height;
    boolean overrideOutline;
    EntityItem entity;
    List<String> text = new ArrayList<String>();

    public static void init() {
        Map modMap = Loader.instance().getIndexedModList();
        for (Map.Entry modEntry : modMap.entrySet()) {
            String lowercaseId = ((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH);
            String modName = ((ModContainer)modEntry.getValue()).getName();
            itemIdToModName.put(lowercaseId, modName);
        }
        formattingToColorCode.put(EnumChatFormatting.BLACK, 0);
        formattingToColorCode.put(EnumChatFormatting.DARK_BLUE, 170);
        formattingToColorCode.put(EnumChatFormatting.DARK_GREEN, 43520);
        formattingToColorCode.put(EnumChatFormatting.DARK_AQUA, 43690);
        formattingToColorCode.put(EnumChatFormatting.DARK_RED, 0xAA0000);
        formattingToColorCode.put(EnumChatFormatting.DARK_PURPLE, 0xAA00AA);
        formattingToColorCode.put(EnumChatFormatting.GOLD, 0xFFAA00);
        formattingToColorCode.put(EnumChatFormatting.GRAY, 0xAAAAAA);
        formattingToColorCode.put(EnumChatFormatting.DARK_GRAY, 0x555555);
        formattingToColorCode.put(EnumChatFormatting.BLUE, 0x5555FF);
        formattingToColorCode.put(EnumChatFormatting.GREEN, 0x55FF55);
        formattingToColorCode.put(EnumChatFormatting.AQUA, 0x55FFFF);
        formattingToColorCode.put(EnumChatFormatting.RED, 0xFF5555);
        formattingToColorCode.put(EnumChatFormatting.LIGHT_PURPLE, 0xFF55FF);
        formattingToColorCode.put(EnumChatFormatting.YELLOW, 0xFFFF55);
        formattingToColorCode.put(EnumChatFormatting.WHITE, 0xFFFFFF);
        try {
            nei = Class.forName("codechicken.nei.guihook.GuiContainerManager");
            if (nei != null) {
                info = nei.getDeclaredMethod("itemDisplayNameMultiline", ItemStack.class, GuiContainer.class, Boolean.TYPE);
                useNei = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Tooltip(EntityPlayer player, EntityItem entity) {
        this.entity = entity;
        this.syncSettings();
        this.generateTooltip(player, entity.func_92059_d());
    }

    public void syncSettings() {
        this.overrideOutline = WorldTooltips.overrideOutline;
        this.alpha = ((int)(WorldTooltips.alpha * 255.0f) & 0xFF) << 24;
        this.colorBackground = WorldTooltips.colorBackground & 0xFFFFFF;
        this.overrideOutlineColor = WorldTooltips.overrideOutlineColor & 0xFFFFFF;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public EntityItem getEntity() {
        return this.entity;
    }

    public int size() {
        return this.text.size();
    }

    public String getLine(int line) {
        return this.text.get(line);
    }

    public EnumChatFormatting getRarityColor() {
        return this.entity.func_92059_d().func_77953_t().field_77937_e;
    }

    private void generateTooltip(EntityPlayer player, ItemStack item) {
        if (useNei) {
            try {
                this.text = (List)info.invoke(null, this.entity.func_92059_d(), null, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Objects.isNull(this.text) || this.text.isEmpty()) {
            this.text = item.func_82840_a(player, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        if (!this.modsAreLoaded() && !WorldTooltips.hideModName) {
            this.text.add(ChatFormatting.BLUE.toString() + ChatFormatting.ITALIC.toString() + this.getModName(item.func_77973_b()) + ChatFormatting.RESET.toString());
        }
        if (item.field_77994_a > 1) {
            this.text.set(0, item.field_77994_a + " x " + this.text.get(0));
        }
        int maxwidth = 0;
        for (int line = 0; line < this.text.size(); ++line) {
            int swidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.getLine(line));
            if (swidth <= maxwidth) continue;
            maxwidth = swidth;
        }
        this.width = maxwidth;
        this.height = 8;
        if (this.size() > 1) {
            this.height += 2 + (this.size() - 1) * 10;
        }
    }

    private boolean modsAreLoaded() {
        return Loader.isModLoaded((String)"waila") | Loader.isModLoaded((String)"nei") | Loader.isModLoaded((String)"hwyla");
    }

    private String getModName(Item item) {
        String fullName = Item.field_150901_e.func_148750_c((Object)item);
        String modId = fullName.substring(0, fullName.indexOf(":"));
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = itemIdToModName.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            itemIdToModName.put(lowercaseModId, modName);
        }
        return modName;
    }

    public void renderTooltip3D(Minecraft mc, double partialTicks) {
        ScaledResolution sr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int outline1 = this.overrideOutline ? this.overrideOutlineColor : formattingToColorCode.getOrDefault(this.getRarityColor(), this.overrideOutlineColor);
        outline1 = (outline1 & 0xFEFEFE) >> 1 | this.alpha;
        int outline2 = (outline1 & 0xFEFEFE) >> 1 | this.alpha;
        double interpX = RenderManager.field_78725_b - (this.entity.field_70165_t - (this.entity.field_70169_q - this.entity.field_70165_t) * partialTicks);
        double interpY = RenderManager.field_78726_c - (this.entity.field_70163_u - (this.entity.field_70167_r - this.entity.field_70163_u) * partialTicks);
        double interpZ = RenderManager.field_78723_d - (this.entity.field_70161_v - (this.entity.field_70166_s - this.entity.field_70161_v) * partialTicks);
        double interpDistance = Math.sqrt(interpX * interpX + interpY * interpY + interpZ * interpZ);
        RenderHelper.start();
        GL11.glTranslated((double)(-interpX), (double)(-(interpY - 0.55)), (double)(-interpZ));
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        double scale = interpDistance;
        scale /= (double)(sr.func_78325_e() * 160);
        if (scale <= 0.01) {
            scale = 0.01;
        }
        GL11.glScaled((double)scale, (double)(-scale), (double)scale);
        int x = -this.getWidth() / 2;
        int y = -this.getHeight();
        RenderHelper.renderTooltipTile(x, y, this.getWidth(), this.getHeight(), this.colorBackground | this.alpha, outline1 | this.alpha, outline2 | this.alpha);
        RenderHelper.renderTooltipText(this, x, y, this.alpha);
        GL11.glScaled((double)(1.0 / scale), (double)(1.0 / -scale), (double)(1.0 / scale));
        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(RenderManager.field_78727_a.field_78735_i - 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)interpX, (double)(interpY - (double)this.entity.field_70131_O - 0.5), (double)interpZ);
        RenderHelper.end();
    }

    static {
        useNei = false;
    }
}

