/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.forgewrapper.installer;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.actions.PostProcessors;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.Install;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;

public class Installer {
    private static InstallV1Wrapper wrapper;

    private static InstallV1Wrapper getWrapper(File librariesDir) {
        if (wrapper == null) {
            wrapper = new InstallV1Wrapper(Util.loadInstallProfile(), librariesDir);
        }
        return wrapper;
    }

    public static Map<String, Object> getData(File librariesDir) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Version0 version = Version0.loadVersion((Install)Installer.getWrapper(librariesDir));
        data.put("mainClass", version.getMainClass());
        data.put("jvmArgs", version.getArguments().getJvm());
        data.put("extraLibraries", Installer.getExtraLibraries(version));
        return data;
    }

    public static boolean install(File libraryDir, File minecraftJar, File installerJar, String launchTarget) throws Throwable {
        ProgressCallback monitor = ProgressCallback.withOutputs((OutputStream[])new OutputStream[]{System.out});
        if (System.getProperty("java.net.preferIPv4Stack") == null) {
            System.setProperty("java.net.preferIPv4Stack", "true");
        }
        String vendor = System.getProperty("java.vendor", "missing vendor");
        String javaVersion = System.getProperty("java.version", "missing java version");
        String jvmVersion = System.getProperty("java.vm.version", "missing jvm version");
        monitor.message(String.format("JVM info: %s - %s - %s", vendor, javaVersion, jvmVersion));
        monitor.message("java.net.preferIPv4Stack=" + System.getProperty("java.net.preferIPv4Stack"));
        monitor.message("Current Time: " + new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date()));
        boolean isClient = launchTarget.equals("forgeclient") || launchTarget.equals("forge_client") || launchTarget.equals("fmlclient");
        PostProcessors processors = new PostProcessors((InstallV1)wrapper, isClient, monitor);
        Method processMethod = PostProcessors.class.getMethod("process", File.class, File.class, File.class, File.class);
        if (Boolean.TYPE.equals(processMethod.getReturnType())) {
            return (Boolean)processMethod.invoke((Object)processors, libraryDir, minecraftJar, libraryDir.getParentFile(), installerJar);
        }
        return processMethod.invoke((Object)processors, libraryDir, minecraftJar, libraryDir.getParentFile(), installerJar) != null;
    }

    private static List<String> getExtraLibraries(Version0 version) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Version.Library library : version.getLibraries()) {
            Version.LibraryDownload artifact = library.getDownloads().getArtifact();
            if (!artifact.getUrl().isEmpty()) continue;
            paths.add(artifact.getPath());
        }
        return paths;
    }

    public static class Version0
    extends Version {
        protected String mainClass;
        protected Arguments arguments;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Version0 loadVersion(Install profile) {
            try (InputStream stream = Util.class.getResourceAsStream(profile.getJson());){
                Version0 version0 = (Version0)((Object)Util.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), Version0.class));
                return version0;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public Arguments getArguments() {
            return this.arguments;
        }

        public static class Arguments {
            protected String[] jvm;

            public String[] getJvm() {
                return this.jvm;
            }
        }
    }

    public static class InstallV1Wrapper
    extends InstallV1 {
        protected Map<String, List<Install.Processor>> processors = new HashMap<String, List<Install.Processor>>();
        protected File librariesDir;
        private static Field outputsField;

        public InstallV1Wrapper(InstallV1 v1, File librariesDir) {
            super((Install)v1);
            this.serverJarPath = v1.getServerJarPath();
            this.librariesDir = librariesDir;
        }

        public List<Install.Processor> getProcessors(String side) {
            List processor = this.processors.get(side);
            if (processor == null) {
                processor = super.getProcessors(side);
                InstallV1Wrapper.checkProcessorFiles(processor, super.getData("client".equals(side)), this.librariesDir);
                this.processors.put(side, processor);
            }
            return processor;
        }

        private static void checkProcessorFiles(List<Install.Processor> processors, Map<String, String> data, File base) {
            HashMap<String, File> artifactData = new HashMap<String, File>();
            for (Map.Entry<String, String> entry : data.entrySet()) {
                String string = entry.getValue();
                if (string.charAt(0) != '[' || string.charAt(string.length() - 1) != ']') continue;
                artifactData.put("{" + entry.getKey() + "}", Artifact.from((String)string.substring(1, string.length() - 1)).getLocalPath(base));
            }
            HashMap outputsMap = new HashMap();
            block1: for (Install.Processor processor : processors) {
                HashMap outputs = new HashMap();
                if (!processor.getOutputs().isEmpty()) continue;
                String[] args = processor.getArgs();
                for (int i = 0; i < args.length; ++i) {
                    for (Map.Entry entry : artifactData.entrySet()) {
                        if (!args[i].contains((CharSequence)entry.getKey())) continue;
                        if (((File)entry.getValue()).exists()) {
                            outputs.put(entry.getKey(), DownloadUtils.getSha1((File)((File)entry.getValue())));
                            continue;
                        }
                        outputsMap.clear();
                        break block1;
                    }
                }
                outputsMap.put(processor, outputs);
            }
            for (Map.Entry entry : outputsMap.entrySet()) {
                InstallV1Wrapper.setOutputs((Install.Processor)entry.getKey(), (Map)entry.getValue());
            }
        }

        private static void setOutputs(Install.Processor processor, Map<String, String> outputs) {
            try {
                if (outputsField == null) {
                    outputsField = Install.Processor.class.getDeclaredField("outputs");
                    outputsField.setAccessible(true);
                }
                outputsField.set(processor, outputs);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

