/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.IRenderCall;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;

public class RenderSystem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ConcurrentLinkedQueue<IRenderCall> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final Tessellator RENDER_THREAD_TESSELATOR = new Tessellator();
    public static final float DEFAULTALPHACUTOFF = 0.1f;
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    private static Thread gameThread;
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean bl) {
        boolean bl2 = \u2603 = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || \u2603 == bl) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static boolean isOnGameThreadOrInit() {
        return isInInit || RenderSystem.isOnGameThread();
    }

    public static void assertThread(Supplier<Boolean> supplier) {
        if (!supplier.get().booleanValue()) {
            throw new IllegalStateException("Rendersystem called from wrong thread");
        }
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(IRenderCall iRenderCall) {
        recordingQueue.add(iRenderCall);
    }

    public static void flipFrame(long l) {
        GLFW.glfwPollEvents();
        RenderSystem.replayQueue();
        Tessellator.func_178181_a().func_178180_c().func_178965_a();
        GLFW.glfwSwapBuffers((long)l);
        GLFW.glfwPollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            IRenderCall iRenderCall = recordingQueue.poll();
            iRenderCall.execute();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int n) {
        double d = lastDrawTime + 1.0 / (double)n;
        \u2603 = GLFW.glfwGetTime();
        while (\u2603 < d) {
            GLFW.glfwWaitEventsTimeout((double)(d - \u2603));
            \u2603 = GLFW.glfwGetTime();
        }
        lastDrawTime = \u2603;
    }

    @Deprecated
    public static void pushLightingAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227630_a_();
    }

    @Deprecated
    public static void pushTextureAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227669_b_();
    }

    @Deprecated
    public static void popAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227686_c_();
    }

    @Deprecated
    public static void disableAlphaTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227700_d_();
    }

    @Deprecated
    public static void enableAlphaTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227709_e_();
    }

    @Deprecated
    public static void alphaFunc(int n, float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227639_a_(n, f);
    }

    @Deprecated
    public static void enableLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227716_f_();
    }

    @Deprecated
    public static void disableLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227722_g_();
    }

    @Deprecated
    public static void enableColorMaterial() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227725_h_();
    }

    @Deprecated
    public static void disableColorMaterial() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227728_i_();
    }

    @Deprecated
    public static void colorMaterial(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227641_a_(n, n2);
    }

    @Deprecated
    public static void normal3f(float f, float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227636_a_(f, f2, f3);
    }

    public static void disableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227731_j_();
    }

    public static void enableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_227734_k_();
    }

    public static void enableScissor(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_244594_k();
        GlStateManager.func_244592_a(n, n2, n3, n4);
    }

    public static void disableScissor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_244593_j();
    }

    public static void depthFunc(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227674_b_(n);
    }

    public static void depthMask(boolean bl) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227667_a_(bl);
    }

    public static void enableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227740_m_();
    }

    public static void disableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227737_l_();
    }

    public static void blendFunc(GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227676_b_(sourceFactor.field_225655_p_, destFactor.field_225654_o_);
    }

    public static void blendFunc(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227676_b_(n, n2);
    }

    public static void blendFuncSeparate(GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor, GlStateManager.SourceFactor sourceFactor2, GlStateManager.DestFactor destFactor2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227644_a_(sourceFactor.field_225655_p_, destFactor.field_225654_o_, sourceFactor2.field_225655_p_, destFactor2.field_225654_o_);
    }

    public static void blendFuncSeparate(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227644_a_(n, n2, n3, n4);
    }

    public static void blendEquation(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227690_c_(n);
    }

    public static void blendColor(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227637_a_(f, f2, f3, f4);
    }

    @Deprecated
    public static void enableFog() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227767_x_();
    }

    @Deprecated
    public static void disableFog() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227769_y_();
    }

    @Deprecated
    public static void fogMode(GlStateManager.FogMode fogMode) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227750_p_(fogMode.field_187351_d);
    }

    @Deprecated
    public static void fogMode(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227750_p_(n);
    }

    @Deprecated
    public static void fogDensity(float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227634_a_(f);
    }

    @Deprecated
    public static void fogStart(float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227671_b_(f);
    }

    @Deprecated
    public static void fogEnd(float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227687_c_(f);
    }

    @Deprecated
    public static void fog(int n, float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227660_a_(n, new float[]{f, f2, f3, f4});
    }

    @Deprecated
    public static void fogi(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227742_m_(n, n2);
    }

    public static void enableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227771_z_();
    }

    public static void disableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227605_A_();
    }

    public static void polygonMode(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227745_n_(n, n2);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227607_B_();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227609_C_();
    }

    public static void enableLineOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227611_D_();
    }

    public static void disableLineOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227613_E_();
    }

    public static void polygonOffset(float f, float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227635_a_(f, f2);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227615_F_();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227617_G_();
    }

    public static void logicOp(GlStateManager.LogicOp logicOp) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227753_q_(logicOp.field_187370_q);
    }

    public static void activeTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227756_r_(n);
    }

    public static void enableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227619_H_();
    }

    public static void disableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227621_I_();
    }

    public static void texParameter(int n, int n2, int n3) {
        GlStateManager.func_227677_b_(n, n2, n3);
    }

    public static void deleteTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_227758_s_(n);
    }

    public static void bindTexture(int n) {
        GlStateManager.func_227760_t_(n);
    }

    @Deprecated
    public static void shadeModel(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227762_u_(n);
    }

    @Deprecated
    public static void enableRescaleNormal() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227623_K_();
    }

    @Deprecated
    public static void disableRescaleNormal() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227624_L_();
    }

    public static void viewport(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_227714_e_(n, n2, n3, n4);
    }

    public static void colorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227668_a_(bl, bl2, bl3, bl4);
    }

    public static void stencilFunc(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227705_d_(n, n2, n3);
    }

    public static void stencilMask(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227764_v_(n);
    }

    public static void stencilOp(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227713_e_(n, n2, n3);
    }

    public static void clearDepth(double d) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_227631_a_(d);
    }

    public static void clearColor(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_227673_b_(f, f2, f3, f4);
    }

    public static void clearStencil(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227766_w_(n);
    }

    public static void clear(int n, boolean bl) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_227658_a_(n, bl);
    }

    @Deprecated
    public static void matrixMode(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227768_x_(n);
    }

    @Deprecated
    public static void loadIdentity() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227625_M_();
    }

    @Deprecated
    public static void pushMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227626_N_();
    }

    @Deprecated
    public static void popMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227627_O_();
    }

    @Deprecated
    public static void ortho(double d, double d2, double d3, double d4, double d5, double d6) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227633_a_(d, d2, d3, d4, d5, d6);
    }

    @Deprecated
    public static void rotatef(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227689_c_(f, f2, f3, f4);
    }

    @Deprecated
    public static void scalef(float f, float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227672_b_(f, f2, f3);
    }

    @Deprecated
    public static void scaled(double d, double d2, double d3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227632_a_(d, d2, d3);
    }

    @Deprecated
    public static void translatef(float f, float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227688_c_(f, f2, f3);
    }

    @Deprecated
    public static void translated(double d, double d2, double d3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227670_b_(d, d2, d3);
    }

    @Deprecated
    public static void multMatrix(Matrix4f matrix4f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227699_c_(matrix4f);
    }

    @Deprecated
    public static void color4f(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227702_d_(f, f2, f3, f4);
    }

    @Deprecated
    public static void color3f(float f, float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227702_d_(f, f2, f3, 1.0f);
    }

    @Deprecated
    public static void clearCurrentColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227628_P_();
    }

    public static void drawArrays(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227719_f_(n, n2, n3);
    }

    public static void lineWidth(float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227701_d_(f);
    }

    public static void pixelStore(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_227748_o_(n, n2);
    }

    public static void pixelTransfer(int n, float f) {
        GlStateManager.func_227675_b_(n, f);
    }

    public static void readPixels(int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227648_a_(n, n2, n3, n4, n5, n6, byteBuffer);
    }

    public static void getString(int n, Consumer<String> consumer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        consumer.accept(GlStateManager.func_227610_C_(n));
    }

    public static String getBackendDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return String.format("LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX.getOpenGLVersionString();
    }

    public static LongSupplier initBackendSystem() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX._initGlfw();
    }

    public static void initRenderer(int n, boolean bl) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._init(n, bl);
    }

    public static void setErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._setGlfwErrorCallback(gLFWErrorCallbackI);
    }

    public static void renderCrosshair(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._renderCrosshair(n, true, true, true);
    }

    public static void setupNvFogDistance() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._setupNvFogDistance();
    }

    @Deprecated
    public static void glMultiTexCoord2f(int n, float f, float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227640_a_(n, f, f2);
    }

    public static String getCapsString() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        return GLX._getCapsString();
    }

    public static void setupDefaultState(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GlStateManager.func_227619_H_();
        GlStateManager.func_227762_u_(7425);
        GlStateManager.func_227631_a_(1.0);
        GlStateManager.func_227734_k_();
        GlStateManager.func_227674_b_(515);
        GlStateManager.func_227709_e_();
        GlStateManager.func_227639_a_(516, 0.1f);
        GlStateManager.func_227768_x_(5889);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227768_x_(5888);
        GlStateManager.func_227714_e_(n, n2, n3, n4);
    }

    public static int maxSupportedTextureSize() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            int n = GlStateManager.func_227612_D_(3379);
            for (\u2603 = Math.max(32768, n); \u2603 >= 1024; \u2603 >>= 1) {
                GlStateManager.func_227647_a_(32868, 0, 6408, \u2603, \u2603, 0, 6408, 5121, null);
                \u2603 = GlStateManager.func_227692_c_(32868, 0, 4096);
                if (\u2603 == 0) continue;
                MAX_SUPPORTED_TEXTURE_SIZE = \u2603;
                return \u2603;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max(n, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int n, Supplier<Integer> supplier) {
        GlStateManager.func_227724_g_(n, supplier.get());
    }

    public static void glBufferData(int n, ByteBuffer byteBuffer, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.func_227655_a_(n, byteBuffer, n2);
    }

    public static void glDeleteBuffers(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227732_j_(n);
    }

    public static void glUniform1i(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227718_f_(n, n2);
    }

    public static void glUniform1(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227657_a_(n, intBuffer);
    }

    public static void glUniform2(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227682_b_(n, intBuffer);
    }

    public static void glUniform3(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227697_c_(n, intBuffer);
    }

    public static void glUniform4(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227708_d_(n, intBuffer);
    }

    public static void glUniform1(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227681_b_(n, floatBuffer);
    }

    public static void glUniform2(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227696_c_(n, floatBuffer);
    }

    public static void glUniform3(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227707_d_(n, floatBuffer);
    }

    public static void glUniform4(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227715_e_(n, floatBuffer);
    }

    public static void glUniformMatrix2(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227659_a_(n, bl, floatBuffer);
    }

    public static void glUniformMatrix3(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227683_b_(n, bl, floatBuffer);
    }

    public static void glUniformMatrix4(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227698_c_(n, bl, floatBuffer);
    }

    public static void setupOutline() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227755_r_();
    }

    public static void teardownOutline() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227757_s_();
    }

    public static void setupOverlayColor(IntSupplier intSupplier, int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227739_l_(intSupplier.getAsInt(), n);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227759_t_();
    }

    public static void setupLevelDiffuseLighting(Vector3f vector3f, Vector3f vector3f2, Matrix4f matrix4f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_237512_a_(vector3f, vector3f2, matrix4f);
    }

    public static void setupGuiFlatDiffuseLighting(Vector3f vector3f, Vector3f vector3f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_237511_a_(vector3f, vector3f2);
    }

    public static void setupGui3DDiffuseLighting(Vector3f vector3f, Vector3f vector3f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_237513_b_(vector3f, vector3f2);
    }

    public static void mulTextureByProjModelView() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227765_w_();
    }

    public static void setupEndPortalTexGen() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227761_u_();
    }

    public static void clearTexGen() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.func_227763_v_();
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> consumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumer.accept(GlStateManager.func_227746_o_()));
        } else {
            consumer.accept(GlStateManager.func_227746_o_());
        }
    }

    public static Tessellator renderThreadTesselator() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }

    public static void defaultAlphaFunc() {
        RenderSystem.alphaFunc(516, 0.1f);
    }

    @Deprecated
    public static void runAsFancy(Runnable runnable) {
        boolean bl = Minecraft.func_238218_y_();
        if (!bl) {
            runnable.run();
            return;
        }
        GameSettings \u26032 = Minecraft.func_71410_x().field_71474_y;
        GraphicsFanciness \u26033 = \u26032.field_238330_f_;
        \u26032.field_238330_f_ = GraphicsFanciness.FANCY;
        runnable.run();
        \u26032.field_238330_f_ = \u26033;
    }

    private static /* synthetic */ void func_244503_lam_(Vector3f vector3f, Vector3f vector3f2) {
        GlStateManager.func_237513_b_(vector3f, vector3f2);
    }

    private static /* synthetic */ void func_244505_lam_(Vector3f vector3f, Vector3f vector3f2) {
        GlStateManager.func_237511_a_(vector3f, vector3f2);
    }

    private static /* synthetic */ void func_244504_lam_(Vector3f vector3f, Vector3f vector3f2, Matrix4f matrix4f) {
        GlStateManager.func_237512_a_(vector3f, vector3f2, matrix4f);
    }

    private static /* synthetic */ void func_244502_lam_(IntSupplier intSupplier, int n) {
        GlStateManager.func_227739_l_(intSupplier.getAsInt(), n);
    }

    private static /* synthetic */ void func_244500_lam_(int n, boolean bl, FloatBuffer floatBuffer) {
        GlStateManager.func_227698_c_(n, bl, floatBuffer);
    }

    private static /* synthetic */ void func_244499_lam_(int n, boolean bl, FloatBuffer floatBuffer) {
        GlStateManager.func_227683_b_(n, bl, floatBuffer);
    }

    private static /* synthetic */ void func_244498_lam_(int n, boolean bl, FloatBuffer floatBuffer) {
        GlStateManager.func_227659_a_(n, bl, floatBuffer);
    }

    private static /* synthetic */ void func_244471_lam_(int n, FloatBuffer floatBuffer) {
        GlStateManager.func_227715_e_(n, floatBuffer);
    }

    private static /* synthetic */ void func_244469_lam_(int n, FloatBuffer floatBuffer) {
        GlStateManager.func_227707_d_(n, floatBuffer);
    }

    private static /* synthetic */ void func_244467_lam_(int n, FloatBuffer floatBuffer) {
        GlStateManager.func_227696_c_(n, floatBuffer);
    }

    private static /* synthetic */ void func_244465_lam_(int n, FloatBuffer floatBuffer) {
        GlStateManager.func_227681_b_(n, floatBuffer);
    }

    private static /* synthetic */ void func_244470_lam_(int n, IntBuffer intBuffer) {
        GlStateManager.func_227708_d_(n, intBuffer);
    }

    private static /* synthetic */ void func_244468_lam_(int n, IntBuffer intBuffer) {
        GlStateManager.func_227697_c_(n, intBuffer);
    }

    private static /* synthetic */ void func_244466_lam_(int n, IntBuffer intBuffer) {
        GlStateManager.func_227682_b_(n, intBuffer);
    }

    private static /* synthetic */ void func_244464_lam_(int n, IntBuffer intBuffer) {
        GlStateManager.func_227657_a_(n, intBuffer);
    }

    private static /* synthetic */ void func_244480_lam_(int n, int n2) {
        GlStateManager.func_227718_f_(n, n2);
    }

    private static /* synthetic */ void func_244494_lam_(int n) {
        GlStateManager.func_227732_j_(n);
    }

    private static /* synthetic */ void func_244486_lam_(int n, Supplier supplier) {
        GlStateManager.func_227724_g_(n, (Integer)supplier.get());
    }

    private static /* synthetic */ void func_244501_lam_(int n, float f, float f2) {
        GlStateManager.func_227640_a_(n, f, f2);
    }

    private static /* synthetic */ void func_244495_lam_(int n) {
        GLX._renderCrosshair(n, true, true, true);
    }

    private static /* synthetic */ void func_244456_lam_(int n, Consumer consumer) {
        String string = GlStateManager.func_227610_C_(n);
        consumer.accept(string);
    }

    private static /* synthetic */ void func_244475_lam_(int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        GlStateManager.func_227648_a_(n, n2, n3, n4, n5, n6, byteBuffer);
    }

    private static /* synthetic */ void func_244492_lam_(int n, float f) {
        GlStateManager.func_227675_b_(n, f);
    }

    private static /* synthetic */ void func_244474_lam_(int n, int n2) {
        GlStateManager.func_227748_o_(n, n2);
    }

    private static /* synthetic */ void func_244457_lam_(float f) {
        GlStateManager.func_227701_d_(f);
    }

    private static /* synthetic */ void func_244462_lam_(int n, int n2, int n3) {
        GlStateManager.func_227719_f_(n, n2, n3);
    }

    private static /* synthetic */ void func_244443_lam_(float f, float f2, float f3) {
        GlStateManager.func_227702_d_(f, f2, f3, 1.0f);
    }

    private static /* synthetic */ void func_244444_lam_(float f, float f2, float f3, float f4) {
        GlStateManager.func_227702_d_(f, f2, f3, f4);
    }

    private static /* synthetic */ void func_244473_lam_(Matrix4f matrix4f) {
        GlStateManager.func_227699_c_(matrix4f);
    }

    private static /* synthetic */ void func_244477_lam_(double d, double d2, double d3) {
        GlStateManager.func_227670_b_(d, d2, d3);
    }

    private static /* synthetic */ void func_244478_lam_(float f, float f2, float f3) {
        GlStateManager.func_227688_c_(f, f2, f3);
    }

    private static /* synthetic */ void func_244441_lam_(double d, double d2, double d3) {
        GlStateManager.func_227632_a_(d, d2, d3);
    }

    private static /* synthetic */ void func_244442_lam_(float f, float f2, float f3) {
        GlStateManager.func_227672_b_(f, f2, f3);
    }

    private static /* synthetic */ void func_244448_lam_(float f, float f2, float f3, float f4) {
        GlStateManager.func_227689_c_(f, f2, f3, f4);
    }

    private static /* synthetic */ void func_244439_lam_(double d, double d2, double d3, double d4, double d5, double d6) {
        GlStateManager.func_227633_a_(d, d2, d3, d4, d5, d6);
    }

    private static /* synthetic */ void func_244472_lam_(int n) {
        GlStateManager.func_227768_x_(n);
    }

    private static /* synthetic */ void func_244438_lam_(int n, boolean bl) {
        GlStateManager.func_227658_a_(n, bl);
    }

    private static /* synthetic */ void func_244484_lam_(int n) {
        GlStateManager.func_227766_w_(n);
    }

    private static /* synthetic */ void func_244460_lam_(float f, float f2, float f3, float f4) {
        GlStateManager.func_227673_b_(f, f2, f3, f4);
    }

    private static /* synthetic */ void func_244461_lam_(double d) {
        GlStateManager.func_227631_a_(d);
    }

    private static /* synthetic */ void func_244458_lam_(int n, int n2, int n3) {
        GlStateManager.func_227713_e_(n, n2, n3);
    }

    private static /* synthetic */ void func_244483_lam_(int n) {
        GlStateManager.func_227764_v_(n);
    }

    private static /* synthetic */ void func_244482_lam_(int n, int n2, int n3) {
        GlStateManager.func_227705_d_(n, n2, n3);
    }

    private static /* synthetic */ void func_244455_lam_(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        GlStateManager.func_227668_a_(bl, bl2, bl3, bl4);
    }

    private static /* synthetic */ void func_244454_lam_(int n, int n2, int n3, int n4) {
        GlStateManager.func_227714_e_(n, n2, n3, n4);
    }

    private static /* synthetic */ void func_244476_lam_(int n) {
        GlStateManager.func_227762_u_(n);
    }

    private static /* synthetic */ void func_244479_lam_(int n) {
        GlStateManager.func_227760_t_(n);
    }

    private static /* synthetic */ void func_244491_lam_(int n) {
        GlStateManager.func_227758_s_(n);
    }

    private static /* synthetic */ void func_244488_lam_(int n, int n2, int n3) {
        GlStateManager.func_227677_b_(n, n2, n3);
    }

    private static /* synthetic */ void func_244489_lam_(int n) {
        GlStateManager.func_227756_r_(n);
    }

    private static /* synthetic */ void func_244447_lam_(GlStateManager.LogicOp logicOp) {
        GlStateManager.func_227753_q_(logicOp.field_187370_q);
    }

    private static /* synthetic */ void func_244493_lam_(float f, float f2) {
        GlStateManager.func_227635_a_(f, f2);
    }

    private static /* synthetic */ void func_244481_lam_(int n, int n2) {
        GlStateManager.func_227745_n_(n, n2);
    }

    private static /* synthetic */ void func_244437_lam_(int n, int n2) {
        GlStateManager.func_227742_m_(n, n2);
    }

    private static /* synthetic */ void func_244436_lam_(int n, float f, float f2, float f3, float f4) {
        GlStateManager.func_227660_a_(n, new float[]{f, f2, f3, f4});
    }

    private static /* synthetic */ void func_244440_lam_(float f) {
        GlStateManager.func_227687_c_(f);
    }

    private static /* synthetic */ void func_244453_lam_(float f) {
        GlStateManager.func_227671_b_(f);
    }

    private static /* synthetic */ void func_244463_lam_(float f) {
        GlStateManager.func_227634_a_(f);
    }

    private static /* synthetic */ void func_244446_lam_(int n) {
        GlStateManager.func_227750_p_(n);
    }

    private static /* synthetic */ void func_244445_lam_(GlStateManager.FogMode fogMode) {
        GlStateManager.func_227750_p_(fogMode.field_187351_d);
    }

    private static /* synthetic */ void func_244459_lam_(float f, float f2, float f3, float f4) {
        GlStateManager.func_227637_a_(f, f2, f3, f4);
    }

    private static /* synthetic */ void func_244490_lam_(int n) {
        GlStateManager.func_227690_c_(n);
    }

    private static /* synthetic */ void func_244497_lam_(int n, int n2, int n3, int n4) {
        GlStateManager.func_227644_a_(n, n2, n3, n4);
    }

    private static /* synthetic */ void func_244496_lam_(GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor, GlStateManager.SourceFactor sourceFactor2, GlStateManager.DestFactor destFactor2) {
        GlStateManager.func_227644_a_(sourceFactor.field_225655_p_, destFactor.field_225654_o_, sourceFactor2.field_225655_p_, destFactor2.field_225654_o_);
    }

    private static /* synthetic */ void func_244450_lam_(int n, int n2) {
        GlStateManager.func_227676_b_(n, n2);
    }

    private static /* synthetic */ void func_244449_lam_(GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor) {
        GlStateManager.func_227676_b_(sourceFactor.field_225655_p_, destFactor.field_225654_o_);
    }

    private static /* synthetic */ void func_244452_lam_(boolean bl) {
        GlStateManager.func_227667_a_(bl);
    }

    private static /* synthetic */ void func_244451_lam_(int n) {
        GlStateManager.func_227674_b_(n);
    }

    private static /* synthetic */ void func_244485_lam_(int n, int n2, int n3, int n4) {
        GlStateManager.func_244594_k();
        GlStateManager.func_244592_a(n, n2, n3, n4);
    }

    private static /* synthetic */ void func_229894_lam_(float f, float f2, float f3) {
        GlStateManager.func_227636_a_(f, f2, f3);
    }

    private static /* synthetic */ void func_229934_lam_(int n, int n2) {
        GlStateManager.func_227641_a_(n, n2);
    }

    private static /* synthetic */ void func_229896_lam_(int n, float f) {
        GlStateManager.func_227639_a_(n, f);
    }

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
    }
}

