/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PistonBlock
extends DirectionalBlock {
    public static final BooleanProperty field_176320_b = BlockStateProperties.field_208181_h;
    protected static final VoxelShape field_185648_b = Block.func_208617_a(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape field_185649_c = Block.func_208617_a(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185650_d = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape field_185651_e = Block.func_208617_a(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185652_f = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape field_185653_g = Block.func_208617_a(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean field_150082_a;

    public PistonBlock(boolean bl, AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176387_N, Direction.NORTH)).func_206870_a(field_176320_b, false));
        this.field_150082_a = bl;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        if (blockState.func_177229_b(field_176320_b).booleanValue()) {
            switch (blockState.func_177229_b(field_176387_N)) {
                case DOWN: {
                    return field_185653_g;
                }
                default: {
                    return field_185652_f;
                }
                case NORTH: {
                    return field_185651_e;
                }
                case SOUTH: {
                    return field_185650_d;
                }
                case WEST: {
                    return field_185649_c;
                }
                case EAST: 
            }
            return field_185648_b;
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (!world.field_72995_K) {
            this.func_176316_e(world, blockPos, blockState);
        }
    }

    @Override
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (!world.field_72995_K) {
            this.func_176316_e(world, blockPos, blockState);
        }
    }

    @Override
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState2.func_203425_a(blockState.func_177230_c())) {
            return;
        }
        if (!world.field_72995_K && world.func_175625_s(blockPos) == null) {
            this.func_176316_e(world, blockPos, blockState);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(field_176387_N, blockItemUseContext.func_196010_d().func_176734_d())).func_206870_a(field_176320_b, false);
    }

    private void func_176316_e(World world, BlockPos blockPos, BlockState blockState) {
        Direction direction = blockState.func_177229_b(field_176387_N);
        boolean \u26032 = this.func_176318_b(world, blockPos, direction);
        if (\u26032 && !blockState.func_177229_b(field_176320_b).booleanValue()) {
            if (new PistonBlockStructureHelper(world, blockPos, direction, true).func_177253_a()) {
                world.func_175641_c(blockPos, this, 0, direction.func_176745_a());
            }
        } else if (!\u26032 && blockState.func_177229_b(field_176320_b).booleanValue()) {
            BlockPos blockPos2 = blockPos.func_177967_a(direction, 2);
            BlockState \u26033 = world.func_180495_p(blockPos2);
            int \u26034 = 1;
            if (\u26033.func_203425_a(Blocks.field_196603_bb) && \u26033.func_177229_b(field_176387_N) == direction && (\u2603 = world.func_175625_s(blockPos2)) instanceof PistonTileEntity && (\u2603 = (PistonTileEntity)\u2603).func_145868_b() && (\u2603.func_145860_a(0.0f) < 0.5f || world.func_82737_E() == \u2603.func_211146_k() || ((ServerWorld)world).func_211158_j_())) {
                \u26034 = 2;
            }
            world.func_175641_c(blockPos, this, \u26034, direction.func_176745_a());
        }
    }

    private boolean func_176318_b(World world, BlockPos blockPos, Direction direction) {
        for (Direction direction2 : Direction.values()) {
            if (direction2 == direction || !world.func_175709_b(blockPos.func_177972_a(direction2), direction2)) continue;
            return true;
        }
        if (world.func_175709_b(blockPos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockPos2 = blockPos.func_177984_a();
        for (Direction direction3 : Direction.values()) {
            if (direction3 == Direction.DOWN || !world.func_175709_b(blockPos2.func_177972_a(direction3), direction3)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_189539_a(BlockState blockState, World world, BlockPos blockPos, int n3, int n2) {
        int n3;
        Direction direction = blockState.func_177229_b(field_176387_N);
        if (!world.field_72995_K) {
            boolean bl = this.func_176318_b(world, blockPos, direction);
            if (bl && (n3 == 1 || n3 == 2)) {
                world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176320_b, true), 2);
                return false;
            }
            if (!bl && n3 == 0) {
                return false;
            }
        }
        if (n3 == 0) {
            if (!this.func_176319_a(world, blockPos, direction, true)) return false;
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176320_b, true), 67);
            world.func_184133_a(null, blockPos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
            return true;
        } else {
            if (n3 != 1 && n3 != 2) return true;
            TileEntity tileEntity = world.func_175625_s(blockPos.func_177972_a(direction));
            if (tileEntity instanceof PistonTileEntity) {
                ((PistonTileEntity)tileEntity).func_145866_f();
            }
            BlockState \u26032 = (BlockState)((BlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a(MovingPistonBlock.field_196344_a, direction)).func_206870_a(MovingPistonBlock.field_196345_b, this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT);
            world.func_180501_a(blockPos, \u26032, 20);
            world.func_175690_a(blockPos, MovingPistonBlock.func_196343_a((BlockState)this.func_176223_P().func_206870_a(field_176387_N, Direction.func_82600_a(n2 & 7)), direction, false, true));
            world.func_230547_a_(blockPos, \u26032.func_177230_c());
            \u26032.func_235734_a_(world, blockPos, 2);
            if (this.field_150082_a) {
                BlockPos blockPos2 = blockPos.func_177982_a(direction.func_82601_c() * 2, direction.func_96559_d() * 2, direction.func_82599_e() * 2);
                BlockState \u26033 = world.func_180495_p(blockPos2);
                boolean \u26034 = false;
                if (\u26033.func_203425_a(Blocks.field_196603_bb) && (\u2603 = world.func_175625_s(blockPos2)) instanceof PistonTileEntity && (\u2603 = (PistonTileEntity)\u2603).func_212363_d() == direction && \u2603.func_145868_b()) {
                    \u2603.func_145866_f();
                    \u26034 = true;
                }
                if (!\u26034) {
                    if (n3 == 1 && !\u26033.func_196958_f() && PistonBlock.func_185646_a(\u26033, world, blockPos2, direction.func_176734_d(), false, direction) && (\u26033.func_185905_o() == PushReaction.NORMAL || \u26033.func_203425_a(Blocks.field_150331_J) || \u26033.func_203425_a(Blocks.field_150320_F))) {
                        this.func_176319_a(world, blockPos, direction, false);
                    } else {
                        world.func_217377_a(blockPos.func_177972_a(direction), false);
                    }
                }
            } else {
                world.func_217377_a(blockPos.func_177972_a(direction), false);
            }
            world.func_184133_a(null, blockPos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    public static boolean func_185646_a(BlockState blockState, World world, BlockPos blockPos, Direction direction, boolean bl, Direction direction2) {
        if (blockPos.func_177956_o() < 0 || blockPos.func_177956_o() > world.func_217301_I() - 1 || !world.func_175723_af().func_177746_a(blockPos)) {
            return false;
        }
        if (blockState.func_196958_f()) {
            return true;
        }
        if (blockState.func_203425_a(Blocks.field_150343_Z) || blockState.func_203425_a(Blocks.field_235399_ni_) || blockState.func_203425_a(Blocks.field_235400_nj_)) {
            return false;
        }
        if (direction == Direction.DOWN && blockPos.func_177956_o() == 0) {
            return false;
        }
        if (direction == Direction.UP && blockPos.func_177956_o() == world.func_217301_I() - 1) {
            return false;
        }
        if (blockState.func_203425_a(Blocks.field_150331_J) || blockState.func_203425_a(Blocks.field_150320_F)) {
            if (blockState.func_177229_b(field_176320_b).booleanValue()) {
                return false;
            }
        } else {
            if (blockState.func_185887_b(world, blockPos) == -1.0f) {
                return false;
            }
            switch (blockState.func_185905_o()) {
                case BLOCK: {
                    return false;
                }
                case DESTROY: {
                    return bl;
                }
                case PUSH_ONLY: {
                    return direction == direction2;
                }
            }
        }
        return !blockState.func_177230_c().func_235695_q_();
    }

    private boolean func_176319_a(World world, BlockPos blockPos, Direction direction, boolean bl2) {
        BlockPos blockPos2;
        Object object;
        PistonBlockStructureHelper pistonBlockStructureHelper;
        BlockPos blockPos22 = blockPos.func_177972_a(direction);
        if (!bl2 && world.func_180495_p(blockPos22).func_203425_a(Blocks.field_150332_K)) {
            world.func_180501_a(blockPos22, Blocks.field_150350_a.func_176223_P(), 20);
        }
        if (!(pistonBlockStructureHelper = new PistonBlockStructureHelper(world, blockPos, direction, bl2)).func_177253_a()) {
            return false;
        }
        HashMap \u26032 = Maps.newHashMap();
        List<BlockPos> \u26033 = pistonBlockStructureHelper.func_177254_c();
        ArrayList \u26034 = Lists.newArrayList();
        for (int i = 0; i < \u26033.size(); ++i) {
            BlockPos \u26036 = \u26033.get(i);
            BlockState \u26035 = world.func_180495_p(\u26036);
            \u26034.add(\u26035);
            \u26032.put(\u26036, \u26035);
        }
        List<BlockPos> list = pistonBlockStructureHelper.func_177252_d();
        BlockState[] \u26039 = new BlockState[\u26033.size() + list.size()];
        Direction \u260311 = bl2 ? direction : direction.func_176734_d();
        int \u26037 = 0;
        for (int n2 = list.size() - 1; n2 >= 0; --n2) {
            BlockPos \u26038 = list.get(n2);
            BlockState blockState = world.func_180495_p(\u26038);
            TileEntity object2 = blockState.func_177230_c().func_235695_q_() ? world.func_175625_s(\u26038) : null;
            PistonBlock.func_220059_a(blockState, world, \u26038, object2);
            world.func_180501_a(\u26038, Blocks.field_150350_a.func_176223_P(), 18);
            \u26039[\u26037++] = blockState;
        }
        for (int i = \u26033.size() - 1; i >= 0; --i) {
            object = \u26033.get(i);
            BlockState blockState = world.func_180495_p((BlockPos)object);
            object = ((BlockPos)object).func_177972_a(\u260311);
            \u26032.remove(object);
            world.func_180501_a((BlockPos)object, (BlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a(field_176387_N, direction), 68);
            world.func_175690_a((BlockPos)object, MovingPistonBlock.func_196343_a((BlockState)\u26034.get(i), direction, bl2, false));
            \u26039[\u26037++] = blockState;
        }
        if (bl2) {
            PistonType pistonType = this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT;
            object = (BlockState)((BlockState)Blocks.field_150332_K.func_176223_P().func_206870_a(PistonHeadBlock.field_176387_N, direction)).func_206870_a(PistonHeadBlock.field_176325_b, pistonType);
            BlockState blockState = (BlockState)((BlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a(MovingPistonBlock.field_196344_a, direction)).func_206870_a(MovingPistonBlock.field_196345_b, this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT);
            \u26032.remove(blockPos22);
            world.func_180501_a(blockPos22, blockState, 68);
            world.func_175690_a(blockPos22, MovingPistonBlock.func_196343_a((BlockState)object, direction, true, true));
        }
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        for (BlockPos blockPos3 : \u26032.keySet()) {
            world.func_180501_a(blockPos3, blockState, 82);
        }
        for (Map.Entry entry : \u26032.entrySet()) {
            blockPos2 = (BlockPos)entry.getKey();
            BlockState \u260310 = (BlockState)entry.getValue();
            \u260310.func_196948_b(world, blockPos2, 2);
            blockState.func_235734_a_(world, blockPos2, 2);
            blockState.func_196948_b(world, blockPos2, 2);
        }
        \u26037 = 0;
        for (int n = list.size() - 1; n >= 0; --n) {
            BlockState blockState2 = \u26039[\u26037++];
            blockPos2 = list.get(n);
            blockState2.func_196948_b(world, blockPos2, 2);
            world.func_195593_d(blockPos2, blockState2.func_177230_c());
        }
        for (int i = \u26033.size() - 1; i >= 0; --i) {
            world.func_195593_d(\u26033.get(i), \u26039[\u26037++].func_177230_c());
        }
        if (bl2) {
            world.func_195593_d(blockPos22, Blocks.field_150332_K);
        }
        return true;
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a(field_176387_N, rotation.func_185831_a(blockState.func_177229_b(field_176387_N)));
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a(blockState.func_177229_b(field_176387_N)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176387_N, field_176320_b);
    }

    @Override
    public boolean func_220074_n(BlockState blockState) {
        return blockState.func_177229_b(field_176320_b);
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

