/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.audio.IAudioStream;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class OggAudioStream
implements IAudioStream {
    private long field_216461_a;
    private final AudioFormat field_216462_b;
    private final InputStream field_216463_c;
    private ByteBuffer field_216464_d = MemoryUtil.memAlloc((int)8192);

    public OggAudioStream(InputStream inputStream) throws IOException {
        this.field_216463_c = inputStream;
        this.field_216464_d.limit(0);
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            IntBuffer intBuffer = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            while (this.field_216461_a == 0L) {
                if (!this.func_216456_c()) {
                    throw new IOException("Failed to find Ogg header");
                }
                int n = this.field_216464_d.position();
                this.field_216464_d.position(0);
                this.field_216461_a = STBVorbis.stb_vorbis_open_pushdata((ByteBuffer)this.field_216464_d, (IntBuffer)intBuffer, (IntBuffer)\u2603, null);
                this.field_216464_d.position(n);
                \u2603 = \u2603.get(0);
                if (\u2603 == 1) {
                    this.func_216459_d();
                    continue;
                }
                if (\u2603 == 0) continue;
                throw new IOException("Failed to read Ogg file " + \u2603);
            }
            this.field_216464_d.position(this.field_216464_d.position() + intBuffer.get(0));
            STBVorbisInfo \u26032 = STBVorbisInfo.mallocStack((MemoryStack)memoryStack);
            STBVorbis.stb_vorbis_get_info((long)this.field_216461_a, (STBVorbisInfo)\u26032);
            this.field_216462_b = new AudioFormat(\u26032.sample_rate(), 16, \u26032.channels(), true, false);
        }
    }

    private boolean func_216456_c() throws IOException {
        int n = this.field_216464_d.limit();
        \u2603 = this.field_216464_d.capacity() - n;
        if (\u2603 == 0) {
            return true;
        }
        byte[] \u26032 = new byte[\u2603];
        \u2603 = this.field_216463_c.read(\u26032);
        if (\u2603 == -1) {
            return false;
        }
        \u2603 = this.field_216464_d.position();
        this.field_216464_d.limit(n + \u2603);
        this.field_216464_d.position(n);
        this.field_216464_d.put(\u26032, 0, \u2603);
        this.field_216464_d.position(\u2603);
        return true;
    }

    private void func_216459_d() {
        boolean bl = this.field_216464_d.position() == 0;
        boolean bl2 = \u2603 = this.field_216464_d.position() == this.field_216464_d.limit();
        if (\u2603 && !bl) {
            this.field_216464_d.position(0);
            this.field_216464_d.limit(0);
        } else {
            ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(bl ? 2 * this.field_216464_d.capacity() : this.field_216464_d.capacity()));
            byteBuffer.put(this.field_216464_d);
            MemoryUtil.memFree((java.nio.Buffer)this.field_216464_d);
            byteBuffer.flip();
            this.field_216464_d = byteBuffer;
        }
    }

    private boolean func_216460_a(Buffer buffer) throws IOException {
        if (this.field_216461_a == 0L) {
            return false;
        }
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            block24: {
                PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
                IntBuffer \u26032 = memoryStack.mallocInt(1);
                IntBuffer \u26033 = memoryStack.mallocInt(1);
                while (true) {
                    int n = STBVorbis.stb_vorbis_decode_frame_pushdata((long)this.field_216461_a, (ByteBuffer)this.field_216464_d, (IntBuffer)\u26032, (PointerBuffer)pointerBuffer, (IntBuffer)\u26033);
                    this.field_216464_d.position(this.field_216464_d.position() + n);
                    \u2603 = STBVorbis.stb_vorbis_get_error((long)this.field_216461_a);
                    if (\u2603 == 1) {
                        this.func_216459_d();
                        if (this.func_216456_c()) continue;
                        break block24;
                    }
                    if (\u2603 != 0) {
                        throw new IOException("Failed to read Ogg file " + \u2603);
                    }
                    \u2603 = \u26033.get(0);
                    if (\u2603 != 0) break;
                }
                int n = \u26032.get(0);
                PointerBuffer \u26034 = pointerBuffer.getPointerBuffer(n);
                if (n == 1) {
                    this.func_216457_a(\u26034.getFloatBuffer(0, \u2603), buffer);
                    boolean bl = true;
                    return bl;
                }
                if (n == 2) {
                    this.func_216458_a(\u26034.getFloatBuffer(0, \u2603), \u26034.getFloatBuffer(1, \u2603), buffer);
                    boolean bl = true;
                    return bl;
                }
                throw new IllegalStateException("Invalid number of channels: " + n);
            }
            boolean bl = false;
            return bl;
        }
    }

    private void func_216457_a(FloatBuffer floatBuffer, Buffer buffer) {
        while (floatBuffer.hasRemaining()) {
            buffer.func_216446_a(floatBuffer.get());
        }
    }

    private void func_216458_a(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, Buffer buffer) {
        while (floatBuffer.hasRemaining() && floatBuffer2.hasRemaining()) {
            buffer.func_216446_a(floatBuffer.get());
            buffer.func_216446_a(floatBuffer2.get());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.field_216461_a != 0L) {
            STBVorbis.stb_vorbis_close((long)this.field_216461_a);
            this.field_216461_a = 0L;
        }
        MemoryUtil.memFree((java.nio.Buffer)this.field_216464_d);
        this.field_216463_c.close();
    }

    @Override
    public AudioFormat func_216454_a() {
        return this.field_216462_b;
    }

    @Override
    public ByteBuffer func_216455_a(int n) throws IOException {
        Buffer buffer = new Buffer(n + 8192);
        while (this.func_216460_a(buffer) && buffer.field_216451_c < n) {
        }
        return buffer.func_216445_a();
    }

    public ByteBuffer func_216453_b() throws IOException {
        Buffer buffer = new Buffer(16384);
        while (this.func_216460_a(buffer)) {
        }
        return buffer.func_216445_a();
    }

    static class Buffer {
        private final List<ByteBuffer> field_216449_a = Lists.newArrayList();
        private final int field_216450_b;
        private int field_216451_c;
        private ByteBuffer field_216452_d;

        public Buffer(int n) {
            this.field_216450_b = n + 1 & 0xFFFFFFFE;
            this.func_216447_b();
        }

        private void func_216447_b() {
            this.field_216452_d = BufferUtils.createByteBuffer((int)this.field_216450_b);
        }

        public void func_216446_a(float f) {
            if (this.field_216452_d.remaining() == 0) {
                this.field_216452_d.flip();
                this.field_216449_a.add(this.field_216452_d);
                this.func_216447_b();
            }
            int n = MathHelper.func_76125_a((int)(f * 32767.5f - 0.5f), Short.MIN_VALUE, Short.MAX_VALUE);
            this.field_216452_d.putShort((short)n);
            this.field_216451_c += 2;
        }

        public ByteBuffer func_216445_a() {
            this.field_216452_d.flip();
            if (this.field_216449_a.isEmpty()) {
                return this.field_216452_d;
            }
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)this.field_216451_c);
            this.field_216449_a.forEach(byteBuffer::put);
            byteBuffer.put(this.field_216452_d);
            byteBuffer.flip();
            return byteBuffer;
        }
    }
}

