/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.chat;

import com.mojang.text2speech.Narrator;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.IChatListener;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.settings.NarratorStatus;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NarratorChatListener
implements IChatListener {
    public static final ITextComponent field_216868_a = StringTextComponent.field_240750_d_;
    private static final Logger field_216869_c = LogManager.getLogger();
    public static final NarratorChatListener field_193643_a = new NarratorChatListener();
    private final Narrator field_192580_a = Narrator.getNarrator();

    @Override
    public void func_192576_a(ChatType chatType, ITextComponent iTextComponent, UUID uUID) {
        NarratorStatus narratorStatus = NarratorChatListener.func_223131_d();
        if (narratorStatus == NarratorStatus.OFF || !this.field_192580_a.active()) {
            return;
        }
        if (narratorStatus == NarratorStatus.ALL || narratorStatus == NarratorStatus.CHAT && chatType == ChatType.CHAT || narratorStatus == NarratorStatus.SYSTEM && chatType == ChatType.SYSTEM) {
            ITextComponent iTextComponent2 = iTextComponent instanceof TranslationTextComponent && "chat.type.text".equals(((TranslationTextComponent)iTextComponent).func_150268_i()) ? new TranslationTextComponent("chat.type.text.narrate", ((TranslationTextComponent)iTextComponent).func_150271_j()) : iTextComponent;
            this.func_216866_a(chatType.func_218690_b(), iTextComponent2.getString());
        }
    }

    public void func_216864_a(String string) {
        NarratorStatus narratorStatus = NarratorChatListener.func_223131_d();
        if (this.field_192580_a.active() && narratorStatus != NarratorStatus.OFF && narratorStatus != NarratorStatus.CHAT && !string.isEmpty()) {
            this.field_192580_a.clear();
            this.func_216866_a(true, string);
        }
    }

    private static NarratorStatus func_223131_d() {
        return Minecraft.func_71410_x().field_71474_y.field_192571_R;
    }

    private void func_216866_a(boolean bl, String string) {
        if (SharedConstants.field_206244_b) {
            field_216869_c.debug("Narrating: {}", (Object)string.replaceAll("\n", "\\\\n"));
        }
        this.field_192580_a.say(string, bl);
    }

    public void func_216865_a(NarratorStatus narratorStatus) {
        this.func_193642_b();
        this.field_192580_a.say(new TranslationTextComponent("options.narrator").func_240702_b_(" : ").func_230529_a_(narratorStatus.func_238233_b_()).getString(), true);
        ToastGui toastGui = Minecraft.func_71410_x().func_193033_an();
        if (this.field_192580_a.active()) {
            if (narratorStatus == NarratorStatus.OFF) {
                SystemToast.func_193657_a(toastGui, SystemToast.Type.NARRATOR_TOGGLE, new TranslationTextComponent("narrator.toast.disabled"), null);
            } else {
                SystemToast.func_193657_a(toastGui, SystemToast.Type.NARRATOR_TOGGLE, new TranslationTextComponent("narrator.toast.enabled"), narratorStatus.func_238233_b_());
            }
        } else {
            SystemToast.func_193657_a(toastGui, SystemToast.Type.NARRATOR_TOGGLE, new TranslationTextComponent("narrator.toast.disabled"), new TranslationTextComponent("options.narrator.notavailable"));
        }
    }

    public boolean func_193640_a() {
        return this.field_192580_a.active();
    }

    public void func_193642_b() {
        if (NarratorChatListener.func_223131_d() == NarratorStatus.OFF || !this.field_192580_a.active()) {
            return;
        }
        this.field_192580_a.clear();
    }

    public void func_216867_c() {
        this.field_192580_a.destroy();
    }
}

