/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.CreateBuffetWorldScreen;
import net.minecraft.client.gui.screen.CreateFlatWorldScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;

public abstract class BiomeGeneratorTypeScreens {
    public static final BiomeGeneratorTypeScreens field_239066_a_ = new BiomeGeneratorTypeScreens("default"){

        @Override
        protected ChunkGenerator func_241869_a(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
            return new NoiseChunkGenerator(new OverworldBiomeProvider(l, false, false, registry), l, () -> registry2.func_243576_d(DimensionSettings.field_242734_c));
        }
    };
    private static final BiomeGeneratorTypeScreens field_239070_e_ = new BiomeGeneratorTypeScreens("flat"){

        @Override
        protected ChunkGenerator func_241869_a(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
            return new FlatChunkGenerator(FlatGenerationSettings.func_242869_a(registry));
        }
    };
    private static final BiomeGeneratorTypeScreens field_239071_f_ = new BiomeGeneratorTypeScreens("large_biomes"){

        @Override
        protected ChunkGenerator func_241869_a(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
            return new NoiseChunkGenerator(new OverworldBiomeProvider(l, false, true, registry), l, () -> registry2.func_243576_d(DimensionSettings.field_242734_c));
        }
    };
    public static final BiomeGeneratorTypeScreens field_239067_b_ = new BiomeGeneratorTypeScreens("amplified"){

        @Override
        protected ChunkGenerator func_241869_a(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
            return new NoiseChunkGenerator(new OverworldBiomeProvider(l, false, false, registry), l, () -> registry2.func_243576_d(DimensionSettings.field_242735_d));
        }
    };
    private static final BiomeGeneratorTypeScreens field_239072_g_ = new BiomeGeneratorTypeScreens("single_biome_surface"){

        @Override
        protected ChunkGenerator func_241869_a(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
            return new NoiseChunkGenerator(new SingleBiomeProvider(registry.func_243576_d(Biomes.field_76772_c)), l, () -> registry2.func_243576_d(DimensionSettings.field_242734_c));
        }
    };
    private static final BiomeGeneratorTypeScreens field_239073_h_ = new BiomeGeneratorTypeScreens("single_biome_caves"){

        @Override
        public DimensionGeneratorSettings func_241220_a_(DynamicRegistries.Impl impl, long l, boolean bl, boolean bl2) {
            MutableRegistry<Biome> mutableRegistry = impl.func_243612_b(Registry.field_239720_u_);
            MutableRegistry<DimensionType> \u26032 = impl.func_243612_b(Registry.field_239698_ad_);
            MutableRegistry<DimensionSettings> \u26033 = impl.func_243612_b(Registry.field_243549_ar);
            return new DimensionGeneratorSettings(l, bl, bl2, DimensionGeneratorSettings.func_241520_a_(DimensionType.func_242718_a(\u26032, mutableRegistry, \u26033, l), () -> \u26032.func_243576_d(DimensionType.field_241497_i_), this.func_241869_a(mutableRegistry, \u26033, l)));
        }

        @Override
        protected ChunkGenerator func_241869_a(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
            return new NoiseChunkGenerator(new SingleBiomeProvider(registry.func_243576_d(Biomes.field_76772_c)), l, () -> registry2.func_243576_d(DimensionSettings.field_242738_g));
        }
    };
    private static final BiomeGeneratorTypeScreens field_239074_i_ = new BiomeGeneratorTypeScreens("single_biome_floating_islands"){

        @Override
        protected ChunkGenerator func_241869_a(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
            return new NoiseChunkGenerator(new SingleBiomeProvider(registry.func_243576_d(Biomes.field_76772_c)), l, () -> registry2.func_243576_d(DimensionSettings.field_242739_h));
        }
    };
    private static final BiomeGeneratorTypeScreens field_239075_j_ = new BiomeGeneratorTypeScreens("debug_all_block_states"){

        @Override
        protected ChunkGenerator func_241869_a(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
            return new DebugChunkGenerator(registry);
        }
    };
    protected static final List<BiomeGeneratorTypeScreens> field_239068_c_ = Lists.newArrayList((Object[])new BiomeGeneratorTypeScreens[]{field_239066_a_, field_239070_e_, field_239071_f_, field_239067_b_, field_239072_g_, field_239073_h_, field_239074_i_, field_239075_j_});
    protected static final Map<Optional<BiomeGeneratorTypeScreens>, IFactory> field_239069_d_ = ImmutableMap.of(Optional.of(field_239070_e_), (createWorldScreen, dimensionGeneratorSettings) -> {
        ChunkGenerator chunkGenerator = dimensionGeneratorSettings.func_236225_f_();
        return new CreateFlatWorldScreen(createWorldScreen, flatGenerationSettings -> createWorldScreen.field_238934_c_.func_239043_a_(new DimensionGeneratorSettings(dimensionGeneratorSettings.func_236221_b_(), dimensionGeneratorSettings.func_236222_c_(), dimensionGeneratorSettings.func_236223_d_(), DimensionGeneratorSettings.func_242749_a(createWorldScreen.field_238934_c_.func_239055_b_().func_243612_b(Registry.field_239698_ad_), dimensionGeneratorSettings.func_236224_e_(), new FlatChunkGenerator((FlatGenerationSettings)flatGenerationSettings)))), chunkGenerator instanceof FlatChunkGenerator ? ((FlatChunkGenerator)chunkGenerator).func_236073_g_() : FlatGenerationSettings.func_242869_a(createWorldScreen.field_238934_c_.func_239055_b_().func_243612_b(Registry.field_239720_u_)));
    }, Optional.of(field_239072_g_), (createWorldScreen, dimensionGeneratorSettings) -> new CreateBuffetWorldScreen(createWorldScreen, createWorldScreen.field_238934_c_.func_239055_b_(), biome -> createWorldScreen.field_238934_c_.func_239043_a_(BiomeGeneratorTypeScreens.func_243452_a(createWorldScreen.field_238934_c_.func_239055_b_(), dimensionGeneratorSettings, field_239072_g_, biome)), BiomeGeneratorTypeScreens.func_243451_a(createWorldScreen.field_238934_c_.func_239055_b_(), dimensionGeneratorSettings)), Optional.of(field_239073_h_), (createWorldScreen, dimensionGeneratorSettings) -> new CreateBuffetWorldScreen(createWorldScreen, createWorldScreen.field_238934_c_.func_239055_b_(), biome -> createWorldScreen.field_238934_c_.func_239043_a_(BiomeGeneratorTypeScreens.func_243452_a(createWorldScreen.field_238934_c_.func_239055_b_(), dimensionGeneratorSettings, field_239073_h_, biome)), BiomeGeneratorTypeScreens.func_243451_a(createWorldScreen.field_238934_c_.func_239055_b_(), dimensionGeneratorSettings)), Optional.of(field_239074_i_), (createWorldScreen, dimensionGeneratorSettings) -> new CreateBuffetWorldScreen(createWorldScreen, createWorldScreen.field_238934_c_.func_239055_b_(), biome -> createWorldScreen.field_238934_c_.func_239043_a_(BiomeGeneratorTypeScreens.func_243452_a(createWorldScreen.field_238934_c_.func_239055_b_(), dimensionGeneratorSettings, field_239074_i_, biome)), BiomeGeneratorTypeScreens.func_243451_a(createWorldScreen.field_238934_c_.func_239055_b_(), dimensionGeneratorSettings)));
    private final ITextComponent field_239076_k_;

    private BiomeGeneratorTypeScreens(String string) {
        this.field_239076_k_ = new TranslationTextComponent("generator." + string);
    }

    private static DimensionGeneratorSettings func_243452_a(DynamicRegistries dynamicRegistries, DimensionGeneratorSettings dimensionGeneratorSettings, BiomeGeneratorTypeScreens biomeGeneratorTypeScreens, Biome biome) {
        SingleBiomeProvider singleBiomeProvider = new SingleBiomeProvider(biome);
        MutableRegistry<DimensionType> \u26032 = dynamicRegistries.func_243612_b(Registry.field_239698_ad_);
        MutableRegistry<DimensionSettings> \u26033 = dynamicRegistries.func_243612_b(Registry.field_243549_ar);
        Supplier<DimensionSettings> \u26034 = biomeGeneratorTypeScreens == field_239073_h_ ? () -> \u26033.func_243576_d(DimensionSettings.field_242738_g) : (biomeGeneratorTypeScreens == field_239074_i_ ? () -> \u26033.func_243576_d(DimensionSettings.field_242739_h) : () -> \u26033.func_243576_d(DimensionSettings.field_242734_c));
        return new DimensionGeneratorSettings(dimensionGeneratorSettings.func_236221_b_(), dimensionGeneratorSettings.func_236222_c_(), dimensionGeneratorSettings.func_236223_d_(), DimensionGeneratorSettings.func_242749_a(\u26032, dimensionGeneratorSettings.func_236224_e_(), new NoiseChunkGenerator(singleBiomeProvider, dimensionGeneratorSettings.func_236221_b_(), \u26034)));
    }

    private static Biome func_243451_a(DynamicRegistries dynamicRegistries, DimensionGeneratorSettings dimensionGeneratorSettings) {
        return dimensionGeneratorSettings.func_236225_f_().func_202090_b().func_235203_c_().stream().findFirst().orElse(dynamicRegistries.func_243612_b(Registry.field_239720_u_).func_243576_d(Biomes.field_76772_c));
    }

    public static Optional<BiomeGeneratorTypeScreens> func_239079_a_(DimensionGeneratorSettings dimensionGeneratorSettings) {
        ChunkGenerator chunkGenerator = dimensionGeneratorSettings.func_236225_f_();
        if (chunkGenerator instanceof FlatChunkGenerator) {
            return Optional.of(field_239070_e_);
        }
        if (chunkGenerator instanceof DebugChunkGenerator) {
            return Optional.of(field_239075_j_);
        }
        return Optional.empty();
    }

    public ITextComponent func_239077_a_() {
        return this.field_239076_k_;
    }

    public DimensionGeneratorSettings func_241220_a_(DynamicRegistries.Impl impl, long l, boolean bl, boolean bl2) {
        MutableRegistry<Biome> mutableRegistry = impl.func_243612_b(Registry.field_239720_u_);
        MutableRegistry<DimensionType> \u26032 = impl.func_243612_b(Registry.field_239698_ad_);
        MutableRegistry<DimensionSettings> \u26033 = impl.func_243612_b(Registry.field_243549_ar);
        return new DimensionGeneratorSettings(l, bl, bl2, DimensionGeneratorSettings.func_242749_a(\u26032, DimensionType.func_242718_a(\u26032, mutableRegistry, \u26033, l), this.func_241869_a(mutableRegistry, \u26033, l)));
    }

    protected abstract ChunkGenerator func_241869_a(Registry<Biome> var1, Registry<DimensionSettings> var2, long var3);

    public static interface IFactory {
        public Screen createEditScreen(CreateWorldScreen var1, DimensionGeneratorSettings var2);
    }
}

