/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.DisconnectedScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.login.ClientLoginNetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectingScreen
extends Screen {
    private static final AtomicInteger field_146372_a = new AtomicInteger(0);
    private static final Logger field_146370_f = LogManager.getLogger();
    private NetworkManager field_146371_g;
    private boolean field_146373_h;
    private final Screen field_146374_i;
    private ITextComponent field_209515_s = new TranslationTextComponent("connect.connecting");
    private long field_213000_g = -1L;

    public ConnectingScreen(Screen screen, Minecraft minecraft, ServerData serverData) {
        super(NarratorChatListener.field_216868_a);
        this.field_230706_i_ = minecraft;
        this.field_146374_i = screen;
        ServerAddress serverAddress = ServerAddress.func_78860_a(serverData.field_78845_b);
        minecraft.func_213254_o();
        minecraft.func_71351_a(serverData);
        this.func_146367_a(serverAddress.func_78861_a(), serverAddress.func_78864_b());
    }

    public ConnectingScreen(Screen screen, Minecraft minecraft, String string, int n) {
        super(NarratorChatListener.field_216868_a);
        this.field_230706_i_ = minecraft;
        this.field_146374_i = screen;
        minecraft.func_213254_o();
        this.func_146367_a(string, n);
    }

    private void func_146367_a(final String string, final int n) {
        field_146370_f.info("Connecting to {}, {}", (Object)string, (Object)n);
        Thread thread = new Thread("Server Connector #" + field_146372_a.incrementAndGet()){

            @Override
            public void run() {
                InetAddress inetAddress = null;
                try {
                    if (ConnectingScreen.this.field_146373_h) {
                        return;
                    }
                    inetAddress = InetAddress.getByName(string);
                    ConnectingScreen.this.field_146371_g = NetworkManager.func_181124_a(inetAddress, n, ConnectingScreen.this.field_230706_i_.field_71474_y.func_181148_f());
                    ConnectingScreen.this.field_146371_g.func_150719_a(new ClientLoginNetHandler(ConnectingScreen.this.field_146371_g, ConnectingScreen.this.field_230706_i_, ConnectingScreen.this.field_146374_i, iTextComponent -> ConnectingScreen.this.func_209514_a(iTextComponent)));
                    ConnectingScreen.this.field_146371_g.func_179290_a(new CHandshakePacket(string, n, ProtocolType.LOGIN));
                    ConnectingScreen.this.field_146371_g.func_179290_a(new CLoginStartPacket(ConnectingScreen.this.field_230706_i_.func_110432_I().func_148256_e()));
                }
                catch (UnknownHostException \u26032) {
                    if (ConnectingScreen.this.field_146373_h) {
                        return;
                    }
                    field_146370_f.error("Couldn't connect to server", (Throwable)\u26032);
                    ConnectingScreen.this.field_230706_i_.execute(() -> ConnectingScreen.this.field_230706_i_.func_147108_a(new DisconnectedScreen(ConnectingScreen.this.field_146374_i, DialogTexts.field_244280_i, new TranslationTextComponent("disconnect.genericReason", "Unknown host"))));
                }
                catch (Exception \u26033) {
                    if (ConnectingScreen.this.field_146373_h) {
                        return;
                    }
                    field_146370_f.error("Couldn't connect to server", (Throwable)\u26033);
                    String string2 = inetAddress == null ? \u26033.toString() : \u26033.toString().replaceAll(inetAddress + ":" + n, "");
                    ConnectingScreen.this.field_230706_i_.execute(() -> ConnectingScreen.this.field_230706_i_.func_147108_a(new DisconnectedScreen(ConnectingScreen.this.field_146374_i, DialogTexts.field_244280_i, new TranslationTextComponent("disconnect.genericReason", string2))));
                }
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_146370_f));
        thread.start();
    }

    private void func_209514_a(ITextComponent iTextComponent) {
        this.field_209515_s = iTextComponent;
    }

    @Override
    public void func_231023_e_() {
        if (this.field_146371_g != null) {
            if (this.field_146371_g.func_150724_d()) {
                this.field_146371_g.func_74428_b();
            } else {
                this.field_146371_g.func_179293_l();
            }
        }
    }

    @Override
    public boolean func_231178_ax__() {
        return false;
    }

    @Override
    protected void func_231160_c_() {
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 120 + 12, 200, 20, DialogTexts.field_240633_d_, button -> {
            this.field_146373_h = true;
            if (this.field_146371_g != null) {
                this.field_146371_g.func_150718_a(new TranslationTextComponent("connect.aborted"));
            }
            this.field_230706_i_.func_147108_a(this.field_146374_i);
        }));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        this.func_230446_a_(matrixStack);
        long l = Util.func_211177_b();
        if (l - this.field_213000_g > 2000L) {
            this.field_213000_g = l;
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.joining").getString());
        }
        ConnectingScreen.func_238472_a_(matrixStack, this.field_230712_o_, this.field_209515_s, this.field_230708_k_ / 2, this.field_230709_l_ / 2 - 50, 0xFFFFFF);
        super.func_230430_a_(matrixStack, n, n2, f);
    }
}

