/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.OverlayRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.GameType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameRenderer
implements IResourceManagerReloadListener,
AutoCloseable {
    private static final ResourceLocation field_243496_c = new ResourceLocation("textures/misc/nausea.png");
    private static final Logger field_147710_q = LogManager.getLogger();
    private final Minecraft field_78531_r;
    private final IResourceManager field_147711_ac;
    private final Random field_78537_ab = new Random();
    private float field_78530_s;
    public final FirstPersonRenderer field_78516_c;
    private final MapItemRenderer field_147709_v;
    private final RenderTypeBuffers field_228374_i_;
    private int field_78529_t;
    private float field_78507_R;
    private float field_78506_S;
    private float field_82831_U;
    private float field_82832_V;
    private boolean field_175074_C = true;
    private boolean field_175073_D = true;
    private long field_184374_E;
    private long field_78508_Y = Util.func_211177_b();
    private final LightTexture field_78513_d;
    private final OverlayTexture field_228375_t_ = new OverlayTexture();
    private boolean field_175078_W;
    private float field_78503_V = 1.0f;
    private float field_228376_w_;
    private float field_228377_x_;
    @Nullable
    private ItemStack field_190566_ab;
    private int field_190567_ac;
    private float field_190568_ad;
    private float field_190569_ae;
    @Nullable
    private ShaderGroup field_147707_d;
    private static final ResourceLocation[] field_147712_ad = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("shaders/post/spider.json")};
    public static final int field_147708_e = field_147712_ad.length;
    private int field_147713_ae = field_147708_e;
    private boolean field_175083_ad;
    private final ActiveRenderInfo field_215317_L = new ActiveRenderInfo();

    public GameRenderer(Minecraft minecraft, IResourceManager iResourceManager, RenderTypeBuffers renderTypeBuffers) {
        this.field_78531_r = minecraft;
        this.field_147711_ac = iResourceManager;
        this.field_78516_c = minecraft.func_175597_ag();
        this.field_147709_v = new MapItemRenderer(minecraft.func_110434_K());
        this.field_78513_d = new LightTexture(this, minecraft);
        this.field_228374_i_ = renderTypeBuffers;
        this.field_147707_d = null;
    }

    @Override
    public void close() {
        this.field_78513_d.close();
        this.field_147709_v.close();
        this.field_228375_t_.close();
        this.func_181022_b();
    }

    public void func_181022_b() {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        this.field_147713_ae = field_147708_e;
    }

    public void func_175071_c() {
        this.field_175083_ad = !this.field_175083_ad;
    }

    public void func_175066_a(@Nullable Entity entity) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (entity instanceof CreeperEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/creeper.json"));
        } else if (entity instanceof SpiderEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/spider.json"));
        } else if (entity instanceof EndermanEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/invert.json"));
        }
    }

    private void func_175069_a(ResourceLocation resourceLocation) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        try {
            this.field_147707_d = new ShaderGroup(this.field_78531_r.func_110434_K(), this.field_147711_ac, this.field_78531_r.func_147110_a(), resourceLocation);
            this.field_147707_d.func_148026_a(this.field_78531_r.func_228018_at_().func_198109_k(), this.field_78531_r.func_228018_at_().func_198091_l());
            this.field_175083_ad = true;
        }
        catch (IOException iOException) {
            field_147710_q.warn("Failed to load shader: {}", (Object)resourceLocation, (Object)iOException);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            field_147710_q.warn("Failed to parse shader: {}", (Object)resourceLocation, (Object)jsonSyntaxException);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (this.field_147713_ae == field_147708_e) {
            this.func_175066_a(this.field_78531_r.func_175606_aa());
        } else {
            this.func_175069_a(field_147712_ad[this.field_147713_ae]);
        }
    }

    public void func_78464_a() {
        this.func_78477_e();
        this.field_78513_d.func_205107_a();
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a(this.field_78531_r.field_71439_g);
        }
        this.field_215317_L.func_216783_a();
        ++this.field_78529_t;
        this.field_78516_c.func_78441_a();
        this.field_78531_r.field_71438_f.func_228436_a_(this.field_215317_L);
        this.field_82832_V = this.field_82831_U;
        if (this.field_78531_r.field_71456_v.func_184046_j().func_184053_e()) {
            this.field_82831_U += 0.05f;
            if (this.field_82831_U > 1.0f) {
                this.field_82831_U = 1.0f;
            }
        } else if (this.field_82831_U > 0.0f) {
            this.field_82831_U -= 0.0125f;
        }
        if (this.field_190567_ac > 0) {
            --this.field_190567_ac;
            if (this.field_190567_ac == 0) {
                this.field_190566_ab = null;
            }
        }
    }

    @Nullable
    public ShaderGroup func_147706_e() {
        return this.field_147707_d;
    }

    public void func_147704_a(int n, int n2) {
        if (this.field_147707_d != null) {
            this.field_147707_d.func_148026_a(n, n2);
        }
        this.field_78531_r.field_71438_f.func_72720_a(n, n2);
    }

    public void func_78473_a(float f) {
        Entity entity2 = this.field_78531_r.func_175606_aa();
        if (entity2 == null) {
            return;
        }
        if (this.field_78531_r.field_71441_e == null) {
            return;
        }
        this.field_78531_r.func_213239_aq().func_76320_a("pick");
        this.field_78531_r.field_147125_j = null;
        double \u26032 = this.field_78531_r.field_71442_b.func_78757_d();
        this.field_78531_r.field_71476_x = entity2.func_213324_a(\u26032, f, false);
        Vector3d \u26033 = entity2.func_174824_e(f);
        boolean \u26034 = false;
        int \u26035 = 3;
        double \u26036 = \u26032;
        if (this.field_78531_r.field_71442_b.func_78749_i()) {
            \u26032 = \u26036 = 6.0;
        } else {
            if (\u26036 > 3.0) {
                \u26034 = true;
            }
            \u26032 = \u26036;
        }
        \u26036 *= \u26036;
        if (this.field_78531_r.field_71476_x != null) {
            \u26036 = this.field_78531_r.field_71476_x.func_216347_e().func_72436_e(\u26033);
        }
        Vector3d \u26037 = entity2.func_70676_i(1.0f);
        Vector3d \u26038 = \u26033.func_72441_c(\u26037.field_72450_a * \u26032, \u26037.field_72448_b * \u26032, \u26037.field_72449_c * \u26032);
        float \u26039 = 1.0f;
        AxisAlignedBB \u260310 = entity2.func_174813_aQ().func_216361_a(\u26037.func_186678_a(\u26032)).func_72314_b(1.0, 1.0, 1.0);
        EntityRayTraceResult \u260311 = ProjectileHelper.func_221273_a(entity2, \u26033, \u26038, \u260310, entity -> !entity.func_175149_v() && entity.func_70067_L(), \u26036);
        if (\u260311 != null) {
            \u2603 = \u260311.func_216348_a();
            Vector3d vector3d = \u260311.func_216347_e();
            double \u260312 = \u26033.func_72436_e(vector3d);
            if (\u26034 && \u260312 > 9.0) {
                this.field_78531_r.field_71476_x = BlockRayTraceResult.func_216352_a(vector3d, Direction.func_210769_a(\u26037.field_72450_a, \u26037.field_72448_b, \u26037.field_72449_c), new BlockPos(vector3d));
            } else if (\u260312 < \u26036 || this.field_78531_r.field_71476_x == null) {
                this.field_78531_r.field_71476_x = \u260311;
                if (\u2603 instanceof LivingEntity || \u2603 instanceof ItemFrameEntity) {
                    this.field_78531_r.field_147125_j = \u2603;
                }
            }
        }
        this.field_78531_r.func_213239_aq().func_76319_b();
    }

    private void func_78477_e() {
        float \u26032 = 1.0f;
        if (this.field_78531_r.func_175606_aa() instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity abstractClientPlayerEntity = (AbstractClientPlayerEntity)this.field_78531_r.func_175606_aa();
            \u26032 = abstractClientPlayerEntity.func_175156_o();
        }
        this.field_78506_S = this.field_78507_R;
        this.field_78507_R += (\u26032 - this.field_78507_R) * 0.5f;
        if (this.field_78507_R > 1.5f) {
            this.field_78507_R = 1.5f;
        }
        if (this.field_78507_R < 0.1f) {
            this.field_78507_R = 0.1f;
        }
    }

    private double func_215311_a(ActiveRenderInfo activeRenderInfo, float f, boolean bl) {
        FluidState fluidState;
        if (this.field_175078_W) {
            return 90.0;
        }
        double d = 70.0;
        if (bl) {
            d = this.field_78531_r.field_71474_y.field_74334_X;
            d *= (double)MathHelper.func_219799_g(f, this.field_78506_S, this.field_78507_R);
        }
        if (activeRenderInfo.func_216773_g() instanceof LivingEntity && ((LivingEntity)activeRenderInfo.func_216773_g()).func_233643_dh_()) {
            float f2 = Math.min((float)((LivingEntity)activeRenderInfo.func_216773_g()).field_70725_aQ + f, 20.0f);
            d /= (double)((1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f);
        }
        if (!(fluidState = activeRenderInfo.func_216771_k()).func_206888_e()) {
            d = d * 60.0 / 70.0;
        }
        return d;
    }

    private void func_228380_a_(MatrixStack matrixStack, float f) {
        if (this.field_78531_r.func_175606_aa() instanceof LivingEntity) {
            float \u26033;
            LivingEntity livingEntity = (LivingEntity)this.field_78531_r.func_175606_aa();
            float \u26032 = (float)livingEntity.field_70737_aN - f;
            if (livingEntity.func_233643_dh_()) {
                \u26033 = Math.min((float)livingEntity.field_70725_aQ + f, 20.0f);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(40.0f - 8000.0f / (\u26033 + 200.0f)));
            }
            if (\u26032 < 0.0f) {
                return;
            }
            \u26032 /= (float)livingEntity.field_70738_aO;
            \u26032 = MathHelper.func_76126_a(\u26032 * \u26032 * \u26032 * \u26032 * (float)Math.PI);
            \u26033 = livingEntity.field_70739_aP;
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-\u26033));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-\u26032 * 14.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(\u26033));
        }
    }

    private void func_228383_b_(MatrixStack matrixStack, float f) {
        if (!(this.field_78531_r.func_175606_aa() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerEntity = (PlayerEntity)this.field_78531_r.func_175606_aa();
        float \u26032 = playerEntity.field_70140_Q - playerEntity.field_70141_P;
        float \u26033 = -(playerEntity.field_70140_Q + \u26032 * f);
        float \u26034 = MathHelper.func_219799_g(f, playerEntity.field_71107_bF, playerEntity.field_71109_bG);
        matrixStack.func_227861_a_(MathHelper.func_76126_a(\u26033 * (float)Math.PI) * \u26034 * 0.5f, -Math.abs(MathHelper.func_76134_b(\u26033 * (float)Math.PI) * \u26034), 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a(\u26033 * (float)Math.PI) * \u26034 * 3.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(Math.abs(MathHelper.func_76134_b(\u26033 * (float)Math.PI - 0.2f) * \u26034) * 5.0f));
    }

    private void func_228381_a_(MatrixStack matrixStack, ActiveRenderInfo activeRenderInfo, float f) {
        if (this.field_175078_W) {
            return;
        }
        this.func_228379_a_(this.func_228382_a_(activeRenderInfo, f, false));
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        entry.func_227870_a_().func_226591_a_();
        entry.func_227872_b_().func_226119_c_();
        matrixStack.func_227860_a_();
        this.func_228380_a_(matrixStack, f);
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_228383_b_(matrixStack, f);
        }
        boolean bl = \u2603 = this.field_78531_r.func_175606_aa() instanceof LivingEntity && ((LivingEntity)this.field_78531_r.func_175606_aa()).func_70608_bn();
        if (this.field_78531_r.field_71474_y.func_243230_g().func_243192_a() && !\u2603 && !this.field_78531_r.field_71474_y.field_74319_N && this.field_78531_r.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
            this.field_78513_d.func_205109_c();
            this.field_78516_c.func_228396_a_(f, matrixStack, this.field_228374_i_.func_228487_b_(), this.field_78531_r.field_71439_g, this.field_78531_r.func_175598_ae().func_229085_a_(this.field_78531_r.field_71439_g, f));
            this.field_78513_d.func_205108_b();
        }
        matrixStack.func_227865_b_();
        if (this.field_78531_r.field_71474_y.func_243230_g().func_243192_a() && !\u2603) {
            OverlayRenderer.func_228734_a_(this.field_78531_r, matrixStack);
            this.func_228380_a_(matrixStack, f);
        }
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_228383_b_(matrixStack, f);
        }
    }

    public void func_228379_a_(Matrix4f matrix4f) {
        RenderSystem.matrixMode(5889);
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix(matrix4f);
        RenderSystem.matrixMode(5888);
    }

    public Matrix4f func_228382_a_(ActiveRenderInfo activeRenderInfo, float f, boolean bl) {
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227866_c_().func_227870_a_().func_226591_a_();
        if (this.field_78503_V != 1.0f) {
            matrixStack.func_227861_a_(this.field_228376_w_, -this.field_228377_x_, 0.0);
            matrixStack.func_227862_a_(this.field_78503_V, this.field_78503_V, 1.0f);
        }
        matrixStack.func_227866_c_().func_227870_a_().func_226595_a_(Matrix4f.func_195876_a(this.func_215311_a(activeRenderInfo, f, bl), (float)this.field_78531_r.func_228018_at_().func_198109_k() / (float)this.field_78531_r.func_228018_at_().func_198091_l(), 0.05f, this.field_78530_s * 4.0f));
        return matrixStack.func_227866_c_().func_227870_a_();
    }

    public static float func_180438_a(LivingEntity livingEntity, float f) {
        int n = livingEntity.func_70660_b(Effects.field_76439_r).func_76459_b();
        if (n > 200) {
            return 1.0f;
        }
        return 0.7f + MathHelper.func_76126_a(((float)n - f) * (float)Math.PI * 0.2f) * 0.3f;
    }

    public void func_195458_a(float f, long l, boolean bl) {
        if (this.field_78531_r.func_195544_aj() || !this.field_78531_r.field_71474_y.field_82881_y || this.field_78531_r.field_71474_y.field_85185_A && this.field_78531_r.field_71417_B.func_198031_d()) {
            this.field_78508_Y = Util.func_211177_b();
        } else if (Util.func_211177_b() - this.field_78508_Y > 500L) {
            this.field_78531_r.func_71385_j(false);
        }
        if (this.field_78531_r.field_71454_w) {
            return;
        }
        int n = (int)(this.field_78531_r.field_71417_B.func_198024_e() * (double)this.field_78531_r.func_228018_at_().func_198107_o() / (double)this.field_78531_r.func_228018_at_().func_198105_m());
        \u2603 = (int)(this.field_78531_r.field_71417_B.func_198026_f() * (double)this.field_78531_r.func_228018_at_().func_198087_p() / (double)this.field_78531_r.func_228018_at_().func_198083_n());
        RenderSystem.viewport(0, 0, this.field_78531_r.func_228018_at_().func_198109_k(), this.field_78531_r.func_228018_at_().func_198091_l());
        if (bl && this.field_78531_r.field_71441_e != null) {
            this.field_78531_r.func_213239_aq().func_76320_a("level");
            this.func_228378_a_(f, l, new MatrixStack());
            if (this.field_78531_r.func_71356_B() && this.field_184374_E < Util.func_211177_b() - 1000L) {
                this.field_184374_E = Util.func_211177_b();
                if (!this.field_78531_r.func_71401_C().func_184106_y()) {
                    this.func_184373_n();
                }
            }
            this.field_78531_r.field_71438_f.func_174975_c();
            if (this.field_147707_d != null && this.field_175083_ad) {
                RenderSystem.disableBlend();
                RenderSystem.disableDepthTest();
                RenderSystem.disableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.matrixMode(5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                this.field_147707_d.func_148018_a(f);
                RenderSystem.popMatrix();
            }
            this.field_78531_r.func_147110_a().func_147610_a(true);
        }
        MainWindow \u26032 = this.field_78531_r.func_228018_at_();
        RenderSystem.clear(256, Minecraft.field_142025_a);
        RenderSystem.matrixMode(5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho(0.0, (double)\u26032.func_198109_k() / \u26032.func_198100_s(), (double)\u26032.func_198091_l() / \u26032.func_198100_s(), 0.0, 1000.0, 3000.0);
        RenderSystem.matrixMode(5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef(0.0f, 0.0f, -2000.0f);
        RenderHelper.func_227784_d_();
        MatrixStack \u26033 = new MatrixStack();
        if (bl && this.field_78531_r.field_71441_e != null) {
            this.field_78531_r.func_213239_aq().func_219895_b("gui");
            if (this.field_78531_r.field_71439_g != null && (\u2603 = MathHelper.func_219799_g(f, this.field_78531_r.field_71439_g.field_71080_cy, this.field_78531_r.field_71439_g.field_71086_bY)) > 0.0f && this.field_78531_r.field_71439_g.func_70644_a(Effects.field_76431_k) && this.field_78531_r.field_71474_y.field_243226_aM < 1.0f) {
                this.func_243497_c(\u2603 * (1.0f - this.field_78531_r.field_71474_y.field_243226_aM));
            }
            if (!this.field_78531_r.field_71474_y.field_74319_N || this.field_78531_r.field_71462_r != null) {
                RenderSystem.defaultAlphaFunc();
                this.func_190563_a(this.field_78531_r.func_228018_at_().func_198107_o(), this.field_78531_r.func_228018_at_().func_198087_p(), f);
                this.field_78531_r.field_71456_v.func_238445_a_(\u26033, f);
                RenderSystem.clear(256, Minecraft.field_142025_a);
            }
            this.field_78531_r.func_213239_aq().func_76319_b();
        }
        if (this.field_78531_r.field_213279_p != null) {
            try {
                this.field_78531_r.field_213279_p.func_230430_a_(\u26033, n, \u2603, this.field_78531_r.func_193989_ak());
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Rendering overlay");
                CrashReportCategory \u26034 = crashReport.func_85058_a("Overlay render details");
                \u26034.func_189529_a("Overlay name", () -> this.field_78531_r.field_213279_p.getClass().getCanonicalName());
                throw new ReportedException(crashReport);
            }
        }
        if (this.field_78531_r.field_71462_r != null) {
            try {
                this.field_78531_r.field_71462_r.func_230430_a_(\u26033, n, \u2603, this.field_78531_r.func_193989_ak());
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Rendering screen");
                CrashReportCategory \u26035 = crashReport.func_85058_a("Screen render details");
                \u26035.func_189529_a("Screen name", () -> this.field_78531_r.field_71462_r.getClass().getCanonicalName());
                \u26035.func_189529_a("Mouse location", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%f, %f)", n, \u2603, this.field_78531_r.field_71417_B.func_198024_e(), this.field_78531_r.field_71417_B.func_198026_f()));
                \u26035.func_189529_a("Screen size", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%d, %d). Scale factor of %f", this.field_78531_r.func_228018_at_().func_198107_o(), this.field_78531_r.func_228018_at_().func_198087_p(), this.field_78531_r.func_228018_at_().func_198109_k(), this.field_78531_r.func_228018_at_().func_198091_l(), this.field_78531_r.func_228018_at_().func_198100_s()));
                throw new ReportedException(crashReport);
            }
        }
    }

    private void func_184373_n() {
        if (this.field_78531_r.field_71438_f.func_184382_g() > 10 && this.field_78531_r.field_71438_f.func_184384_n() && !this.field_78531_r.func_71401_C().func_184106_y()) {
            NativeImage nativeImage = ScreenShotHelper.func_198052_a(this.field_78531_r.func_228018_at_().func_198109_k(), this.field_78531_r.func_228018_at_().func_198091_l(), this.field_78531_r.func_147110_a());
            Util.func_240992_g_().execute(() -> {
                int n = nativeImage.func_195702_a();
                \u2603 = nativeImage.func_195714_b();
                \u2603 = 0;
                \u2603 = 0;
                if (n > \u2603) {
                    \u2603 = (n - \u2603) / 2;
                    n = \u2603;
                } else {
                    \u2603 = (\u2603 - n) / 2;
                    \u2603 = n;
                }
                try (NativeImage nativeImage2 = new NativeImage(64, 64, false);){
                    nativeImage.func_195708_a(\u2603, \u2603, n, \u2603, nativeImage2);
                    nativeImage2.func_209271_a(this.field_78531_r.func_71401_C().func_184109_z());
                }
                catch (IOException iOException) {
                    field_147710_q.warn("Couldn't save auto screenshot", (Throwable)iOException);
                }
                finally {
                    nativeImage.close();
                }
            });
        }
    }

    private boolean func_175070_n() {
        boolean \u26035;
        if (!this.field_175073_D) {
            return false;
        }
        Entity entity = this.field_78531_r.func_175606_aa();
        boolean bl = \u26035 = entity instanceof PlayerEntity && !this.field_78531_r.field_71474_y.field_74319_N;
        if (\u26035 && !((PlayerEntity)entity).field_71075_bZ.field_75099_e) {
            ItemStack itemStack = ((LivingEntity)entity).func_184614_ca();
            RayTraceResult \u26032 = this.field_78531_r.field_71476_x;
            if (\u26032 != null && \u26032.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos blockPos = ((BlockRayTraceResult)\u26032).func_216350_a();
                BlockState \u26033 = this.field_78531_r.field_71441_e.func_180495_p(blockPos);
                if (this.field_78531_r.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
                    \u26035 = \u26033.func_215699_b(this.field_78531_r.field_71441_e, blockPos) != null;
                } else {
                    CachedBlockInfo \u26034 = new CachedBlockInfo(this.field_78531_r.field_71441_e, blockPos, false);
                    \u26035 = !itemStack.func_190926_b() && (itemStack.func_206848_a(this.field_78531_r.field_71441_e.func_205772_D(), \u26034) || itemStack.func_206847_b(this.field_78531_r.field_71441_e.func_205772_D(), \u26034));
                }
            }
        }
        return \u26035;
    }

    public void func_228378_a_(float f, long l, MatrixStack matrixStack) {
        this.field_78513_d.func_205106_a(f);
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a(this.field_78531_r.field_71439_g);
        }
        this.func_78473_a(f);
        this.field_78531_r.func_213239_aq().func_76320_a("center");
        boolean bl = this.func_175070_n();
        this.field_78531_r.func_213239_aq().func_219895_b("camera");
        ActiveRenderInfo \u26032 = this.field_215317_L;
        this.field_78530_s = this.field_78531_r.field_71474_y.field_151451_c * 16;
        MatrixStack \u26033 = new MatrixStack();
        \u26033.func_227866_c_().func_227870_a_().func_226595_a_(this.func_228382_a_(\u26032, f, true));
        this.func_228380_a_(\u26033, f);
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_228383_b_(\u26033, f);
        }
        if ((\u2603 = MathHelper.func_219799_g(f, this.field_78531_r.field_71439_g.field_71080_cy, this.field_78531_r.field_71439_g.field_71086_bY) * (this.field_78531_r.field_71474_y.field_243226_aM * this.field_78531_r.field_71474_y.field_243226_aM)) > 0.0f) {
            int n = this.field_78531_r.field_71439_g.func_70644_a(Effects.field_76431_k) ? 7 : 20;
            float \u26034 = 5.0f / (\u2603 * \u2603 + 5.0f) - \u2603 * 0.04f;
            \u26034 *= \u26034;
            Vector3f \u26035 = new Vector3f(0.0f, MathHelper.field_180189_a / 2.0f, MathHelper.field_180189_a / 2.0f);
            \u26033.func_227863_a_(\u26035.func_229187_a_(((float)this.field_78529_t + f) * (float)n));
            \u26033.func_227862_a_(1.0f / \u26034, 1.0f, 1.0f);
            float \u26036 = -((float)this.field_78529_t + f) * (float)n;
            \u26033.func_227863_a_(\u26035.func_229187_a_(\u26036));
        }
        Matrix4f matrix4f = \u26033.func_227866_c_().func_227870_a_();
        this.func_228379_a_(matrix4f);
        \u26032.func_216772_a(this.field_78531_r.field_71441_e, this.field_78531_r.func_175606_aa() == null ? this.field_78531_r.field_71439_g : this.field_78531_r.func_175606_aa(), !this.field_78531_r.field_71474_y.func_243230_g().func_243192_a(), this.field_78531_r.field_71474_y.func_243230_g().func_243193_b(), f);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(\u26032.func_216777_e()));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(\u26032.func_216778_f() + 180.0f));
        this.field_78531_r.field_71438_f.func_228426_a_(matrixStack, f, l, bl, \u26032, this, this.field_78513_d, matrix4f);
        this.field_78531_r.func_213239_aq().func_219895_b("hand");
        if (this.field_175074_C) {
            RenderSystem.clear(256, Minecraft.field_142025_a);
            this.func_228381_a_(matrixStack, \u26032, f);
        }
        this.field_78531_r.func_213239_aq().func_76319_b();
    }

    public void func_190564_k() {
        this.field_190566_ab = null;
        this.field_147709_v.func_148249_a();
        this.field_215317_L.func_216781_o();
    }

    public MapItemRenderer func_147701_i() {
        return this.field_147709_v;
    }

    public void func_190565_a(ItemStack itemStack) {
        this.field_190566_ab = itemStack;
        this.field_190567_ac = 40;
        this.field_190568_ad = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
        this.field_190569_ae = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
    }

    private void func_190563_a(int n, int n2, float f) {
        if (this.field_190566_ab == null || this.field_190567_ac <= 0) {
            return;
        }
        int n3 = 40 - this.field_190567_ac;
        float \u26032 = ((float)n3 + f) / 40.0f;
        float \u26033 = \u26032 * \u26032;
        float \u26034 = \u26032 * \u26033;
        float \u26035 = 10.25f * \u26034 * \u26033 - 24.95f * \u26033 * \u26033 + 25.5f * \u26034 - 13.8f * \u26033 + 4.0f * \u26032;
        float \u26036 = \u26035 * (float)Math.PI;
        float \u26037 = this.field_190568_ad * (float)(n / 4);
        float \u26038 = this.field_190569_ae * (float)(n2 / 4);
        RenderSystem.enableAlphaTest();
        RenderSystem.pushMatrix();
        RenderSystem.pushLightingAttributes();
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        MatrixStack \u26039 = new MatrixStack();
        \u26039.func_227860_a_();
        \u26039.func_227861_a_((float)(n / 2) + \u26037 * MathHelper.func_76135_e(MathHelper.func_76126_a(\u26036 * 2.0f)), (float)(n2 / 2) + \u26038 * MathHelper.func_76135_e(MathHelper.func_76126_a(\u26036 * 2.0f)), -50.0);
        float \u260310 = 50.0f + 175.0f * MathHelper.func_76126_a(\u26036);
        \u26039.func_227862_a_(\u260310, -\u260310, \u260310);
        \u26039.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(900.0f * MathHelper.func_76135_e(MathHelper.func_76126_a(\u26036))));
        \u26039.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(6.0f * MathHelper.func_76134_b(\u26032 * 8.0f)));
        \u26039.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(6.0f * MathHelper.func_76134_b(\u26032 * 8.0f)));
        IRenderTypeBuffer.Impl \u260311 = this.field_228374_i_.func_228487_b_();
        this.field_78531_r.func_175599_af().func_229110_a_(this.field_190566_ab, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, \u26039, \u260311);
        \u26039.func_227865_b_();
        \u260311.func_228461_a_();
        RenderSystem.popAttributes();
        RenderSystem.popMatrix();
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
    }

    private void func_243497_c(float f) {
        int n = this.field_78531_r.func_228018_at_().func_198107_o();
        \u2603 = this.field_78531_r.func_228018_at_().func_198087_p();
        double \u26032 = MathHelper.func_219803_d(f, 2.0, 1.0);
        float \u26033 = 0.2f * f;
        float \u26034 = 0.4f * f;
        float \u26035 = 0.2f * f;
        double \u26036 = (double)n * \u26032;
        double \u26037 = (double)\u2603 * \u26032;
        double \u26038 = ((double)n - \u26036) / 2.0;
        double \u26039 = ((double)\u2603 - \u26037) / 2.0;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE);
        RenderSystem.color4f(\u26033, \u26034, \u26035, 1.0f);
        this.field_78531_r.func_110434_K().func_110577_a(field_243496_c);
        Tessellator \u260310 = Tessellator.func_178181_a();
        BufferBuilder \u260311 = \u260310.func_178180_c();
        \u260311.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u260311.func_225582_a_(\u26038, \u26039 + \u26037, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        \u260311.func_225582_a_(\u26038 + \u26036, \u26039 + \u26037, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        \u260311.func_225582_a_(\u26038 + \u26036, \u26039, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        \u260311.func_225582_a_(\u26038, \u26039, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        \u260310.func_78381_a();
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();
    }

    public float func_205002_d(float f) {
        return MathHelper.func_219799_g(f, this.field_82832_V, this.field_82831_U);
    }

    public float func_205001_m() {
        return this.field_78530_s;
    }

    public ActiveRenderInfo func_215316_n() {
        return this.field_215317_L;
    }

    public LightTexture func_228384_l_() {
        return this.field_78513_d;
    }

    public OverlayTexture func_228385_m_() {
        return this.field_228375_t_;
    }
}

