/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;

public interface IRenderTypeBuffer {
    public static Impl func_228455_a_(BufferBuilder bufferBuilder) {
        return IRenderTypeBuffer.func_228456_a_((Map<RenderType, BufferBuilder>)ImmutableMap.of(), bufferBuilder);
    }

    public static Impl func_228456_a_(Map<RenderType, BufferBuilder> map, BufferBuilder bufferBuilder) {
        return new Impl(bufferBuilder, map);
    }

    public IVertexBuilder getBuffer(RenderType var1);

    public static class Impl
    implements IRenderTypeBuffer {
        protected final BufferBuilder field_228457_a_;
        protected final Map<RenderType, BufferBuilder> field_228458_b_;
        protected Optional<RenderType> field_228459_c_ = Optional.empty();
        protected final Set<BufferBuilder> field_228460_d_ = Sets.newHashSet();

        protected Impl(BufferBuilder bufferBuilder, Map<RenderType, BufferBuilder> map) {
            this.field_228457_a_ = bufferBuilder;
            this.field_228458_b_ = map;
        }

        @Override
        public IVertexBuilder getBuffer(RenderType renderType) {
            Optional<RenderType> optional = renderType.func_230169_u_();
            BufferBuilder \u26032 = this.func_228463_b_(renderType);
            if (!Objects.equals(this.field_228459_c_, optional)) {
                if (this.field_228459_c_.isPresent() && !this.field_228458_b_.containsKey(\u2603 = this.field_228459_c_.get())) {
                    this.func_228462_a_(\u2603);
                }
                if (this.field_228460_d_.add(\u26032)) {
                    \u26032.func_181668_a(renderType.func_228664_q_(), renderType.func_228663_p_());
                }
                this.field_228459_c_ = optional;
            }
            return \u26032;
        }

        private BufferBuilder func_228463_b_(RenderType renderType) {
            return this.field_228458_b_.getOrDefault(renderType, this.field_228457_a_);
        }

        public void func_228461_a_() {
            this.field_228459_c_.ifPresent(renderType -> {
                IVertexBuilder iVertexBuilder = this.getBuffer((RenderType)renderType);
                if (iVertexBuilder == this.field_228457_a_) {
                    this.func_228462_a_((RenderType)renderType);
                }
            });
            for (RenderType renderType2 : this.field_228458_b_.keySet()) {
                this.func_228462_a_(renderType2);
            }
        }

        public void func_228462_a_(RenderType renderType) {
            BufferBuilder bufferBuilder = this.func_228463_b_(renderType);
            boolean \u26032 = Objects.equals(this.field_228459_c_, renderType.func_230169_u_());
            if (!\u26032 && bufferBuilder == this.field_228457_a_) {
                return;
            }
            if (!this.field_228460_d_.remove(bufferBuilder)) {
                return;
            }
            renderType.func_228631_a_(bufferBuilder, 0, 0, 0);
            if (\u26032) {
                this.field_228459_c_ = Optional.empty();
            }
        }
    }
}

