/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.lwjgl.glfw.GLFWVidMode;

public final class VideoMode {
    private final int field_198069_a;
    private final int field_198070_b;
    private final int field_198071_c;
    private final int field_198072_d;
    private final int field_198073_e;
    private final int field_198074_f;
    private static final Pattern field_198075_g = Pattern.compile("(\\d+)x(\\d+)(?:@(\\d+)(?::(\\d+))?)?");

    public VideoMode(int n, int n2, int n3, int n4, int n5, int n6) {
        this.field_198069_a = n;
        this.field_198070_b = n2;
        this.field_198071_c = n3;
        this.field_198072_d = n4;
        this.field_198073_e = n5;
        this.field_198074_f = n6;
    }

    public VideoMode(GLFWVidMode.Buffer buffer) {
        this.field_198069_a = buffer.width();
        this.field_198070_b = buffer.height();
        this.field_198071_c = buffer.redBits();
        this.field_198072_d = buffer.greenBits();
        this.field_198073_e = buffer.blueBits();
        this.field_198074_f = buffer.refreshRate();
    }

    public VideoMode(GLFWVidMode gLFWVidMode) {
        this.field_198069_a = gLFWVidMode.width();
        this.field_198070_b = gLFWVidMode.height();
        this.field_198071_c = gLFWVidMode.redBits();
        this.field_198072_d = gLFWVidMode.greenBits();
        this.field_198073_e = gLFWVidMode.blueBits();
        this.field_198074_f = gLFWVidMode.refreshRate();
    }

    public int func_198064_a() {
        return this.field_198069_a;
    }

    public int func_198065_b() {
        return this.field_198070_b;
    }

    public int func_198062_c() {
        return this.field_198071_c;
    }

    public int func_198063_d() {
        return this.field_198072_d;
    }

    public int func_198068_e() {
        return this.field_198073_e;
    }

    public int func_198067_f() {
        return this.field_198074_f;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VideoMode videoMode = (VideoMode)object;
        return this.field_198069_a == videoMode.field_198069_a && this.field_198070_b == videoMode.field_198070_b && this.field_198071_c == videoMode.field_198071_c && this.field_198072_d == videoMode.field_198072_d && this.field_198073_e == videoMode.field_198073_e && this.field_198074_f == videoMode.field_198074_f;
    }

    public int hashCode() {
        return Objects.hash(this.field_198069_a, this.field_198070_b, this.field_198071_c, this.field_198072_d, this.field_198073_e, this.field_198074_f);
    }

    public String toString() {
        return String.format("%sx%s@%s (%sbit)", this.field_198069_a, this.field_198070_b, this.field_198074_f, this.field_198071_c + this.field_198072_d + this.field_198073_e);
    }

    public static Optional<VideoMode> func_198061_a(@Nullable String string) {
        if (string == null) {
            return Optional.empty();
        }
        try {
            Matcher matcher = field_198075_g.matcher(string);
            if (matcher.matches()) {
                int n = Integer.parseInt(matcher.group(1));
                \u2603 = Integer.parseInt(matcher.group(2));
                String \u26032 = matcher.group(3);
                \u2603 = \u26032 == null ? 60 : Integer.parseInt(\u26032);
                String \u26033 = matcher.group(4);
                \u2603 = \u26033 == null ? 24 : Integer.parseInt(\u26033);
                \u2603 = \u2603 / 3;
                return Optional.of(new VideoMode(n, \u2603, \u2603, \u2603, \u2603, \u2603));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public String func_198066_g() {
        return String.format("%sx%s@%s:%s", this.field_198069_a, this.field_198070_b, this.field_198074_f, this.field_198071_c + this.field_198072_d + this.field_198073_e);
    }
}

