/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.chunk.SetVisibility;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.crash.CrashReport;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkRenderDispatcher {
    private static final Logger field_178523_a = LogManager.getLogger();
    private final PriorityQueue<ChunkRender.ChunkRenderTask> field_228885_b_ = Queues.newPriorityQueue();
    private final Queue<RegionRenderCacheBuilder> field_228886_c_;
    private final Queue<Runnable> field_228887_d_ = Queues.newConcurrentLinkedQueue();
    private volatile int field_228888_e_;
    private volatile int field_228889_f_;
    private final RegionRenderCacheBuilder field_228890_g_;
    private final DelegatedTaskExecutor<Runnable> field_228891_h_;
    private final Executor field_228892_i_;
    private World field_228893_j_;
    private final WorldRenderer field_228894_k_;
    private Vector3d field_217672_l = Vector3d.field_186680_a;

    public ChunkRenderDispatcher(World world, WorldRenderer worldRenderer, Executor executor, boolean bl, RegionRenderCacheBuilder regionRenderCacheBuilder) {
        this.field_228893_j_ = world;
        this.field_228894_k_ = worldRenderer;
        int n = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (RenderType.func_228661_n_().stream().mapToInt(RenderType::func_228662_o_).sum() * 4) - 1);
        \u2603 = Runtime.getRuntime().availableProcessors();
        \u2603 = bl ? \u2603 : Math.min(\u2603, 4);
        \u2603 = Math.max(1, Math.min(\u2603, n));
        this.field_228890_g_ = regionRenderCacheBuilder;
        ArrayList \u26032 = Lists.newArrayListWithExpectedSize((int)\u2603);
        try {
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                \u26032.add(new RegionRenderCacheBuilder());
            }
        }
        catch (OutOfMemoryError \u26033) {
            field_178523_a.warn("Allocated only {}/{} buffers", (Object)\u26032.size(), (Object)\u2603);
            \u2603 = Math.min(\u26032.size() * 2 / 3, \u26032.size() - 1);
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                \u26032.remove(\u26032.size() - 1);
            }
            System.gc();
        }
        this.field_228886_c_ = Queues.newArrayDeque((Iterable)\u26032);
        this.field_228889_f_ = this.field_228886_c_.size();
        this.field_228892_i_ = executor;
        this.field_228891_h_ = DelegatedTaskExecutor.func_213144_a(executor, "Chunk Renderer");
        this.field_228891_h_.func_212871_a_(this::func_228909_h_);
    }

    public void func_228895_a_(World world) {
        this.field_228893_j_ = world;
    }

    private void func_228909_h_() {
        if (this.field_228886_c_.isEmpty()) {
            return;
        }
        ChunkRender.ChunkRenderTask chunkRenderTask = this.field_228885_b_.poll();
        if (chunkRenderTask == null) {
            return;
        }
        RegionRenderCacheBuilder \u26032 = this.field_228886_c_.poll();
        this.field_228888_e_ = this.field_228885_b_.size();
        this.field_228889_f_ = this.field_228886_c_.size();
        ((CompletableFuture)CompletableFuture.runAsync(() -> {}, this.field_228892_i_).thenCompose(void_ -> chunkRenderTask.func_225618_a_(\u26032))).whenComplete((chunkTaskResult2, throwable) -> {
            ChunkTaskResult chunkTaskResult2;
            if (throwable != null) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Batching chunks");
                Minecraft.func_71410_x().func_71404_a(Minecraft.func_71410_x().func_71396_d(crashReport));
                return;
            }
            this.field_228891_h_.func_212871_a_(() -> {
                if (chunkTaskResult2 == ChunkTaskResult.SUCCESSFUL) {
                    \u26032.func_228365_a_();
                } else {
                    \u26032.func_228367_b_();
                }
                this.field_228886_c_.add(\u26032);
                this.field_228889_f_ = this.field_228886_c_.size();
                this.func_228909_h_();
            });
        });
    }

    public String func_178504_a() {
        return String.format("pC: %03d, pU: %02d, aB: %02d", this.field_228888_e_, this.field_228887_d_.size(), this.field_228889_f_);
    }

    public void func_217669_a(Vector3d vector3d) {
        this.field_217672_l = vector3d;
    }

    public Vector3d func_217671_b() {
        return this.field_217672_l;
    }

    public boolean func_228908_d_() {
        boolean bl = false;
        while ((\u2603 = this.field_228887_d_.poll()) != null) {
            \u2603.run();
            bl = true;
        }
        return bl;
    }

    public void func_228902_a_(ChunkRender chunkRender) {
        chunkRender.func_228936_k_();
    }

    public void func_178514_b() {
        this.func_178513_e();
    }

    public void func_228900_a_(ChunkRender.ChunkRenderTask chunkRenderTask) {
        this.field_228891_h_.func_212871_a_(() -> {
            this.field_228885_b_.offer(chunkRenderTask);
            this.field_228888_e_ = this.field_228885_b_.size();
            this.func_228909_h_();
        });
    }

    public CompletableFuture<Void> func_228896_a_(BufferBuilder bufferBuilder, VertexBuffer vertexBuffer) {
        return CompletableFuture.runAsync(() -> {}, this.field_228887_d_::add).thenCompose(void_ -> this.func_228904_b_(bufferBuilder, vertexBuffer));
    }

    private CompletableFuture<Void> func_228904_b_(BufferBuilder bufferBuilder, VertexBuffer vertexBuffer) {
        return vertexBuffer.func_227878_b_(bufferBuilder);
    }

    private void func_178513_e() {
        while (!this.field_228885_b_.isEmpty()) {
            ChunkRender.ChunkRenderTask chunkRenderTask = this.field_228885_b_.poll();
            if (chunkRenderTask == null) continue;
            chunkRenderTask.func_225617_a_();
        }
        this.field_228888_e_ = 0;
    }

    public boolean func_188247_f() {
        return this.field_228888_e_ == 0 && this.field_228887_d_.isEmpty();
    }

    public void func_188244_g() {
        this.func_178513_e();
        this.field_228891_h_.close();
        this.field_228886_c_.clear();
    }

    public static class CompiledChunk {
        public static final CompiledChunk field_178502_a = new CompiledChunk(){

            @Override
            public boolean func_178495_a(Direction direction, Direction direction2) {
                return false;
            }
        };
        private final Set<RenderType> field_178500_b = new ObjectArraySet();
        private final Set<RenderType> field_178501_c = new ObjectArraySet();
        private boolean field_178498_d = true;
        private final List<TileEntity> field_178499_e = Lists.newArrayList();
        private SetVisibility field_178496_f = new SetVisibility();
        @Nullable
        private BufferBuilder.State field_178497_g;

        public boolean func_178489_a() {
            return this.field_178498_d;
        }

        public boolean func_228912_a_(RenderType renderType) {
            return !this.field_178500_b.contains(renderType);
        }

        public List<TileEntity> func_178485_b() {
            return this.field_178499_e;
        }

        public boolean func_178495_a(Direction direction, Direction direction2) {
            return this.field_178496_f.func_178621_a(direction, direction2);
        }
    }

    static enum ChunkTaskResult {
        SUCCESSFUL,
        CANCELLED;

    }

    public class ChunkRender {
        public final AtomicReference<CompiledChunk> field_178590_b = new AtomicReference<CompiledChunk>(CompiledChunk.field_178502_a);
        @Nullable
        private RebuildTask field_228921_d_;
        @Nullable
        private SortTransparencyTask field_228922_e_;
        private final Set<TileEntity> field_181056_j = Sets.newHashSet();
        private final Map<RenderType, VertexBuffer> field_178594_l = RenderType.func_228661_n_().stream().collect(Collectors.toMap(renderType -> renderType, renderType -> new VertexBuffer(DefaultVertexFormats.field_176600_a)));
        public AxisAlignedBB field_178591_c;
        private int field_178595_m = -1;
        private boolean field_178593_n = true;
        private final BlockPos.Mutable field_178586_f = new BlockPos.Mutable(-1, -1, -1);
        private final BlockPos.Mutable[] field_181702_p = Util.func_200696_a(new BlockPos.Mutable[6], mutableArray -> {
            for (int i = 0; i < ((BlockPos.Mutable[])mutableArray).length; ++i) {
                mutableArray[i] = new BlockPos.Mutable();
            }
        });
        private boolean field_188284_q;

        private boolean func_228930_a_(BlockPos blockPos) {
            return ChunkRenderDispatcher.this.field_228893_j_.func_217353_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4, ChunkStatus.field_222617_m, false) != null;
        }

        public boolean func_217674_b() {
            int n = 24;
            if (this.func_188280_f() > 576.0) {
                return this.func_228930_a_(this.field_181702_p[Direction.WEST.ordinal()]) && this.func_228930_a_(this.field_181702_p[Direction.NORTH.ordinal()]) && this.func_228930_a_(this.field_181702_p[Direction.EAST.ordinal()]) && this.func_228930_a_(this.field_181702_p[Direction.SOUTH.ordinal()]);
            }
            return true;
        }

        public boolean func_178577_a(int n) {
            if (this.field_178595_m == n) {
                return false;
            }
            this.field_178595_m = n;
            return true;
        }

        public VertexBuffer func_228924_a_(RenderType renderType) {
            return this.field_178594_l.get(renderType);
        }

        public void func_189562_a(int n, int n2, int n3) {
            if (n == this.field_178586_f.func_177958_n() && n2 == this.field_178586_f.func_177956_o() && n3 == this.field_178586_f.func_177952_p()) {
                return;
            }
            this.func_178585_h();
            this.field_178586_f.func_181079_c(n, n2, n3);
            this.field_178591_c = new AxisAlignedBB(n, n2, n3, n + 16, n2 + 16, n3 + 16);
            for (Direction direction : Direction.values()) {
                this.field_181702_p[direction.ordinal()].func_189533_g(this.field_178586_f).func_189534_c(direction, 16);
            }
        }

        protected double func_188280_f() {
            ActiveRenderInfo activeRenderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            double \u26032 = this.field_178591_c.field_72340_a + 8.0 - activeRenderInfo.func_216785_c().field_72450_a;
            double \u26033 = this.field_178591_c.field_72338_b + 8.0 - activeRenderInfo.func_216785_c().field_72448_b;
            double \u26034 = this.field_178591_c.field_72339_c + 8.0 - activeRenderInfo.func_216785_c().field_72449_c;
            return \u26032 * \u26032 + \u26033 * \u26033 + \u26034 * \u26034;
        }

        private void func_228923_a_(BufferBuilder bufferBuilder) {
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        }

        public CompiledChunk func_178571_g() {
            return this.field_178590_b.get();
        }

        private void func_178585_h() {
            this.func_228935_i_();
            this.field_178590_b.set(CompiledChunk.field_178502_a);
            this.field_178593_n = true;
        }

        public void func_178566_a() {
            this.func_178585_h();
            this.field_178594_l.values().forEach(VertexBuffer::close);
        }

        public BlockPos func_178568_j() {
            return this.field_178586_f;
        }

        public void func_178575_a(boolean bl) {
            \u2603 = this.field_178593_n;
            this.field_178593_n = true;
            this.field_188284_q = bl | (\u2603 && this.field_188284_q);
        }

        public void func_188282_m() {
            this.field_178593_n = false;
            this.field_188284_q = false;
        }

        public boolean func_178569_m() {
            return this.field_178593_n;
        }

        public boolean func_188281_o() {
            return this.field_178593_n && this.field_188284_q;
        }

        public BlockPos func_181701_a(Direction direction) {
            return this.field_181702_p[direction.ordinal()];
        }

        public boolean func_228925_a_(RenderType renderType, ChunkRenderDispatcher chunkRenderDispatcher) {
            CompiledChunk compiledChunk = this.func_178571_g();
            if (this.field_228922_e_ != null) {
                this.field_228922_e_.func_225617_a_();
            }
            if (!compiledChunk.field_178501_c.contains(renderType)) {
                return false;
            }
            this.field_228922_e_ = new SortTransparencyTask(this.func_188280_f(), compiledChunk);
            chunkRenderDispatcher.func_228900_a_(this.field_228922_e_);
            return true;
        }

        protected void func_228935_i_() {
            if (this.field_228921_d_ != null) {
                this.field_228921_d_.func_225617_a_();
                this.field_228921_d_ = null;
            }
            if (this.field_228922_e_ != null) {
                this.field_228922_e_.func_225617_a_();
                this.field_228922_e_ = null;
            }
        }

        public ChunkRenderTask func_178574_d() {
            this.func_228935_i_();
            BlockPos blockPos = this.field_178586_f.func_185334_h();
            boolean \u26032 = true;
            ChunkRenderCache \u26033 = ChunkRenderCache.func_212397_a(ChunkRenderDispatcher.this.field_228893_j_, blockPos.func_177982_a(-1, -1, -1), blockPos.func_177982_a(16, 16, 16), 1);
            this.field_228921_d_ = new RebuildTask(this.func_188280_f(), \u26033);
            return this.field_228921_d_;
        }

        public void func_228929_a_(ChunkRenderDispatcher chunkRenderDispatcher) {
            ChunkRenderTask chunkRenderTask = this.func_178574_d();
            chunkRenderDispatcher.func_228900_a_(chunkRenderTask);
        }

        private void func_228931_a_(Set<TileEntity> set) {
            HashSet hashSet = Sets.newHashSet(set);
            \u2603 = Sets.newHashSet(this.field_181056_j);
            hashSet.removeAll(this.field_181056_j);
            \u2603.removeAll(set);
            this.field_181056_j.clear();
            this.field_181056_j.addAll(set);
            ChunkRenderDispatcher.this.field_228894_k_.func_181023_a(\u2603, hashSet);
        }

        public void func_228936_k_() {
            ChunkRenderTask chunkRenderTask = this.func_178574_d();
            chunkRenderTask.func_225618_a_(ChunkRenderDispatcher.this.field_228890_g_);
        }

        abstract class ChunkRenderTask
        implements Comparable<ChunkRenderTask> {
            protected final double field_188229_e;
            protected final AtomicBoolean field_178554_h = new AtomicBoolean(false);

            public ChunkRenderTask(double d) {
                this.field_188229_e = d;
            }

            public abstract CompletableFuture<ChunkTaskResult> func_225618_a_(RegionRenderCacheBuilder var1);

            public abstract void func_225617_a_();

            @Override
            public int compareTo(ChunkRenderTask chunkRenderTask) {
                return Doubles.compare((double)this.field_188229_e, (double)chunkRenderTask.field_188229_e);
            }

            @Override
            public /* synthetic */ int compareTo(Object object) {
                return this.compareTo((ChunkRenderTask)object);
            }
        }

        class SortTransparencyTask
        extends ChunkRenderTask {
            private final CompiledChunk field_228945_e_;

            public SortTransparencyTask(double d, CompiledChunk compiledChunk) {
                super(d);
                this.field_228945_e_ = compiledChunk;
            }

            @Override
            public CompletableFuture<ChunkTaskResult> func_225618_a_(RegionRenderCacheBuilder regionRenderCacheBuilder) {
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (!ChunkRender.this.func_217674_b()) {
                    this.field_178554_h.set(true);
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                Vector3d vector3d = ChunkRenderDispatcher.this.func_217671_b();
                float \u26032 = (float)vector3d.field_72450_a;
                float \u26033 = (float)vector3d.field_72448_b;
                float \u26034 = (float)vector3d.field_72449_c;
                BufferBuilder.State \u26035 = this.field_228945_e_.field_178497_g;
                if (\u26035 == null || !this.field_228945_e_.field_178500_b.contains(RenderType.func_228645_f_())) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                BufferBuilder \u26036 = regionRenderCacheBuilder.func_228366_a_(RenderType.func_228645_f_());
                ChunkRender.this.func_228923_a_(\u26036);
                \u26036.func_178993_a(\u26035);
                \u26036.func_181674_a(\u26032 - (float)ChunkRender.this.field_178586_f.func_177958_n(), \u26033 - (float)ChunkRender.this.field_178586_f.func_177956_o(), \u26034 - (float)ChunkRender.this.field_178586_f.func_177952_p());
                this.field_228945_e_.field_178497_g = \u26036.func_181672_a();
                \u26036.func_178977_d();
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                CompletionStage \u26037 = ChunkRenderDispatcher.this.func_228896_a_(regionRenderCacheBuilder.func_228366_a_(RenderType.func_228645_f_()), ChunkRender.this.func_228924_a_(RenderType.func_228645_f_())).thenApply(void_ -> ChunkTaskResult.CANCELLED);
                return ((CompletableFuture)\u26037).handle((chunkTaskResult, throwable) -> {
                    if (throwable != null && !(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                        Minecraft.func_71410_x().func_71404_a(CrashReport.func_85055_a(throwable, "Rendering chunk"));
                    }
                    return this.field_178554_h.get() ? ChunkTaskResult.CANCELLED : ChunkTaskResult.SUCCESSFUL;
                });
            }

            @Override
            public void func_225617_a_() {
                this.field_178554_h.set(true);
            }
        }

        class RebuildTask
        extends ChunkRenderTask {
            @Nullable
            protected ChunkRenderCache field_228938_d_;

            public RebuildTask(double d, @Nullable ChunkRenderCache chunkRenderCache) {
                super(d);
                this.field_228938_d_ = chunkRenderCache;
            }

            @Override
            public CompletableFuture<ChunkTaskResult> func_225618_a_(RegionRenderCacheBuilder regionRenderCacheBuilder) {
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (!ChunkRender.this.func_217674_b()) {
                    this.field_228938_d_ = null;
                    ChunkRender.this.func_178575_a(false);
                    this.field_178554_h.set(true);
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                Vector3d vector3d = ChunkRenderDispatcher.this.func_217671_b();
                float \u26032 = (float)vector3d.field_72450_a;
                float \u26033 = (float)vector3d.field_72448_b;
                float \u26034 = (float)vector3d.field_72449_c;
                CompiledChunk \u26035 = new CompiledChunk();
                Set<TileEntity> \u26036 = this.func_228940_a_(\u26032, \u26033, \u26034, \u26035, regionRenderCacheBuilder);
                ChunkRender.this.func_228931_a_(\u26036);
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                ArrayList \u26037 = Lists.newArrayList();
                \u26035.field_178501_c.forEach(renderType -> \u26037.add(ChunkRenderDispatcher.this.func_228896_a_(regionRenderCacheBuilder.func_228366_a_((RenderType)renderType), ChunkRender.this.func_228924_a_((RenderType)renderType))));
                return Util.func_215079_b(\u26037).handle((list, throwable) -> {
                    if (throwable != null && !(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                        Minecraft.func_71410_x().func_71404_a(CrashReport.func_85055_a(throwable, "Rendering chunk"));
                    }
                    if (this.field_178554_h.get()) {
                        return ChunkTaskResult.CANCELLED;
                    }
                    ChunkRender.this.field_178590_b.set(\u26035);
                    return ChunkTaskResult.SUCCESSFUL;
                });
            }

            private Set<TileEntity> func_228940_a_(float f, float f2, float f3, CompiledChunk compiledChunk2, RegionRenderCacheBuilder regionRenderCacheBuilder) {
                CompiledChunk compiledChunk2;
                boolean bl = true;
                BlockPos \u26032 = ChunkRender.this.field_178586_f.func_185334_h();
                BlockPos \u26033 = \u26032.func_177982_a(15, 15, 15);
                VisGraph \u26034 = new VisGraph();
                HashSet \u26035 = Sets.newHashSet();
                ChunkRenderCache \u26036 = this.field_228938_d_;
                this.field_228938_d_ = null;
                MatrixStack \u26037 = new MatrixStack();
                if (\u26036 != null) {
                    BlockModelRenderer.func_211847_a();
                    Random random = new Random();
                    BlockRendererDispatcher \u26038 = Minecraft.func_71410_x().func_175602_ab();
                    for (BlockPos blockPos : BlockPos.func_218278_a(\u26032, \u26033)) {
                        BufferBuilder \u260310;
                        BlockState blockState = \u26036.func_180495_p(blockPos);
                        Block \u26039 = blockState.func_177230_c();
                        if (blockState.func_200015_d(\u26036, blockPos)) {
                            \u26034.func_178606_a(blockPos);
                        }
                        if (\u26039.func_235695_q_() && (\u2603 = \u26036.func_212399_a(blockPos, Chunk.CreateEntityType.CHECK)) != null) {
                            this.func_228942_a_(compiledChunk2, \u26035, \u2603);
                        }
                        if (!((FluidState)(\u2603 = \u26036.func_204610_c(blockPos))).func_206888_e()) {
                            RenderType renderType = RenderTypeLookup.func_228391_a_((FluidState)\u2603);
                            \u260310 = regionRenderCacheBuilder.func_228366_a_(renderType);
                            if (compiledChunk2.field_178501_c.add(renderType)) {
                                ChunkRender.this.func_228923_a_(\u260310);
                            }
                            if (\u26038.func_228794_a_(blockPos, \u26036, \u260310, (FluidState)\u2603)) {
                                compiledChunk2.field_178498_d = false;
                                compiledChunk2.field_178500_b.add(renderType);
                            }
                        }
                        if (blockState.func_185901_i() == BlockRenderType.INVISIBLE) continue;
                        renderType = RenderTypeLookup.func_228390_a_(blockState);
                        \u260310 = regionRenderCacheBuilder.func_228366_a_(renderType);
                        if (compiledChunk2.field_178501_c.add(renderType)) {
                            ChunkRender.this.func_228923_a_(\u260310);
                        }
                        \u26037.func_227860_a_();
                        \u26037.func_227861_a_(blockPos.func_177958_n() & 0xF, blockPos.func_177956_o() & 0xF, blockPos.func_177952_p() & 0xF);
                        if (\u26038.func_228793_a_(blockState, blockPos, \u26036, \u26037, \u260310, true, random)) {
                            compiledChunk2.field_178498_d = false;
                            compiledChunk2.field_178500_b.add(renderType);
                        }
                        \u26037.func_227865_b_();
                    }
                    if (compiledChunk2.field_178500_b.contains(RenderType.func_228645_f_())) {
                        BufferBuilder bufferBuilder = regionRenderCacheBuilder.func_228366_a_(RenderType.func_228645_f_());
                        bufferBuilder.func_181674_a(f - (float)\u26032.func_177958_n(), f2 - (float)\u26032.func_177956_o(), f3 - (float)\u26032.func_177952_p());
                        compiledChunk2.field_178497_g = bufferBuilder.func_181672_a();
                    }
                    compiledChunk2.field_178501_c.stream().map(regionRenderCacheBuilder::func_228366_a_).forEach(BufferBuilder::func_178977_d);
                    BlockModelRenderer.func_210266_a();
                }
                compiledChunk2.field_178496_f = \u26034.func_178607_a();
                return \u26035;
            }

            private <E extends TileEntity> void func_228942_a_(CompiledChunk compiledChunk, Set<TileEntity> set, E e) {
                TileEntityRenderer<E> tileEntityRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(e);
                if (tileEntityRenderer != null) {
                    compiledChunk.field_178499_e.add(e);
                    if (tileEntityRenderer.func_188185_a(e)) {
                        set.add(e);
                    }
                }
            }

            @Override
            public void func_225617_a_() {
                this.field_228938_d_ = null;
                if (this.field_178554_h.compareAndSet(false, true)) {
                    ChunkRender.this.func_178575_a(false);
                }
            }
        }
    }
}

