/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.RealmsMainScreen;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.PreloadedTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureManager
implements IFutureReloadListener,
ITickable,
AutoCloseable {
    private static final Logger field_147646_a = LogManager.getLogger();
    public static final ResourceLocation field_194008_a = new ResourceLocation("");
    private final Map<ResourceLocation, Texture> field_110585_a = Maps.newHashMap();
    private final Set<ITickable> field_110583_b = Sets.newHashSet();
    private final Map<String, Integer> field_110584_c = Maps.newHashMap();
    private final IResourceManager field_110582_d;

    public TextureManager(IResourceManager iResourceManager) {
        this.field_110582_d = iResourceManager;
    }

    public void func_110577_a(ResourceLocation resourceLocation) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_229269_d_(resourceLocation));
        } else {
            this.func_229269_d_(resourceLocation);
        }
    }

    private void func_229269_d_(ResourceLocation resourceLocation) {
        Texture texture = this.field_110585_a.get(resourceLocation);
        if (texture == null) {
            texture = new SimpleTexture(resourceLocation);
            this.func_229263_a_(resourceLocation, texture);
        }
        texture.func_229148_d_();
    }

    public void func_229263_a_(ResourceLocation resourceLocation, Texture texture) {
        \u2603 = this.field_110585_a.put(resourceLocation, texture = this.func_230183_b_(resourceLocation, texture));
        if (\u2603 != texture) {
            if (\u2603 != null && \u2603 != MissingTextureSprite.func_195676_d()) {
                this.field_110583_b.remove(\u2603);
                this.func_243505_b(resourceLocation, \u2603);
            }
            if (texture instanceof ITickable) {
                this.field_110583_b.add((ITickable)((Object)texture));
            }
        }
    }

    private void func_243505_b(ResourceLocation resourceLocation, Texture texture2) {
        Texture texture2;
        if (texture2 != MissingTextureSprite.func_195676_d()) {
            try {
                texture2.close();
            }
            catch (Exception exception) {
                field_147646_a.warn("Failed to close texture {}", (Object)resourceLocation, (Object)exception);
            }
        }
        texture2.func_147631_c();
    }

    private Texture func_230183_b_(ResourceLocation resourceLocation, Texture texture) {
        try {
            texture.func_195413_a(this.field_110582_d);
            return texture;
        }
        catch (IOException iOException) {
            if (resourceLocation != field_194008_a) {
                field_147646_a.warn("Failed to load texture: {}", (Object)resourceLocation, (Object)iOException);
            }
            return MissingTextureSprite.func_195676_d();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Registering texture");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Resource location being registered");
            \u26032.func_71507_a("Resource location", resourceLocation);
            \u26032.func_189529_a("Texture object class", () -> texture.getClass().getName());
            throw new ReportedException(crashReport);
        }
    }

    @Nullable
    public Texture func_229267_b_(ResourceLocation resourceLocation) {
        return this.field_110585_a.get(resourceLocation);
    }

    public ResourceLocation func_110578_a(String string, DynamicTexture dynamicTexture) {
        Integer n = this.field_110584_c.get(string);
        if (n == null) {
            n = 1;
        } else {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
        this.field_110584_c.put(string, n);
        ResourceLocation \u26032 = new ResourceLocation(String.format("dynamic/%s_%d", string, n));
        this.func_229263_a_(\u26032, dynamicTexture);
        return \u26032;
    }

    public CompletableFuture<Void> func_215268_a(ResourceLocation resourceLocation, Executor executor) {
        if (!this.field_110585_a.containsKey(resourceLocation)) {
            PreloadedTexture preloadedTexture = new PreloadedTexture(this.field_110582_d, resourceLocation, executor);
            this.field_110585_a.put(resourceLocation, preloadedTexture);
            return preloadedTexture.func_215248_a().thenRunAsync(() -> this.func_229263_a_(resourceLocation, preloadedTexture), TextureManager::func_229262_a_);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static void func_229262_a_(Runnable runnable) {
        Minecraft.func_71410_x().execute(() -> RenderSystem.recordRenderCall(runnable::run));
    }

    @Override
    public void func_110550_d() {
        for (ITickable iTickable : this.field_110583_b) {
            iTickable.func_110550_d();
        }
    }

    public void func_147645_c(ResourceLocation resourceLocation) {
        Texture texture = this.func_229267_b_(resourceLocation);
        if (texture != null) {
            TextureUtil.func_225679_a_(texture.func_110552_b());
        }
    }

    @Override
    public void close() {
        this.field_110585_a.forEach(this::func_243505_b);
        this.field_110585_a.clear();
        this.field_110583_b.clear();
        this.field_110584_c.clear();
    }

    @Override
    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage iStage, IResourceManager iResourceManager, IProfiler iProfiler, IProfiler iProfiler2, Executor executor, Executor executor2) {
        return ((CompletableFuture)CompletableFuture.allOf(MainMenuScreen.func_213097_a(this, executor), this.func_215268_a(Widget.field_230687_i_, executor)).thenCompose(iStage::func_216872_a)).thenAcceptAsync(void_ -> {
            MissingTextureSprite.func_195676_d();
            RealmsMainScreen.func_227932_a_(this.field_110582_d);
            Iterator<Map.Entry<ResourceLocation, Texture>> iterator = this.field_110585_a.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, Texture> entry = iterator.next();
                ResourceLocation \u26032 = entry.getKey();
                Texture \u26033 = entry.getValue();
                if (\u26033 == MissingTextureSprite.func_195676_d() && !\u26032.equals(MissingTextureSprite.func_195675_b())) {
                    iterator.remove();
                    continue;
                }
                \u26033.func_215244_a(this, iResourceManager, \u26032, executor2);
            }
        }, runnable -> RenderSystem.recordRenderCall(runnable::run));
    }
}

