/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class Enchantment {
    private final EquipmentSlotType[] field_185263_a;
    private final Rarity field_77333_a;
    public final EnchantmentType field_77351_y;
    @Nullable
    protected String field_77350_z;

    @Nullable
    public static Enchantment func_185262_c(int n) {
        return (Enchantment)Registry.field_212628_q.func_148745_a(n);
    }

    protected Enchantment(Rarity rarity, EnchantmentType enchantmentType, EquipmentSlotType[] equipmentSlotTypeArray) {
        this.field_77333_a = rarity;
        this.field_77351_y = enchantmentType;
        this.field_185263_a = equipmentSlotTypeArray;
    }

    public Map<EquipmentSlotType, ItemStack> func_222181_a(LivingEntity livingEntity) {
        EnumMap enumMap = Maps.newEnumMap(EquipmentSlotType.class);
        for (EquipmentSlotType equipmentSlotType : this.field_185263_a) {
            ItemStack itemStack = livingEntity.func_184582_a(equipmentSlotType);
            if (itemStack.func_190926_b()) continue;
            enumMap.put(equipmentSlotType, itemStack);
        }
        return enumMap;
    }

    public Rarity func_77324_c() {
        return this.field_77333_a;
    }

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int n) {
        return 1 + n * 10;
    }

    public int func_223551_b(int n) {
        return this.func_77321_a(n) + 5;
    }

    public int func_77318_a(int n, DamageSource damageSource) {
        return 0;
    }

    public float func_152376_a(int n, CreatureAttribute creatureAttribute) {
        return 0.0f;
    }

    public final boolean func_191560_c(Enchantment enchantment) {
        return this.func_77326_a(enchantment) && enchantment.func_77326_a(this);
    }

    protected boolean func_77326_a(Enchantment enchantment) {
        return this != enchantment;
    }

    protected String func_210771_f() {
        if (this.field_77350_z == null) {
            this.field_77350_z = Util.func_200697_a("enchantment", Registry.field_212628_q.func_177774_c(this));
        }
        return this.field_77350_z;
    }

    public String func_77320_a() {
        return this.func_210771_f();
    }

    public ITextComponent func_200305_d(int n) {
        TranslationTextComponent translationTextComponent = new TranslationTextComponent(this.func_77320_a());
        if (this.func_190936_d()) {
            translationTextComponent.func_240699_a_(TextFormatting.RED);
        } else {
            translationTextComponent.func_240699_a_(TextFormatting.GRAY);
        }
        if (n != 1 || this.func_77325_b() != 1) {
            translationTextComponent.func_240702_b_(" ").func_230529_a_(new TranslationTextComponent("enchantment.level." + n));
        }
        return translationTextComponent;
    }

    public boolean func_92089_a(ItemStack itemStack) {
        return this.field_77351_y.func_77557_a(itemStack.func_77973_b());
    }

    public void func_151368_a(LivingEntity livingEntity, Entity entity, int n) {
    }

    public void func_151367_b(LivingEntity livingEntity, Entity entity, int n) {
    }

    public boolean func_185261_e() {
        return false;
    }

    public boolean func_190936_d() {
        return false;
    }

    public boolean func_230309_h_() {
        return true;
    }

    public boolean func_230310_i_() {
        return true;
    }

    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int field_185275_e;

        private Rarity(int n2) {
            this.field_185275_e = n2;
        }

        public int func_185270_a() {
            return this.field_185275_e;
        }
    }
}

