/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public abstract class AbstractSkeletonEntity
extends MonsterEntity
implements IRangedAttackMob {
    private final RangedBowAttackGoal<AbstractSkeletonEntity> field_85037_d = new RangedBowAttackGoal<AbstractSkeletonEntity>(this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal field_85038_e = new MeleeAttackGoal(this, 1.2, false){

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            AbstractSkeletonEntity.this.func_213395_q(false);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            AbstractSkeletonEntity.this.func_213395_q(true);
        }
    };

    protected AbstractSkeletonEntity(EntityType<? extends AbstractSkeletonEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
        this.func_85036_m();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, new RestrictSunGoal(this));
        this.field_70714_bg.func_75776_a(3, new FleeSunGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, new AvoidEntityGoal<WolfEntity>(this, WolfEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(5, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<TurtleEntity>(this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    public static AttributeModifierMap.MutableAttribute func_234275_m_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(this.func_190727_o(), 0.15f, 1.0f);
    }

    abstract SoundEvent func_190727_o();

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Override
    public void func_70636_d() {
        boolean bl = this.func_204609_dp();
        if (bl) {
            ItemStack itemStack = this.func_184582_a(EquipmentSlotType.HEAD);
            if (!itemStack.func_190926_b()) {
                if (itemStack.func_77984_f()) {
                    itemStack.func_196085_b(itemStack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemStack.func_77952_i() >= itemStack.func_77958_k()) {
                        this.func_213361_c(EquipmentSlotType.HEAD);
                        this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                    }
                }
                bl = false;
            }
            if (bl) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    @Override
    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof CreatureEntity) {
            CreatureEntity creatureEntity = (CreatureEntity)this.func_184187_bx();
            this.field_70761_aq = creatureEntity.field_70761_aq;
        }
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        super.func_180481_a(difficultyInstance);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151031_f));
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld iServerWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        ILivingEntityData iLivingEntityData2 = super.func_213386_a(iServerWorld, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
        this.func_180481_a(difficultyInstance);
        this.func_180483_b(difficultyInstance);
        this.func_85036_m();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficultyInstance.func_180170_c());
        if (this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
            LocalDate localDate = LocalDate.now();
            int \u26032 = localDate.get(ChronoField.DAY_OF_MONTH);
            int \u26033 = localDate.get(ChronoField.MONTH_OF_YEAR);
            if (\u26033 == 10 && \u26032 == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_196628_cT : Blocks.field_196625_cS));
                this.field_184655_bs[EquipmentSlotType.HEAD.func_188454_b()] = 0.0f;
            }
        }
        return iLivingEntityData2;
    }

    public void func_85036_m() {
        if (this.field_70170_p == null || this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70714_bg.func_85156_a(this.field_85038_e);
        this.field_70714_bg.func_85156_a(this.field_85037_d);
        ItemStack itemStack = this.func_184586_b(ProjectileHelper.func_221274_a(this, Items.field_151031_f));
        if (itemStack.func_77973_b() == Items.field_151031_f) {
            int n = 20;
            if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                n = 40;
            }
            this.field_85037_d.func_189428_b(n);
            this.field_70714_bg.func_75776_a(4, this.field_85037_d);
        } else {
            this.field_70714_bg.func_75776_a(4, this.field_85038_e);
        }
    }

    @Override
    public void func_82196_d(LivingEntity livingEntity, float f) {
        ItemStack itemStack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a(this, Items.field_151031_f)));
        AbstractArrowEntity \u26032 = this.func_213624_b(itemStack, f);
        double \u26033 = livingEntity.func_226277_ct_() - this.func_226277_ct_();
        double \u26034 = livingEntity.func_226283_e_(0.3333333333333333) - \u26032.func_226278_cu_();
        double \u26035 = livingEntity.func_226281_cx_() - this.func_226281_cx_();
        double \u26036 = MathHelper.func_76133_a(\u26033 * \u26033 + \u26035 * \u26035);
        \u26032.func_70186_c(\u26033, \u26034 + \u26036 * (double)0.2f, \u26035, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c(\u26032);
    }

    protected AbstractArrowEntity func_213624_b(ItemStack itemStack, float f) {
        return ProjectileHelper.func_221272_a(this, itemStack, f);
    }

    @Override
    public boolean func_230280_a_(ShootableItem shootableItem) {
        return shootableItem == Items.field_151031_f;
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_85036_m();
    }

    @Override
    public void func_184201_a(EquipmentSlotType equipmentSlotType, ItemStack itemStack) {
        super.func_184201_a(equipmentSlotType, itemStack);
        if (!this.field_70170_p.field_72995_K) {
            this.func_85036_m();
        }
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return 1.74f;
    }

    @Override
    public double func_70033_W() {
        return -0.6;
    }
}

