/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.RunSometimesTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.monster.IFlinging;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ZoglinEntity
extends MonsterEntity
implements IMob,
IFlinging {
    private static final DataParameter<Boolean> field_234327_d_ = EntityDataManager.func_187226_a(ZoglinEntity.class, DataSerializers.field_187198_h);
    private int field_234325_bu_;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super ZoglinEntity>>> field_234324_b_ = ImmutableList.of(SensorType.field_220998_b, SensorType.field_220999_c);
    protected static final ImmutableList<? extends MemoryModuleType<?>> field_234326_c_ = ImmutableList.of(MemoryModuleType.field_220945_f, MemoryModuleType.field_220946_g, MemoryModuleType.field_220949_j, MemoryModuleType.field_234102_l_, MemoryModuleType.field_220951_l, MemoryModuleType.field_220950_k, MemoryModuleType.field_223021_x, MemoryModuleType.field_220954_o, MemoryModuleType.field_234103_o_, MemoryModuleType.field_234104_p_);

    public ZoglinEntity(EntityType<? extends ZoglinEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
        this.field_70728_aV = 5;
    }

    protected Brain.BrainCodec<ZoglinEntity> func_230289_cH_() {
        return Brain.func_233705_a_(field_234326_c_, field_234324_b_);
    }

    @Override
    protected Brain<?> func_213364_a(Dynamic<?> dynamic) {
        Brain<ZoglinEntity> brain = this.func_230289_cH_().func_233748_a_(dynamic);
        ZoglinEntity.func_234328_a_(brain);
        ZoglinEntity.func_234329_b_(brain);
        ZoglinEntity.func_234330_c_(brain);
        brain.func_218199_a((Set<Activity>)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_233714_e_();
        return brain;
    }

    private static void func_234328_a_(Brain<ZoglinEntity> brain) {
        brain.func_233698_a_(Activity.field_221365_a, 0, (ImmutableList<Task<ZoglinEntity>>)ImmutableList.of((Object)new LookTask(45, 90), (Object)new WalkToTargetTask()));
    }

    private static void func_234329_b_(Brain<ZoglinEntity> brain) {
        brain.func_233698_a_(Activity.field_221366_b, 10, (ImmutableList<Task<ZoglinEntity>>)ImmutableList.of(new ForgetAttackTargetTask<ZoglinEntity>(ZoglinEntity::func_234335_eQ_), new RunSometimesTask<LivingEntity>(new LookAtEntityTask(8.0f), RangedInteger.func_233017_a_(30, 60)), new FirstShuffledTask(ImmutableList.of((Object)Pair.of((Object)new WalkRandomlyTask(0.4f), (Object)2), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(0.4f, 3), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)))));
    }

    private static void func_234330_c_(Brain<ZoglinEntity> brain) {
        brain.func_233699_a_(Activity.field_234621_k_, 10, (ImmutableList<Task<ZoglinEntity>>)ImmutableList.of((Object)new MoveToTargetTask(1.0f), new SupplementedTask<MobEntity>(ZoglinEntity::func_234331_eI_, new AttackTargetTask(40)), new SupplementedTask<MobEntity>(ZoglinEntity::func_70631_g_, new AttackTargetTask(15)), new FindNewAttackTargetTask()), MemoryModuleType.field_234103_o_);
    }

    private Optional<? extends LivingEntity> func_234335_eQ_() {
        return this.func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g).orElse((List<LivingEntity>)ImmutableList.of()).stream().filter(ZoglinEntity::func_234337_j_).findFirst();
    }

    private static boolean func_234337_j_(LivingEntity livingEntity) {
        EntityType<?> entityType = livingEntity.func_200600_R();
        return entityType != EntityType.field_233590_aW_ && entityType != EntityType.field_200797_k && EntityPredicates.field_233583_f_.test(livingEntity);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_234327_d_, false);
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        super.func_184206_a(dataParameter);
        if (field_234327_d_.equals(dataParameter)) {
            this.func_213323_x_();
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234339_m_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.3f).func_233815_a_(Attributes.field_233820_c_, 0.6f).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    public boolean func_234331_eI_() {
        return !this.func_70631_g_();
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        this.field_234325_bu_ = 10;
        this.field_70170_p.func_72960_a(this, (byte)4);
        this.func_184185_a(SoundEvents.field_232852_rw_, 1.0f, this.func_70647_i());
        return IFlinging.func_234403_a_(this, (LivingEntity)entity);
    }

    @Override
    public boolean func_184652_a(PlayerEntity playerEntity) {
        return !this.func_110167_bD();
    }

    @Override
    protected void func_213371_e(LivingEntity livingEntity) {
        if (!this.func_70631_g_()) {
            IFlinging.func_234404_b_(this, livingEntity);
        }
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213302_cg() - (this.func_70631_g_() ? 0.2 : 0.15);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        boolean bl = super.func_70097_a(damageSource, f);
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (!bl || !(damageSource.func_76346_g() instanceof LivingEntity)) {
            return bl;
        }
        LivingEntity \u26032 = (LivingEntity)damageSource.func_76346_g();
        if (EntityPredicates.field_233583_f_.test(\u26032) && !BrainUtil.func_233861_a_(this, \u26032, 4.0)) {
            this.func_234338_k_(\u26032);
        }
        return bl;
    }

    private void func_234338_k_(LivingEntity livingEntity) {
        this.field_213378_br.func_218189_b(MemoryModuleType.field_223021_x);
        this.field_213378_br.func_233696_a_(MemoryModuleType.field_234103_o_, livingEntity, 200L);
    }

    public Brain<ZoglinEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected void func_234332_eJ_() {
        Activity activity = this.field_213378_br.func_233716_f_().orElse(null);
        this.field_213378_br.func_233706_a_((List<Activity>)ImmutableList.of((Object)Activity.field_234621_k_, (Object)Activity.field_221366_b));
        \u2603 = this.field_213378_br.func_233716_f_().orElse(null);
        if (\u2603 == Activity.field_234621_k_ && activity != Activity.field_234621_k_) {
            this.func_234334_eN_();
        }
        this.func_213395_q(this.field_213378_br.func_218191_a(MemoryModuleType.field_234103_o_));
    }

    @Override
    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("zoglinBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.func_234332_eJ_();
    }

    @Override
    public void func_82227_f(boolean bl) {
        this.func_184212_Q().func_187227_b(field_234327_d_, bl);
        if (!this.field_70170_p.field_72995_K && bl) {
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(0.5);
        }
    }

    @Override
    public boolean func_70631_g_() {
        return this.func_184212_Q().func_187225_a(field_234327_d_);
    }

    @Override
    public void func_70636_d() {
        if (this.field_234325_bu_ > 0) {
            --this.field_234325_bu_;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 4) {
            this.field_234325_bu_ = 10;
            this.func_184185_a(SoundEvents.field_232852_rw_, 1.0f, this.func_70647_i());
        } else {
            super.func_70103_a(by);
        }
    }

    @Override
    public int func_230290_eL_() {
        return this.field_234325_bu_;
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        if (this.field_213378_br.func_218191_a(MemoryModuleType.field_234103_o_)) {
            return SoundEvents.field_232851_rv_;
        }
        return SoundEvents.field_232850_ru_;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_232854_ry_;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232853_rx_;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_232855_rz_, 0.15f, 1.0f);
    }

    protected void func_234334_eN_() {
        this.func_184185_a(SoundEvents.field_232851_rv_, 1.0f, this.func_70647_i());
    }

    @Override
    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_218798_a(this);
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (this.func_70631_g_()) {
            compoundNBT.func_74757_a("IsBaby", true);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_74767_n("IsBaby")) {
            this.func_82227_f(true);
        }
    }
}

