/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;

public class PolarBearEntity
extends AnimalEntity
implements IAngerable {
    private static final DataParameter<Boolean> field_189798_bx = EntityDataManager.func_187226_a(PolarBearEntity.class, DataSerializers.field_187198_h);
    private float field_189799_by;
    private float field_189800_bz;
    private int field_189797_bB;
    private static final RangedInteger field_234217_by_ = TickRangeConverter.func_233037_a_(20, 39);
    private int field_234218_bz_;
    private UUID field_234216_bA_;

    public PolarBearEntity(EntityType<? extends PolarBearEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return EntityType.field_200786_Z.func_200721_a(serverWorld);
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return false;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, new PanicGoal());
        this.field_70714_bg.func_75776_a(4, new FollowParentGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(5, new RandomWalkingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, new AttackPlayerGoal());
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, 10, true, false, this::func_233680_b_));
        this.field_70715_bh.func_75776_a(4, new NearestAttackableTargetGoal<FoxEntity>(this, FoxEntity.class, 10, true, true, null));
        this.field_70715_bh.func_75776_a(5, new ResetAngerGoal<PolarBearEntity>(this, false));
    }

    public static AttributeModifierMap.MutableAttribute func_234219_eI_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    public static boolean func_223320_c(EntityType<PolarBearEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        Optional<RegistryKey<Biome>> optional = iWorld.func_242406_i(blockPos);
        if (Objects.equals(optional, Optional.of(Biomes.field_76776_l)) || Objects.equals(optional, Optional.of(Biomes.field_203620_Z))) {
            return iWorld.func_226659_b_(blockPos, 0) > 8 && iWorld.func_180495_p(blockPos.func_177977_b()).func_203425_a(Blocks.field_150432_aD);
        }
        return PolarBearEntity.func_223316_b(entityType, iWorld, spawnReason, blockPos, random);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_241358_a_((ServerWorld)this.field_70170_p, compoundNBT);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        this.func_233682_c_(compoundNBT);
    }

    @Override
    public void func_230258_H__() {
        this.func_230260_a__(field_234217_by_.func_233018_a_(this.field_70146_Z));
    }

    @Override
    public void func_230260_a__(int n) {
        this.field_234218_bz_ = n;
    }

    @Override
    public int func_230256_F__() {
        return this.field_234218_bz_;
    }

    @Override
    public void func_230259_a_(@Nullable UUID uUID) {
        this.field_234216_bA_ = uUID;
    }

    @Override
    public UUID func_230257_G__() {
        return this.field_234216_bA_;
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.func_70631_g_()) {
            return SoundEvents.field_190027_es;
        }
        return SoundEvents.field_190026_er;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_190029_eu;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected void func_189796_de() {
        if (this.field_189797_bB <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, this.func_70647_i());
            this.field_189797_bB = 40;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_189798_bx, false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_189800_bz != this.field_189799_by) {
                this.func_213323_x_();
            }
            this.field_189799_by = this.field_189800_bz;
            this.field_189800_bz = this.func_189793_df() ? MathHelper.func_76131_a(this.field_189800_bz + 1.0f, 0.0f, 6.0f) : MathHelper.func_76131_a(this.field_189800_bz - 1.0f, 0.0f, 6.0f);
        }
        if (this.field_189797_bB > 0) {
            --this.field_189797_bB;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
    }

    @Override
    public EntitySize func_213305_a(Pose pose2) {
        Pose pose2;
        if (this.field_189800_bz > 0.0f) {
            float f = this.field_189800_bz / 6.0f;
            \u2603 = 1.0f + f;
            return super.func_213305_a(pose2).func_220312_a(1.0f, \u2603);
        }
        return super.func_213305_a(pose2);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean bl = entity.func_70097_a(DamageSource.func_76358_a(this), (int)this.func_233637_b_(Attributes.field_233823_f_));
        if (bl) {
            this.func_174815_a(this, entity);
        }
        return bl;
    }

    public boolean func_189793_df() {
        return this.field_70180_af.func_187225_a(field_189798_bx);
    }

    public void func_189794_p(boolean bl) {
        this.field_70180_af.func_187227_b(field_189798_bx, bl);
    }

    public float func_189795_r(float f) {
        return MathHelper.func_219799_g(f, this.field_189799_by, this.field_189800_bz) / 6.0f;
    }

    @Override
    protected float func_189749_co() {
        return 0.98f;
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld iServerWorld2, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        IServerWorld iServerWorld2;
        if (iLivingEntityData2 == null) {
            ILivingEntityData iLivingEntityData2 = new AgeableEntity.AgeableData(1.0f);
        }
        return super.func_213386_a(iServerWorld2, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super(PolarBearEntity.this, 2.0);
        }

        @Override
        public boolean func_75250_a() {
            if (!PolarBearEntity.this.func_70631_g_() && !PolarBearEntity.this.func_70027_ad()) {
                return false;
            }
            return super.func_75250_a();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super(PolarBearEntity.this, 1.25, true);
        }

        @Override
        protected void func_190102_a(LivingEntity livingEntity, double d) {
            \u2603 = this.func_179512_a(livingEntity);
            if (d <= \u2603 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k(livingEntity);
                PolarBearEntity.this.func_189794_p(false);
            } else if (d <= \u2603 * 2.0) {
                if (this.func_234040_h_()) {
                    PolarBearEntity.this.func_189794_p(false);
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    PolarBearEntity.this.func_189794_p(true);
                    PolarBearEntity.this.func_189796_de();
                }
            } else {
                this.func_234039_g_();
                PolarBearEntity.this.func_189794_p(false);
            }
        }

        @Override
        public void func_75251_c() {
            PolarBearEntity.this.func_189794_p(false);
            super.func_75251_c();
        }

        @Override
        protected double func_179512_a(LivingEntity livingEntity) {
            return 4.0f + livingEntity.func_213311_cf();
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super(PolarBearEntity.this, PlayerEntity.class, 20, true, true, null);
        }

        @Override
        public boolean func_75250_a() {
            if (PolarBearEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                List<PolarBearEntity> list = PolarBearEntity.this.field_70170_p.func_217357_a(PolarBearEntity.class, PolarBearEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
                for (PolarBearEntity polarBearEntity : list) {
                    if (!polarBearEntity.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super(PolarBearEntity.this, new Class[0]);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            if (PolarBearEntity.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        @Override
        protected void func_220793_a(MobEntity mobEntity, LivingEntity livingEntity) {
            if (mobEntity instanceof PolarBearEntity && !mobEntity.func_70631_g_()) {
                super.func_220793_a(mobEntity, livingEntity);
            }
        }
    }
}

