/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public final class Ingredient
implements Predicate<ItemStack> {
    public static final Ingredient field_193370_a = new Ingredient(Stream.empty());
    private final IItemList[] field_199807_b;
    private ItemStack[] field_193371_b;
    private IntList field_194140_c;

    private Ingredient(Stream<? extends IItemList> stream) {
        this.field_199807_b = (IItemList[])stream.toArray(IItemList[]::new);
    }

    public ItemStack[] func_193365_a() {
        this.func_199806_d();
        return this.field_193371_b;
    }

    private void func_199806_d() {
        if (this.field_193371_b == null) {
            this.field_193371_b = (ItemStack[])Arrays.stream(this.field_199807_b).flatMap(iItemList -> iItemList.func_199799_a().stream()).distinct().toArray(ItemStack[]::new);
        }
    }

    @Override
    public boolean test(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        this.func_199806_d();
        if (this.field_193371_b.length == 0) {
            return itemStack.func_190926_b();
        }
        for (ItemStack itemStack2 : this.field_193371_b) {
            if (itemStack2.func_77973_b() != itemStack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public IntList func_194139_b() {
        if (this.field_194140_c == null) {
            this.func_199806_d();
            this.field_194140_c = new IntArrayList(this.field_193371_b.length);
            for (ItemStack itemStack : this.field_193371_b) {
                this.field_194140_c.add(RecipeItemHelper.func_194113_b(itemStack));
            }
            this.field_194140_c.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.field_194140_c;
    }

    public void func_199564_a(PacketBuffer packetBuffer) {
        this.func_199806_d();
        packetBuffer.func_150787_b(this.field_193371_b.length);
        for (int i = 0; i < this.field_193371_b.length; ++i) {
            packetBuffer.func_150788_a(this.field_193371_b[i]);
        }
    }

    public JsonElement func_200304_c() {
        if (this.field_199807_b.length == 1) {
            return this.field_199807_b[0].func_200303_b();
        }
        JsonArray jsonArray = new JsonArray();
        for (IItemList iItemList : this.field_199807_b) {
            jsonArray.add((JsonElement)iItemList.func_200303_b());
        }
        return jsonArray;
    }

    public boolean func_203189_d() {
        return !(this.field_199807_b.length != 0 || this.field_193371_b != null && this.field_193371_b.length != 0 || this.field_194140_c != null && !this.field_194140_c.isEmpty());
    }

    private static Ingredient func_209357_a(Stream<? extends IItemList> stream) {
        Ingredient ingredient = new Ingredient(stream);
        return ingredient.field_199807_b.length == 0 ? field_193370_a : ingredient;
    }

    public static Ingredient func_199804_a(IItemProvider ... iItemProviderArray) {
        return Ingredient.func_234819_a_(Arrays.stream(iItemProviderArray).map(ItemStack::new));
    }

    public static Ingredient func_193369_a(ItemStack ... itemStackArray) {
        return Ingredient.func_234819_a_(Arrays.stream(itemStackArray));
    }

    public static Ingredient func_234819_a_(Stream<ItemStack> stream) {
        return Ingredient.func_209357_a(stream.filter(itemStack -> !itemStack.func_190926_b()).map(itemStack -> new SingleItemList((ItemStack)itemStack)));
    }

    public static Ingredient func_199805_a(ITag<Item> iTag) {
        return Ingredient.func_209357_a(Stream.of(new TagList(iTag)));
    }

    public static Ingredient func_199566_b(PacketBuffer packetBuffer) {
        int n = packetBuffer.func_150792_a();
        return Ingredient.func_209357_a(Stream.generate(() -> new SingleItemList(packetBuffer.func_150791_c())).limit(n));
    }

    public static Ingredient func_199802_a(@Nullable JsonElement jsonElement2) {
        if (jsonElement2 == null || jsonElement2.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (jsonElement2.isJsonObject()) {
            return Ingredient.func_209357_a(Stream.of(Ingredient.func_199803_a(jsonElement2.getAsJsonObject())));
        }
        if (jsonElement2.isJsonArray()) {
            JsonArray jsonArray = jsonElement2.getAsJsonArray();
            if (jsonArray.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            return Ingredient.func_209357_a(StreamSupport.stream(jsonArray.spliterator(), false).map(jsonElement -> Ingredient.func_199803_a(JSONUtils.func_151210_l(jsonElement, "item"))));
        }
        throw new JsonSyntaxException("Expected item to be object or array of objects");
    }

    private static IItemList func_199803_a(JsonObject jsonObject) {
        if (jsonObject.has("item") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (jsonObject.has("item")) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "item"));
            Item \u26032 = Registry.field_212630_s.func_241873_b(resourceLocation).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + resourceLocation + "'"));
            return new SingleItemList(new ItemStack(\u26032));
        }
        if (jsonObject.has("tag")) {
            \u2603 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "tag"));
            ITag<Item> \u26033 = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(\u2603);
            if (\u26033 == null) {
                throw new JsonSyntaxException("Unknown item tag '" + \u2603 + "'");
            }
            return new TagList(\u26033);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    @Override
    public /* synthetic */ boolean test(@Nullable Object object) {
        return this.test((ItemStack)object);
    }

    static class TagList
    implements IItemList {
        private final ITag<Item> field_199800_a;

        private TagList(ITag<Item> iTag) {
            this.field_199800_a = iTag;
        }

        @Override
        public Collection<ItemStack> func_199799_a() {
            ArrayList arrayList = Lists.newArrayList();
            for (Item item : this.field_199800_a.func_230236_b_()) {
                arrayList.add(new ItemStack(item));
            }
            return arrayList;
        }

        @Override
        public JsonObject func_200303_b() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", TagCollectionManager.func_242178_a().func_241836_b().func_232975_b_(this.field_199800_a).toString());
            return jsonObject;
        }
    }

    static class SingleItemList
    implements IItemList {
        private final ItemStack field_199801_a;

        private SingleItemList(ItemStack itemStack) {
            this.field_199801_a = itemStack;
        }

        @Override
        public Collection<ItemStack> func_199799_a() {
            return Collections.singleton(this.field_199801_a);
        }

        @Override
        public JsonObject func_200303_b() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Registry.field_212630_s.func_177774_c(this.field_199801_a.func_77973_b()).toString());
            return jsonObject;
        }
    }

    static interface IItemList {
        public Collection<ItemStack> func_199799_a();

        public JsonObject func_200303_b();
    }
}

