/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.ILootGenerator;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.ArrayUtils;

public abstract class StandaloneLootEntry
extends LootEntry {
    protected final int field_216158_e;
    protected final int field_216159_f;
    protected final ILootFunction[] field_216160_g;
    private final BiFunction<ItemStack, LootContext, ItemStack> field_216157_c;
    private final ILootGenerator field_216161_h = new Generator(){

        @Override
        public void func_216188_a(Consumer<ItemStack> consumer, LootContext lootContext) {
            StandaloneLootEntry.this.func_216154_a(ILootFunction.func_215858_a(StandaloneLootEntry.this.field_216157_c, consumer, lootContext), lootContext);
        }
    };

    protected StandaloneLootEntry(int n, int n2, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray) {
        super(iLootConditionArray);
        this.field_216158_e = n;
        this.field_216159_f = n2;
        this.field_216160_g = iLootFunctionArray;
        this.field_216157_c = LootFunctionManager.func_216241_a(iLootFunctionArray);
    }

    @Override
    public void func_225579_a_(ValidationTracker validationTracker) {
        super.func_225579_a_(validationTracker);
        for (int i = 0; i < this.field_216160_g.length; ++i) {
            this.field_216160_g[i].func_225580_a_(validationTracker.func_227534_b_(".functions[" + i + "]"));
        }
    }

    protected abstract void func_216154_a(Consumer<ItemStack> var1, LootContext var2);

    @Override
    public boolean expand(LootContext lootContext, Consumer<ILootGenerator> consumer) {
        if (this.func_216141_a(lootContext)) {
            consumer.accept(this.field_216161_h);
            return true;
        }
        return false;
    }

    public static Builder<?> func_216156_a(ILootEntryBuilder iLootEntryBuilder) {
        return new BuilderImpl(iLootEntryBuilder);
    }

    public static abstract class Serializer<T extends StandaloneLootEntry>
    extends LootEntry.Serializer<T> {
        @Override
        public void func_230422_a_(JsonObject jsonObject, T t, JsonSerializationContext jsonSerializationContext) {
            if (((StandaloneLootEntry)t).field_216158_e != 1) {
                jsonObject.addProperty("weight", (Number)((StandaloneLootEntry)t).field_216158_e);
            }
            if (((StandaloneLootEntry)t).field_216159_f != 0) {
                jsonObject.addProperty("quality", (Number)((StandaloneLootEntry)t).field_216159_f);
            }
            if (!ArrayUtils.isEmpty((Object[])((StandaloneLootEntry)t).field_216160_g)) {
                jsonObject.add("functions", jsonSerializationContext.serialize((Object)((StandaloneLootEntry)t).field_216160_g));
            }
        }

        @Override
        public final T func_230421_b_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            int n = JSONUtils.func_151208_a(jsonObject, "weight", 1);
            \u2603 = JSONUtils.func_151208_a(jsonObject, "quality", 0);
            ILootFunction[] \u26032 = JSONUtils.func_188177_a(jsonObject, "functions", new ILootFunction[0], jsonDeserializationContext, ILootFunction[].class);
            return this.func_212829_b_(jsonObject, jsonDeserializationContext, n, \u2603, iLootConditionArray, \u26032);
        }

        protected abstract T func_212829_b_(JsonObject var1, JsonDeserializationContext var2, int var3, int var4, ILootCondition[] var5, ILootFunction[] var6);

        @Override
        public /* synthetic */ LootEntry func_230421_b_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_230421_b_(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }

    static class BuilderImpl
    extends Builder<BuilderImpl> {
        private final ILootEntryBuilder field_216090_c;

        public BuilderImpl(ILootEntryBuilder iLootEntryBuilder) {
            this.field_216090_c = iLootEntryBuilder;
        }

        @Override
        protected BuilderImpl func_212845_d_() {
            return this;
        }

        @Override
        public LootEntry func_216081_b() {
            return this.field_216090_c.build(this.field_216087_a, this.field_216088_b, this.func_216079_f(), this.func_216084_a());
        }

        @Override
        protected /* synthetic */ LootEntry.Builder func_212845_d_() {
            return this.func_212845_d_();
        }
    }

    @FunctionalInterface
    public static interface ILootEntryBuilder {
        public StandaloneLootEntry build(int var1, int var2, ILootCondition[] var3, ILootFunction[] var4);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends LootEntry.Builder<T>
    implements ILootFunctionConsumer<T> {
        protected int field_216087_a = 1;
        protected int field_216088_b = 0;
        private final List<ILootFunction> field_216089_c = Lists.newArrayList();

        @Override
        public T func_212841_b_(ILootFunction.IBuilder iBuilder) {
            this.field_216089_c.add(iBuilder.func_216052_b());
            return (T)((Builder)this.func_212845_d_());
        }

        protected ILootFunction[] func_216084_a() {
            return this.field_216089_c.toArray(new ILootFunction[0]);
        }

        public T func_216086_a(int n) {
            this.field_216087_a = n;
            return (T)((Builder)this.func_212845_d_());
        }

        public T func_216085_b(int n) {
            this.field_216088_b = n;
            return (T)((Builder)this.func_212845_d_());
        }

        @Override
        public /* synthetic */ Object func_212841_b_(ILootFunction.IBuilder iBuilder) {
            return this.func_212841_b_(iBuilder);
        }
    }

    public abstract class Generator
    implements ILootGenerator {
        protected Generator() {
        }

        @Override
        public int func_186361_a(float f) {
            return Math.max(MathHelper.func_76141_d((float)StandaloneLootEntry.this.field_216158_e + (float)StandaloneLootEntry.this.field_216159_f * f), 0);
        }
    }
}

