/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTypes;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompoundNBT
implements INBT {
    public static final Codec<CompoundNBT> field_240597_a_ = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        INBT iNBT = (INBT)dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a).getValue();
        if (iNBT instanceof CompoundNBT) {
            return DataResult.success((Object)((CompoundNBT)iNBT));
        }
        return DataResult.error((String)("Not a compound tag: " + iNBT));
    }, compoundNBT -> new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, compoundNBT));
    private static final Logger field_191551_b = LogManager.getLogger();
    private static final Pattern field_193583_c = Pattern.compile("[A-Za-z0-9._+-]+");
    public static final INBTType<CompoundNBT> field_229675_a_ = new INBTType<CompoundNBT>(){

        @Override
        public CompoundNBT func_225649_b_(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
            nBTSizeTracker.func_152450_a(384L);
            if (n > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            HashMap hashMap = Maps.newHashMap();
            while ((\u2603 = CompoundNBT.func_152447_a(dataInput, nBTSizeTracker)) != 0) {
                String string = CompoundNBT.func_152448_b(dataInput, nBTSizeTracker);
                nBTSizeTracker.func_152450_a(224 + 16 * string.length());
                INBT \u26032 = CompoundNBT.func_229680_b_(NBTTypes.func_229710_a_(\u2603), string, dataInput, n + 1, nBTSizeTracker);
                if (hashMap.put(string, \u26032) == null) continue;
                nBTSizeTracker.func_152450_a(288L);
            }
            return new CompoundNBT(hashMap);
        }

        @Override
        public String func_225648_a_() {
            return "COMPOUND";
        }

        @Override
        public String func_225650_b_() {
            return "TAG_Compound";
        }

        @Override
        public /* synthetic */ INBT func_225649_b_(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
            return this.func_225649_b_(dataInput, n, nBTSizeTracker);
        }
    };
    private final Map<String, INBT> field_74784_a;

    protected CompoundNBT(Map<String, INBT> map) {
        this.field_74784_a = map;
    }

    public CompoundNBT() {
        this(Maps.newHashMap());
    }

    @Override
    public void func_74734_a(DataOutput dataOutput2) throws IOException {
        DataOutput dataOutput2;
        for (String string : this.field_74784_a.keySet()) {
            INBT iNBT = this.field_74784_a.get(string);
            CompoundNBT.func_150298_a(string, iNBT, dataOutput2);
        }
        dataOutput2.writeByte(0);
    }

    public Set<String> func_150296_c() {
        return this.field_74784_a.keySet();
    }

    @Override
    public byte func_74732_a() {
        return 10;
    }

    public INBTType<CompoundNBT> func_225647_b_() {
        return field_229675_a_;
    }

    public int func_186856_d() {
        return this.field_74784_a.size();
    }

    @Nullable
    public INBT func_218657_a(String string, INBT iNBT) {
        return this.field_74784_a.put(string, iNBT);
    }

    public void func_74774_a(String string, byte by) {
        this.field_74784_a.put(string, ByteNBT.func_229671_a_(by));
    }

    public void func_74777_a(String string, short s) {
        this.field_74784_a.put(string, ShortNBT.func_229701_a_(s));
    }

    public void func_74768_a(String string, int n) {
        this.field_74784_a.put(string, IntNBT.func_229692_a_(n));
    }

    public void func_74772_a(String string, long l) {
        this.field_74784_a.put(string, LongNBT.func_229698_a_(l));
    }

    public void func_186854_a(String string, UUID uUID) {
        this.field_74784_a.put(string, NBTUtil.func_240626_a_(uUID));
    }

    public UUID func_186857_a(String string) {
        return NBTUtil.func_186860_b(this.func_74781_a(string));
    }

    public boolean func_186855_b(String string) {
        INBT iNBT = this.func_74781_a(string);
        return iNBT != null && iNBT.func_225647_b_() == IntArrayNBT.field_229690_a_ && ((IntArrayNBT)iNBT).func_150302_c().length == 4;
    }

    public void func_74776_a(String string, float f) {
        this.field_74784_a.put(string, FloatNBT.func_229689_a_(f));
    }

    public void func_74780_a(String string, double d) {
        this.field_74784_a.put(string, DoubleNBT.func_229684_a_(d));
    }

    public void func_74778_a(String string, String string2) {
        this.field_74784_a.put(string, StringNBT.func_229705_a_(string2));
    }

    public void func_74773_a(String string, byte[] byArray) {
        this.field_74784_a.put(string, new ByteArrayNBT(byArray));
    }

    public void func_74783_a(String string, int[] nArray) {
        this.field_74784_a.put(string, new IntArrayNBT(nArray));
    }

    public void func_197646_b(String string, List<Integer> list) {
        this.field_74784_a.put(string, new IntArrayNBT(list));
    }

    public void func_197644_a(String string, long[] lArray) {
        this.field_74784_a.put(string, new LongArrayNBT(lArray));
    }

    public void func_202168_c(String string, List<Long> list) {
        this.field_74784_a.put(string, new LongArrayNBT(list));
    }

    public void func_74757_a(String string, boolean bl) {
        this.field_74784_a.put(string, ByteNBT.func_229672_a_(bl));
    }

    @Nullable
    public INBT func_74781_a(String string) {
        return this.field_74784_a.get(string);
    }

    public byte func_150299_b(String string) {
        INBT iNBT = this.field_74784_a.get(string);
        if (iNBT == null) {
            return 0;
        }
        return iNBT.func_74732_a();
    }

    public boolean func_74764_b(String string) {
        return this.field_74784_a.containsKey(string);
    }

    public boolean func_150297_b(String string, int n) {
        byte by = this.func_150299_b(string);
        if (by == n) {
            return true;
        }
        if (n == 99) {
            return by == 1 || by == 2 || by == 3 || by == 4 || by == 5 || by == 6;
        }
        return false;
    }

    public byte func_74771_c(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NumberNBT)this.field_74784_a.get(string)).func_150290_f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short func_74765_d(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NumberNBT)this.field_74784_a.get(string)).func_150289_e();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int func_74762_e(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NumberNBT)this.field_74784_a.get(string)).func_150287_d();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long func_74763_f(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NumberNBT)this.field_74784_a.get(string)).func_150291_c();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float func_74760_g(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NumberNBT)this.field_74784_a.get(string)).func_150288_h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double func_74769_h(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NumberNBT)this.field_74784_a.get(string)).func_150286_g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String func_74779_i(String string) {
        try {
            if (this.func_150297_b(string, 8)) {
                return this.field_74784_a.get(string).func_150285_a_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] func_74770_j(String string) {
        try {
            if (this.func_150297_b(string, 7)) {
                return ((ByteArrayNBT)this.field_74784_a.get(string)).func_150292_c();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.func_229677_a_(string, ByteArrayNBT.field_229667_a_, classCastException));
        }
        return new byte[0];
    }

    public int[] func_74759_k(String string) {
        try {
            if (this.func_150297_b(string, 11)) {
                return ((IntArrayNBT)this.field_74784_a.get(string)).func_150302_c();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.func_229677_a_(string, IntArrayNBT.field_229690_a_, classCastException));
        }
        return new int[0];
    }

    public long[] func_197645_o(String string) {
        try {
            if (this.func_150297_b(string, 12)) {
                return ((LongArrayNBT)this.field_74784_a.get(string)).func_197652_h();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.func_229677_a_(string, LongArrayNBT.field_229696_a_, classCastException));
        }
        return new long[0];
    }

    public CompoundNBT func_74775_l(String string) {
        try {
            if (this.func_150297_b(string, 10)) {
                return (CompoundNBT)this.field_74784_a.get(string);
            }
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.func_229677_a_(string, field_229675_a_, classCastException));
        }
        return new CompoundNBT();
    }

    public ListNBT func_150295_c(String string, int n) {
        try {
            if (this.func_150299_b(string) == 9) {
                ListNBT listNBT = (ListNBT)this.field_74784_a.get(string);
                if (listNBT.isEmpty() || listNBT.func_230528_d__() == n) {
                    return listNBT;
                }
                return new ListNBT();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.func_229677_a_(string, ListNBT.field_229694_a_, classCastException));
        }
        return new ListNBT();
    }

    public boolean func_74767_n(String string) {
        return this.func_74771_c(string) != 0;
    }

    public void func_82580_o(String string) {
        this.field_74784_a.remove(string);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        Collection<String> \u26032 = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList arrayList = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(arrayList);
            \u26032 = arrayList;
        }
        for (String string : \u26032) {
            if (stringBuilder.length() != 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(CompoundNBT.func_193582_s(string)).append(':').append(this.field_74784_a.get(string));
        }
        return stringBuilder.append('}').toString();
    }

    public boolean isEmpty() {
        return this.field_74784_a.isEmpty();
    }

    private CrashReport func_229677_a_(String string, INBTType<?> iNBTType, ClassCastException classCastException) {
        CrashReport crashReport = CrashReport.func_85055_a(classCastException, "Reading NBT data");
        CrashReportCategory \u26032 = crashReport.func_85057_a("Corrupt NBT tag", 1);
        \u26032.func_189529_a("Tag type found", () -> this.field_74784_a.get(string).func_225647_b_().func_225648_a_());
        \u26032.func_189529_a("Tag type expected", iNBTType::func_225648_a_);
        \u26032.func_71507_a("Tag name", string);
        return crashReport;
    }

    @Override
    public CompoundNBT func_74737_b() {
        HashMap hashMap = Maps.newHashMap((Map)Maps.transformValues(this.field_74784_a, INBT::func_74737_b));
        return new CompoundNBT(hashMap);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof CompoundNBT && Objects.equals(this.field_74784_a, ((CompoundNBT)object).field_74784_a);
    }

    public int hashCode() {
        return this.field_74784_a.hashCode();
    }

    private static void func_150298_a(String string, INBT iNBT, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(iNBT.func_74732_a());
        if (iNBT.func_74732_a() == 0) {
            return;
        }
        dataOutput.writeUTF(string);
        iNBT.func_74734_a(dataOutput);
    }

    private static byte func_152447_a(DataInput dataInput, NBTSizeTracker nBTSizeTracker) throws IOException {
        return dataInput.readByte();
    }

    private static String func_152448_b(DataInput dataInput, NBTSizeTracker nBTSizeTracker) throws IOException {
        return dataInput.readUTF();
    }

    private static INBT func_229680_b_(INBTType<?> iNBTType, String string, DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) {
        try {
            return iNBTType.func_225649_b_(dataInput, n, nBTSizeTracker);
        }
        catch (IOException iOException) {
            CrashReport crashReport = CrashReport.func_85055_a(iOException, "Loading NBT data");
            CrashReportCategory \u26032 = crashReport.func_85058_a("NBT Tag");
            \u26032.func_71507_a("Tag name", string);
            \u26032.func_71507_a("Tag type", iNBTType.func_225648_a_());
            throw new ReportedException(crashReport);
        }
    }

    public CompoundNBT func_197643_a(CompoundNBT compoundNBT) {
        for (String string2 : compoundNBT.field_74784_a.keySet()) {
            String string2;
            INBT iNBT = compoundNBT.field_74784_a.get(string2);
            if (iNBT.func_74732_a() == 10) {
                if (this.func_150297_b(string2, 10)) {
                    CompoundNBT compoundNBT2 = this.func_74775_l(string2);
                    compoundNBT2.func_197643_a((CompoundNBT)iNBT);
                    continue;
                }
                this.func_218657_a(string2, iNBT.func_74737_b());
                continue;
            }
            this.func_218657_a(string2, iNBT.func_74737_b());
        }
        return this;
    }

    protected static String func_193582_s(String string) {
        if (field_193583_c.matcher(string).matches()) {
            return string;
        }
        return StringNBT.func_197654_a(string);
    }

    protected static ITextComponent func_197642_t(String string) {
        if (field_193583_c.matcher(string).matches()) {
            return new StringTextComponent(string).func_240699_a_(field_197638_b);
        }
        \u2603 = StringNBT.func_197654_a(string);
        \u2603 = \u2603.substring(0, 1);
        IFormattableTextComponent iFormattableTextComponent = new StringTextComponent(\u2603.substring(1, \u2603.length() - 1)).func_240699_a_(field_197638_b);
        return new StringTextComponent(\u2603).func_230529_a_(iFormattableTextComponent).func_240702_b_(\u2603);
    }

    @Override
    public ITextComponent func_199850_a(String string2, int n) {
        String string2;
        Object \u26033;
        if (this.field_74784_a.isEmpty()) {
            return new StringTextComponent("{}");
        }
        StringTextComponent stringTextComponent = new StringTextComponent("{");
        Object \u26032 = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            \u26033 = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(\u26033);
            \u26032 = \u26033;
        }
        if (!string2.isEmpty()) {
            stringTextComponent.func_240702_b_("\n");
        }
        \u26033 = \u26032.iterator();
        while (\u26033.hasNext()) {
            \u2603 = (String)\u26033.next();
            IFormattableTextComponent iFormattableTextComponent = new StringTextComponent(Strings.repeat((String)string2, (int)(n + 1))).func_230529_a_(CompoundNBT.func_197642_t(\u2603)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.field_74784_a.get(\u2603).func_199850_a(string2, n + 1));
            if (\u26033.hasNext()) {
                iFormattableTextComponent.func_240702_b_(String.valueOf(',')).func_240702_b_(string2.isEmpty() ? " " : "\n");
            }
            stringTextComponent.func_230529_a_(iFormattableTextComponent);
        }
        if (!string2.isEmpty()) {
            stringTextComponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)string2, (int)n));
        }
        stringTextComponent.func_240702_b_("}");
        return stringTextComponent;
    }

    protected Map<String, INBT> func_240600_h_() {
        return Collections.unmodifiableMap(this.field_74784_a);
    }

    @Override
    public /* synthetic */ INBT func_74737_b() {
        return this.func_74737_b();
    }
}

