/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scoreboard;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.stats.StatType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;

public class ScoreCriteria {
    public static final Map<String, ScoreCriteria> field_96643_a = Maps.newHashMap();
    public static final ScoreCriteria field_96641_b = new ScoreCriteria("dummy");
    public static final ScoreCriteria field_178791_c = new ScoreCriteria("trigger");
    public static final ScoreCriteria field_96642_c = new ScoreCriteria("deathCount");
    public static final ScoreCriteria field_96639_d = new ScoreCriteria("playerKillCount");
    public static final ScoreCriteria field_96640_e = new ScoreCriteria("totalKillCount");
    public static final ScoreCriteria field_96638_f = new ScoreCriteria("health", true, RenderType.HEARTS);
    public static final ScoreCriteria field_186698_h = new ScoreCriteria("food", true, RenderType.INTEGER);
    public static final ScoreCriteria field_186699_i = new ScoreCriteria("air", true, RenderType.INTEGER);
    public static final ScoreCriteria field_186700_j = new ScoreCriteria("armor", true, RenderType.INTEGER);
    public static final ScoreCriteria field_186701_k = new ScoreCriteria("xp", true, RenderType.INTEGER);
    public static final ScoreCriteria field_186702_l = new ScoreCriteria("level", true, RenderType.INTEGER);
    public static final ScoreCriteria[] field_197913_m = new ScoreCriteria[]{new ScoreCriteria("teamkill." + TextFormatting.BLACK.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.DARK_BLUE.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.DARK_GREEN.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.DARK_AQUA.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.DARK_RED.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.DARK_PURPLE.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.GOLD.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.GRAY.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.DARK_GRAY.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.BLUE.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.GREEN.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.AQUA.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.RED.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.LIGHT_PURPLE.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.YELLOW.func_96297_d()), new ScoreCriteria("teamkill." + TextFormatting.WHITE.func_96297_d())};
    public static final ScoreCriteria[] field_197914_n = new ScoreCriteria[]{new ScoreCriteria("killedByTeam." + TextFormatting.BLACK.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.DARK_BLUE.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.DARK_GREEN.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.DARK_AQUA.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.DARK_RED.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.DARK_PURPLE.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.GOLD.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.GRAY.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.DARK_GRAY.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.BLUE.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.GREEN.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.AQUA.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.RED.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.LIGHT_PURPLE.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.YELLOW.func_96297_d()), new ScoreCriteria("killedByTeam." + TextFormatting.WHITE.func_96297_d())};
    private final String field_197915_o;
    private final boolean field_197916_p;
    private final RenderType field_197917_q;

    public ScoreCriteria(String string) {
        this(string, false, RenderType.INTEGER);
    }

    protected ScoreCriteria(String string, boolean bl, RenderType renderType) {
        this.field_197915_o = string;
        this.field_197916_p = bl;
        this.field_197917_q = renderType;
        field_96643_a.put(string, this);
    }

    public static Optional<ScoreCriteria> func_216390_a(String string) {
        if (field_96643_a.containsKey(string)) {
            return Optional.of(field_96643_a.get(string));
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return Optional.empty();
        }
        return Registry.field_212634_w.func_241873_b(ResourceLocation.func_195828_a(string.substring(0, n), '.')).flatMap(statType -> ScoreCriteria.func_216391_a(statType, ResourceLocation.func_195828_a(string.substring(n + 1), '.')));
    }

    private static <T> Optional<ScoreCriteria> func_216391_a(StatType<T> statType, ResourceLocation resourceLocation) {
        return statType.func_199080_a().func_241873_b(resourceLocation).map(statType::func_199076_b);
    }

    public String func_96636_a() {
        return this.field_197915_o;
    }

    public boolean func_96637_b() {
        return this.field_197916_p;
    }

    public RenderType func_178790_c() {
        return this.field_197917_q;
    }

    public static enum RenderType {
        INTEGER("integer"),
        HEARTS("hearts");

        private final String field_211840_c;
        private static final Map<String, RenderType> field_211841_d;

        private RenderType(String string2) {
            this.field_211840_c = string2;
        }

        public String func_211838_a() {
            return this.field_211840_c;
        }

        public static RenderType func_211839_a(String string) {
            return field_211841_d.getOrDefault(string, INTEGER);
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (RenderType renderType : RenderType.values()) {
                builder.put((Object)renderType.field_211840_c, (Object)renderType);
            }
            field_211841_d = builder.build();
        }
    }
}

