/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome.provider;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.MaxMinNoiseMixer;

public class NetherBiomeProvider
extends BiomeProvider {
    private static final Noise field_242596_g = new Noise(-7, (List<Double>)ImmutableList.of((Object)1.0, (Object)1.0));
    public static final MapCodec<NetherBiomeProvider> field_235262_e_ = RecordCodecBuilder.mapCodec(instance2 -> instance2.group((App)Codec.LONG.fieldOf("seed").forGetter(netherBiomeProvider -> netherBiomeProvider.field_235270_m_), (App)RecordCodecBuilder.create(instance -> instance.group((App)Biome.Attributes.field_235104_a_.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.field_235051_b_.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf().fieldOf("biomes").forGetter(netherBiomeProvider -> netherBiomeProvider.field_235268_k_), (App)Noise.field_242609_a.fieldOf("temperature_noise").forGetter(netherBiomeProvider -> netherBiomeProvider.field_242597_h), (App)Noise.field_242609_a.fieldOf("humidity_noise").forGetter(netherBiomeProvider -> netherBiomeProvider.field_242598_i), (App)Noise.field_242609_a.fieldOf("altitude_noise").forGetter(netherBiomeProvider -> netherBiomeProvider.field_242599_j), (App)Noise.field_242609_a.fieldOf("weirdness_noise").forGetter(netherBiomeProvider -> netherBiomeProvider.field_242600_k)).apply((Applicative)instance2, NetherBiomeProvider::new));
    public static final Codec<NetherBiomeProvider> field_235263_f_ = Codec.mapEither(DefaultBuilder.field_242624_a, field_235262_e_).xmap(either -> (NetherBiomeProvider)either.map(DefaultBuilder::func_242635_d, Function.identity()), netherBiomeProvider -> netherBiomeProvider.func_242605_d().map(Either::left).orElseGet(() -> Either.right((Object)netherBiomeProvider))).codec();
    private final Noise field_242597_h;
    private final Noise field_242598_i;
    private final Noise field_242599_j;
    private final Noise field_242600_k;
    private final MaxMinNoiseMixer field_235264_g_;
    private final MaxMinNoiseMixer field_235265_h_;
    private final MaxMinNoiseMixer field_235266_i_;
    private final MaxMinNoiseMixer field_235267_j_;
    private final List<Pair<Biome.Attributes, Supplier<Biome>>> field_235268_k_;
    private final boolean field_235269_l_;
    private final long field_235270_m_;
    private final Optional<Pair<Registry<Biome>, Preset>> field_235271_n_;

    private NetherBiomeProvider(long l, List<Pair<Biome.Attributes, Supplier<Biome>>> list, Optional<Pair<Registry<Biome>, Preset>> optional) {
        this(l, list, field_242596_g, field_242596_g, field_242596_g, field_242596_g, optional);
    }

    private NetherBiomeProvider(long l, List<Pair<Biome.Attributes, Supplier<Biome>>> list, Noise noise, Noise noise2, Noise noise3, Noise noise4) {
        this(l, list, noise, noise2, noise3, noise4, Optional.empty());
    }

    private NetherBiomeProvider(long l, List<Pair<Biome.Attributes, Supplier<Biome>>> list, Noise noise, Noise noise2, Noise noise3, Noise noise4, Optional<Pair<Registry<Biome>, Preset>> optional) {
        super(list.stream().map(Pair::getSecond));
        this.field_235270_m_ = l;
        this.field_235271_n_ = optional;
        this.field_242597_h = noise;
        this.field_242598_i = noise2;
        this.field_242599_j = noise3;
        this.field_242600_k = noise4;
        this.field_235264_g_ = MaxMinNoiseMixer.func_242930_a(new SharedSeedRandom(l), noise.func_242612_a(), noise.func_242614_b());
        this.field_235265_h_ = MaxMinNoiseMixer.func_242930_a(new SharedSeedRandom(l + 1L), noise2.func_242612_a(), noise2.func_242614_b());
        this.field_235266_i_ = MaxMinNoiseMixer.func_242930_a(new SharedSeedRandom(l + 2L), noise3.func_242612_a(), noise3.func_242614_b());
        this.field_235267_j_ = MaxMinNoiseMixer.func_242930_a(new SharedSeedRandom(l + 3L), noise4.func_242612_a(), noise4.func_242614_b());
        this.field_235268_k_ = list;
        this.field_235269_l_ = false;
    }

    @Override
    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return field_235263_f_;
    }

    @Override
    public BiomeProvider func_230320_a_(long l) {
        return new NetherBiomeProvider(l, this.field_235268_k_, this.field_242597_h, this.field_242598_i, this.field_242599_j, this.field_242600_k, this.field_235271_n_);
    }

    private Optional<DefaultBuilder> func_242605_d() {
        return this.field_235271_n_.map(pair -> new DefaultBuilder((Preset)pair.getSecond(), (Registry)pair.getFirst(), this.field_235270_m_));
    }

    @Override
    public Biome func_225526_b_(int n, int n2, int n3) {
        \u2603 = this.field_235269_l_ ? n2 : 0;
        Biome.Attributes attributes = new Biome.Attributes((float)this.field_235264_g_.func_237211_a_(n, \u2603, n3), (float)this.field_235265_h_.func_237211_a_(n, \u2603, n3), (float)this.field_235266_i_.func_237211_a_(n, \u2603, n3), (float)this.field_235267_j_.func_237211_a_(n, \u2603, n3), 0.0f);
        return this.field_235268_k_.stream().min(Comparator.comparing(pair -> Float.valueOf(((Biome.Attributes)pair.getFirst()).func_235110_a_(attributes)))).map(Pair::getSecond).map(Supplier::get).orElse(BiomeRegistry.field_244201_b);
    }

    public boolean func_235280_b_(long l) {
        return this.field_235270_m_ == l && this.field_235271_n_.isPresent() && Objects.equals(this.field_235271_n_.get().getSecond(), Preset.field_235288_b_);
    }

    public static class Preset {
        private static final Map<ResourceLocation, Preset> field_235289_c_ = Maps.newHashMap();
        public static final Preset field_235288_b_ = new Preset(new ResourceLocation("nether"), (Function3<Preset, Registry<Biome>, Long, NetherBiomeProvider>)((Function3)(preset, registry, l) -> new NetherBiomeProvider((long)l, (List)ImmutableList.of((Object)Pair.of((Object)new Biome.Attributes(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> registry.func_243576_d(Biomes.field_235254_j_)), (Object)Pair.of((Object)new Biome.Attributes(0.0f, -0.5f, 0.0f, 0.0f, 0.0f), () -> registry.func_243576_d(Biomes.field_235252_ay_)), (Object)Pair.of((Object)new Biome.Attributes(0.4f, 0.0f, 0.0f, 0.0f, 0.0f), () -> registry.func_243576_d(Biomes.field_235253_az_)), (Object)Pair.of((Object)new Biome.Attributes(0.0f, 0.5f, 0.0f, 0.0f, 0.375f), () -> registry.func_243576_d(Biomes.field_235250_aA_)), (Object)Pair.of((Object)new Biome.Attributes(-0.5f, 0.0f, 0.0f, 0.0f, 0.175f), () -> registry.func_243576_d(Biomes.field_235251_aB_))), Optional.of(Pair.of((Object)registry, (Object)preset)))));
        private final ResourceLocation field_235290_d_;
        private final Function3<Preset, Registry<Biome>, Long, NetherBiomeProvider> field_235291_e_;

        public Preset(ResourceLocation resourceLocation, Function3<Preset, Registry<Biome>, Long, NetherBiomeProvider> function3) {
            this.field_235290_d_ = resourceLocation;
            this.field_235291_e_ = function3;
            field_235289_c_.put(resourceLocation, this);
        }

        public NetherBiomeProvider func_242619_a(Registry<Biome> registry, long l) {
            return (NetherBiomeProvider)this.field_235291_e_.apply((Object)this, registry, (Object)l);
        }
    }

    static final class DefaultBuilder {
        public static final MapCodec<DefaultBuilder> field_242624_a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.field_240908_a_.flatXmap(resourceLocation -> Optional.ofNullable(Preset.field_235289_c_.get(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + resourceLocation))), preset -> DataResult.success((Object)((Preset)preset).field_235290_d_)).fieldOf("preset").stable().forGetter(DefaultBuilder::func_242628_a), (App)RegistryLookupCodec.func_244331_a(Registry.field_239720_u_).forGetter(DefaultBuilder::func_242632_b), (App)Codec.LONG.fieldOf("seed").stable().forGetter(DefaultBuilder::func_242634_c)).apply((Applicative)instance, instance.stable(DefaultBuilder::new)));
        private final Preset field_242625_b;
        private final Registry<Biome> field_242626_c;
        private final long field_242627_d;

        private DefaultBuilder(Preset preset, Registry<Biome> registry, long l) {
            this.field_242625_b = preset;
            this.field_242626_c = registry;
            this.field_242627_d = l;
        }

        public Preset func_242628_a() {
            return this.field_242625_b;
        }

        public Registry<Biome> func_242632_b() {
            return this.field_242626_c;
        }

        public long func_242634_c() {
            return this.field_242627_d;
        }

        public NetherBiomeProvider func_242635_d() {
            return this.field_242625_b.func_242619_a(this.field_242626_c, this.field_242627_d);
        }
    }

    static class Noise {
        private final int field_242610_b;
        private final DoubleList field_242611_c;
        public static final Codec<Noise> field_242609_a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("firstOctave").forGetter(Noise::func_242612_a), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").forGetter(Noise::func_242614_b)).apply((Applicative)instance, Noise::new));

        public Noise(int n, List<Double> list) {
            this.field_242610_b = n;
            this.field_242611_c = new DoubleArrayList(list);
        }

        public int func_242612_a() {
            return this.field_242610_b;
        }

        public DoubleList func_242614_b() {
            return this.field_242611_c;
        }
    }
}

