/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.gen.settings.StructureSpreadSettings;
import net.minecraft.world.server.ServerWorld;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> field_235948_a_;
    protected final BiomeProvider field_222542_c;
    protected final BiomeProvider field_235949_c_;
    private final DimensionStructuresSettings field_222543_d;
    private final long field_235950_e_;
    private final List<ChunkPos> field_235951_f_ = Lists.newArrayList();

    public ChunkGenerator(BiomeProvider biomeProvider, DimensionStructuresSettings dimensionStructuresSettings) {
        this(biomeProvider, biomeProvider, dimensionStructuresSettings, 0L);
    }

    public ChunkGenerator(BiomeProvider biomeProvider, BiomeProvider biomeProvider2, DimensionStructuresSettings dimensionStructuresSettings, long l) {
        this.field_222542_c = biomeProvider;
        this.field_235949_c_ = biomeProvider2;
        this.field_222543_d = dimensionStructuresSettings;
        this.field_235950_e_ = l;
    }

    private void func_235958_g_() {
        if (!this.field_235951_f_.isEmpty()) {
            return;
        }
        StructureSpreadSettings structureSpreadSettings = this.field_222543_d.func_236199_b_();
        if (structureSpreadSettings == null || structureSpreadSettings.func_236663_c_() == 0) {
            return;
        }
        ArrayList \u26032 = Lists.newArrayList();
        for (Biome biome : this.field_222542_c.func_235203_c_()) {
            if (!biome.func_242440_e().func_242493_a(Structure.field_236375_k_)) continue;
            \u26032.add(biome);
        }
        int \u26033 = structureSpreadSettings.func_236660_a_();
        int \u26034 = structureSpreadSettings.func_236663_c_();
        int \u26035 = structureSpreadSettings.func_236662_b_();
        Random \u26036 = new Random();
        \u26036.setSeed(this.field_235950_e_);
        double \u26037 = \u26036.nextDouble() * Math.PI * 2.0;
        int \u26038 = 0;
        int \u26039 = 0;
        for (int i = 0; i < \u26034; ++i) {
            double d = (double)(4 * \u26033 + \u26033 * \u26039 * 6) + (\u26036.nextDouble() - 0.5) * ((double)\u26033 * 2.5);
            int \u260310 = (int)Math.round(Math.cos(\u26037) * d);
            int \u260311 = (int)Math.round(Math.sin(\u26037) * d);
            BlockPos \u260312 = this.field_222542_c.func_225531_a_((\u260310 << 4) + 8, 0, (\u260311 << 4) + 8, 112, \u26032::contains, \u26036);
            if (\u260312 != null) {
                \u260310 = \u260312.func_177958_n() >> 4;
                \u260311 = \u260312.func_177952_p() >> 4;
            }
            this.field_235951_f_.add(new ChunkPos(\u260310, \u260311));
            \u26037 += Math.PI * 2 / (double)\u26035;
            if (++\u26038 != \u26035) continue;
            \u26038 = 0;
            \u26035 += 2 * \u26035 / (++\u26039 + 1);
            \u26035 = Math.min(\u26035, \u26034 - i);
            \u26037 += \u26036.nextDouble() * Math.PI * 2.0;
        }
    }

    protected abstract Codec<? extends ChunkGenerator> func_230347_a_();

    public abstract ChunkGenerator func_230349_a_(long var1);

    public void func_242706_a(Registry<Biome> registry, IChunk iChunk) {
        ChunkPos chunkPos = iChunk.func_76632_l();
        ((ChunkPrimer)iChunk).func_225548_a_(new BiomeContainer(registry, chunkPos, this.field_235949_c_));
    }

    public void func_230350_a_(long l, BiomeManager biomeManager, IChunk iChunk, GenerationStage.Carving carving) {
        BiomeManager biomeManager2 = biomeManager.func_226835_a_(this.field_222542_c);
        SharedSeedRandom \u26032 = new SharedSeedRandom();
        int \u26033 = 8;
        ChunkPos \u26034 = iChunk.func_76632_l();
        int \u26035 = \u26034.field_77276_a;
        int \u26036 = \u26034.field_77275_b;
        BiomeGenerationSettings \u26037 = this.field_222542_c.func_225526_b_(\u26034.field_77276_a << 2, 0, \u26034.field_77275_b << 2).func_242440_e();
        BitSet \u26038 = ((ChunkPrimer)iChunk).func_230345_b_(carving);
        for (int i = \u26035 - 8; i <= \u26035 + 8; ++i) {
            for (\u2603 = \u26036 - 8; \u2603 <= \u26036 + 8; ++\u2603) {
                List<Supplier<ConfiguredCarver<?>>> list = \u26037.func_242489_a(carving);
                ListIterator<Supplier<ConfiguredCarver<?>>> \u26039 = list.listIterator();
                while (\u26039.hasNext()) {
                    int n = \u26039.nextIndex();
                    ConfiguredCarver<?> \u260310 = \u26039.next().get();
                    \u26032.func_202425_c(l + (long)n, i, \u2603);
                    if (!\u260310.func_222730_a(\u26032, i, \u2603)) continue;
                    \u260310.func_227207_a_(iChunk, biomeManager2::func_226836_a_, \u26032, this.func_230356_f_(), i, \u2603, \u26035, \u26036, \u26038);
                }
            }
        }
    }

    @Nullable
    public BlockPos func_235956_a_(ServerWorld serverWorld, Structure<?> structure, BlockPos blockPos, int n, boolean bl) {
        if (!this.field_222542_c.func_205004_a(structure)) {
            return null;
        }
        if (structure == Structure.field_236375_k_) {
            this.func_235958_g_();
            BlockPos \u26034 = null;
            double \u26032 = Double.MAX_VALUE;
            BlockPos.Mutable \u26033 = new BlockPos.Mutable();
            for (ChunkPos chunkPos : this.field_235951_f_) {
                \u26033.func_181079_c((chunkPos.field_77276_a << 4) + 8, 32, (chunkPos.field_77275_b << 4) + 8);
                double d = \u26033.func_177951_i(blockPos);
                if (\u26034 == null) {
                    \u26034 = new BlockPos(\u26033);
                    \u26032 = d;
                    continue;
                }
                if (!(d < \u26032)) continue;
                \u26034 = new BlockPos(\u26033);
                \u26032 = d;
            }
            return \u26034;
        }
        StructureSeparationSettings structureSeparationSettings = this.field_222543_d.func_236197_a_(structure);
        if (structureSeparationSettings == null) {
            return null;
        }
        return structure.func_236388_a_(serverWorld, serverWorld.func_241112_a_(), blockPos, n, bl, serverWorld.func_72905_C(), structureSeparationSettings);
    }

    public void func_230351_a_(WorldGenRegion worldGenRegion, StructureManager structureManager) {
        int n = worldGenRegion.func_201679_a();
        \u2603 = worldGenRegion.func_201680_b();
        \u2603 = n * 16;
        \u2603 = \u2603 * 16;
        BlockPos \u26032 = new BlockPos(\u2603, 0, \u2603);
        Biome \u26033 = this.field_222542_c.func_225526_b_((n << 2) + 2, 2, (\u2603 << 2) + 2);
        SharedSeedRandom \u26034 = new SharedSeedRandom();
        long \u26035 = \u26034.func_202424_a(worldGenRegion.func_72905_C(), \u2603, \u2603);
        try {
            \u26033.func_242427_a(structureManager, this, worldGenRegion, \u26035, \u26034, \u26032);
        }
        catch (Exception \u26036) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26036, "Biome decoration");
            crashReport.func_85058_a("Generation").func_71507_a("CenterX", n).func_71507_a("CenterZ", \u2603).func_71507_a("Seed", \u26035).func_71507_a("Biome", \u26033);
            throw new ReportedException(crashReport);
        }
    }

    public abstract void func_225551_a_(WorldGenRegion var1, IChunk var2);

    public void func_230354_a_(WorldGenRegion worldGenRegion) {
    }

    public DimensionStructuresSettings func_235957_b_() {
        return this.field_222543_d;
    }

    public int func_205470_d() {
        return 64;
    }

    public BiomeProvider func_202090_b() {
        return this.field_235949_c_;
    }

    public int func_230355_e_() {
        return 256;
    }

    public List<MobSpawnInfo.Spawners> func_230353_a_(Biome biome, StructureManager structureManager, EntityClassification entityClassification, BlockPos blockPos) {
        return biome.func_242433_b().func_242559_a(entityClassification);
    }

    public void func_242707_a(DynamicRegistries dynamicRegistries, StructureManager structureManager, IChunk iChunk, TemplateManager templateManager, long l) {
        ChunkPos chunkPos = iChunk.func_76632_l();
        Biome \u26032 = this.field_222542_c.func_225526_b_((chunkPos.field_77276_a << 2) + 2, 0, (chunkPos.field_77275_b << 2) + 2);
        this.func_242705_a(StructureFeatures.field_244145_k, dynamicRegistries, structureManager, iChunk, templateManager, l, chunkPos, \u26032);
        for (Supplier<StructureFeature<?, ?>> supplier : \u26032.func_242440_e().func_242487_a()) {
            this.func_242705_a(supplier.get(), dynamicRegistries, structureManager, iChunk, templateManager, l, chunkPos, \u26032);
        }
    }

    private void func_242705_a(StructureFeature<?, ?> structureFeature, DynamicRegistries dynamicRegistries, StructureManager structureManager, IChunk iChunk, TemplateManager templateManager, long l, ChunkPos chunkPos, Biome biome) {
        StructureStart<?> structureStart = structureManager.func_235013_a_(SectionPos.func_218156_a(iChunk.func_76632_l(), 0), (Structure<?>)structureFeature.field_236268_b_, iChunk);
        int \u26032 = structureStart != null ? structureStart.func_227457_j_() : 0;
        StructureSeparationSettings \u26033 = this.field_222543_d.func_236197_a_((Structure<?>)structureFeature.field_236268_b_);
        if (\u26033 != null) {
            \u2603 = structureFeature.func_242771_a(dynamicRegistries, this, this.field_222542_c, templateManager, l, chunkPos, biome, \u26032, \u26033);
            structureManager.func_235014_a_(SectionPos.func_218156_a(iChunk.func_76632_l(), 0), (Structure<?>)structureFeature.field_236268_b_, \u2603, iChunk);
        }
    }

    public void func_235953_a_(ISeedReader iSeedReader, StructureManager structureManager, IChunk iChunk) {
        int n = 8;
        \u2603 = iChunk.func_76632_l().field_77276_a;
        \u2603 = iChunk.func_76632_l().field_77275_b;
        \u2603 = \u2603 << 4;
        \u2603 = \u2603 << 4;
        SectionPos \u26032 = SectionPos.func_218156_a(iChunk.func_76632_l(), 0);
        for (\u2603 = \u2603 - 8; \u2603 <= \u2603 + 8; ++\u2603) {
            for (\u2603 = \u2603 - 8; \u2603 <= \u2603 + 8; ++\u2603) {
                long l = ChunkPos.func_77272_a(\u2603, \u2603);
                for (StructureStart<?> structureStart : iSeedReader.func_212866_a_(\u2603, \u2603).func_201609_c().values()) {
                    try {
                        if (structureStart == StructureStart.field_214630_a || !structureStart.func_75071_a().func_78885_a(\u2603, \u2603, \u2603 + 15, \u2603 + 15)) continue;
                        structureManager.func_235012_a_(\u26032, structureStart.func_214627_k(), l, iChunk);
                        DebugPacketSender.func_218804_a(iSeedReader, structureStart);
                    }
                    catch (Exception exception) {
                        CrashReport crashReport = CrashReport.func_85055_a(exception, "Generating structure reference");
                        CrashReportCategory \u26033 = crashReport.func_85058_a("Structure");
                        \u26033.func_189529_a("Id", () -> Registry.field_218361_B.func_177774_c(structureStart.func_214627_k()).toString());
                        \u26033.func_189529_a("Name", () -> structureStart.func_214627_k().func_143025_a());
                        \u26033.func_189529_a("Class", () -> structureStart.func_214627_k().getClass().getCanonicalName());
                        throw new ReportedException(crashReport);
                    }
                }
            }
        }
    }

    public abstract void func_230352_b_(IWorld var1, StructureManager var2, IChunk var3);

    public int func_230356_f_() {
        return 63;
    }

    public abstract int func_222529_a(int var1, int var2, Heightmap.Type var3);

    public abstract IBlockReader func_230348_a_(int var1, int var2);

    public int func_222532_b(int n, int n2, Heightmap.Type type) {
        return this.func_222529_a(n, n2, type);
    }

    public int func_222531_c(int n, int n2, Heightmap.Type type) {
        return this.func_222529_a(n, n2, type) - 1;
    }

    public boolean func_235952_a_(ChunkPos chunkPos) {
        this.func_235958_g_();
        return this.field_235951_f_.contains(chunkPos);
    }

    static {
        Registry.func_218325_a(Registry.field_239690_aB_, "noise", NoiseChunkGenerator.field_236079_d_);
        Registry.func_218325_a(Registry.field_239690_aB_, "flat", FlatChunkGenerator.field_236069_d_);
        Registry.func_218325_a(Registry.field_239690_aB_, "debug", DebugChunkGenerator.field_236066_e_);
        field_235948_a_ = Registry.field_239690_aB_.dispatchStable(ChunkGenerator::func_230347_a_, Function.identity());
    }
}

