/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.FillLayerConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlatGenerationSettings {
    private static final Logger field_211404_q = LogManager.getLogger();
    public static final Codec<FlatGenerationSettings> field_236932_a_ = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a(Registry.field_239720_u_).forGetter(flatGenerationSettings -> flatGenerationSettings.field_242867_d), (App)DimensionStructuresSettings.field_236190_a_.fieldOf("structures").forGetter(FlatGenerationSettings::func_236943_d_), (App)FlatLayerInfo.field_236929_a_.listOf().fieldOf("layers").forGetter(FlatGenerationSettings::func_82650_c), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(flatGenerationSettings -> flatGenerationSettings.field_236935_l_), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(flatGenerationSettings -> flatGenerationSettings.field_236934_k_), (App)Biome.field_235051_b_.optionalFieldOf("biome").orElseGet(Optional::empty).forGetter(flatGenerationSettings -> Optional.of(flatGenerationSettings.field_82654_c))).apply((Applicative)instance, FlatGenerationSettings::new)).stable();
    private static final Map<Structure<?>, StructureFeature<?, ?>> field_202247_j = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put(Structure.field_236367_c_, StructureFeatures.field_244136_b);
        hashMap.put(Structure.field_236381_q_, StructureFeatures.field_244154_t);
        hashMap.put(Structure.field_236375_k_, StructureFeatures.field_244145_k);
        hashMap.put(Structure.field_236374_j_, StructureFeatures.field_244144_j);
        hashMap.put(Structure.field_236370_f_, StructureFeatures.field_244140_f);
        hashMap.put(Structure.field_236369_e_, StructureFeatures.field_244139_e);
        hashMap.put(Structure.field_236371_g_, StructureFeatures.field_244141_g);
        hashMap.put(Structure.field_236377_m_, StructureFeatures.field_244147_m);
        hashMap.put(Structure.field_236373_i_, StructureFeatures.field_244142_h);
        hashMap.put(Structure.field_236376_l_, StructureFeatures.field_244146_l);
        hashMap.put(Structure.field_236379_o_, StructureFeatures.field_244151_q);
        hashMap.put(Structure.field_236368_d_, StructureFeatures.field_244138_d);
        hashMap.put(Structure.field_236378_n_, StructureFeatures.field_244149_o);
        hashMap.put(Structure.field_236366_b_, StructureFeatures.field_244135_a);
        hashMap.put(Structure.field_236372_h_, StructureFeatures.field_244159_y);
        hashMap.put(Structure.field_236383_s_, StructureFeatures.field_244153_s);
    });
    private final Registry<Biome> field_242867_d;
    private final DimensionStructuresSettings field_236933_f_;
    private final List<FlatLayerInfo> field_82655_a = Lists.newArrayList();
    private Supplier<Biome> field_82654_c;
    private final BlockState[] field_202244_C = new BlockState[256];
    private boolean field_202245_D;
    private boolean field_236934_k_ = false;
    private boolean field_236935_l_ = false;

    public FlatGenerationSettings(Registry<Biome> registry, DimensionStructuresSettings dimensionStructuresSettings, List<FlatLayerInfo> list, boolean bl, boolean bl2, Optional<Supplier<Biome>> optional) {
        this(dimensionStructuresSettings, registry);
        if (bl) {
            this.func_236941_b_();
        }
        if (bl2) {
            this.func_236936_a_();
        }
        this.field_82655_a.addAll(list);
        this.func_82645_d();
        if (!optional.isPresent()) {
            field_211404_q.error("Unknown biome, defaulting to plains");
            this.field_82654_c = () -> registry.func_243576_d(Biomes.field_76772_c);
        } else {
            this.field_82654_c = optional.get();
        }
    }

    public FlatGenerationSettings(DimensionStructuresSettings dimensionStructuresSettings, Registry<Biome> registry) {
        this.field_242867_d = registry;
        this.field_236933_f_ = dimensionStructuresSettings;
        this.field_82654_c = () -> registry.func_243576_d(Biomes.field_76772_c);
    }

    public FlatGenerationSettings func_236937_a_(DimensionStructuresSettings dimensionStructuresSettings) {
        return this.func_241527_a_(this.field_82655_a, dimensionStructuresSettings);
    }

    public FlatGenerationSettings func_241527_a_(List<FlatLayerInfo> list, DimensionStructuresSettings dimensionStructuresSettings) {
        FlatGenerationSettings flatGenerationSettings = new FlatGenerationSettings(dimensionStructuresSettings, this.field_242867_d);
        for (FlatLayerInfo flatLayerInfo : list) {
            flatGenerationSettings.field_82655_a.add(new FlatLayerInfo(flatLayerInfo.func_82657_a(), flatLayerInfo.func_175900_c().func_177230_c()));
            flatGenerationSettings.func_82645_d();
        }
        flatGenerationSettings.func_242870_a(this.field_82654_c);
        if (this.field_236934_k_) {
            flatGenerationSettings.func_236936_a_();
        }
        if (this.field_236935_l_) {
            flatGenerationSettings.func_236941_b_();
        }
        return flatGenerationSettings;
    }

    public void func_236936_a_() {
        this.field_236934_k_ = true;
    }

    public void func_236941_b_() {
        this.field_236935_l_ = true;
    }

    public Biome func_236942_c_() {
        boolean bl;
        Biome biome = this.func_82648_a();
        BiomeGenerationSettings \u26032 = biome.func_242440_e();
        BiomeGenerationSettings.Builder \u26033 = new BiomeGenerationSettings.Builder().func_242519_a(\u26032.func_242500_d());
        if (this.field_236935_l_) {
            \u26033.func_242513_a(GenerationStage.Decoration.LAKES, Features.field_243789_O);
            \u26033.func_242513_a(GenerationStage.Decoration.LAKES, Features.field_243790_P);
        }
        for (Map.Entry<Structure<?>, StructureSeparationSettings> entry : this.field_236933_f_.func_236195_a_().entrySet()) {
            \u26033.func_242516_a(\u26032.func_242491_a(field_202247_j.get(entry.getKey())));
        }
        boolean bl2 = bl = (!this.field_202245_D || this.field_242867_d.func_230519_c_(biome).equals(Optional.of(Biomes.field_185440_P))) && this.field_236934_k_;
        if (bl) {
            List<List<Supplier<ConfiguredFeature<?, ?>>>> list = \u26032.func_242498_c();
            for (int n = 0; n < list.size(); ++n) {
                if (n == GenerationStage.Decoration.UNDERGROUND_STRUCTURES.ordinal() || n == GenerationStage.Decoration.SURFACE_STRUCTURES.ordinal()) continue;
                List<Supplier<ConfiguredFeature<?, ?>>> list2 = list.get(n);
                for (Supplier<ConfiguredFeature<?, ?>> supplier : list2) {
                    \u26033.func_242510_a(n, supplier);
                }
            }
        }
        BlockState[] blockStateArray = this.func_202233_q();
        for (int i = 0; i < blockStateArray.length; ++i) {
            BlockState object = blockStateArray[i];
            if (object == null || Heightmap.Type.MOTION_BLOCKING.func_222684_d().test(object)) continue;
            this.field_202244_C[i] = null;
            \u26033.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, Feature.field_214486_aN.func_225566_b_(new FillLayerConfig(i, object)));
        }
        return new Biome.Builder().func_205415_a(biome.func_201851_b()).func_205419_a(biome.func_201856_r()).func_205421_a(biome.func_185355_j()).func_205420_b(biome.func_185360_m()).func_205414_c(biome.func_242445_k()).func_205417_d(biome.func_76727_i()).func_235097_a_(biome.func_235089_q_()).func_242457_a(\u26033.func_242508_a()).func_242458_a(biome.func_242433_b()).func_242455_a();
    }

    public DimensionStructuresSettings func_236943_d_() {
        return this.field_236933_f_;
    }

    public Biome func_82648_a() {
        return this.field_82654_c.get();
    }

    public void func_242870_a(Supplier<Biome> supplier) {
        this.field_82654_c = supplier;
    }

    public List<FlatLayerInfo> func_82650_c() {
        return this.field_82655_a;
    }

    public BlockState[] func_202233_q() {
        return this.field_202244_C;
    }

    public void func_82645_d() {
        Arrays.fill(this.field_202244_C, 0, this.field_202244_C.length, null);
        int n = 0;
        for (FlatLayerInfo flatLayerInfo : this.field_82655_a) {
            flatLayerInfo.func_82660_d(n);
            n += flatLayerInfo.func_82657_a();
        }
        this.field_202245_D = true;
        for (FlatLayerInfo flatLayerInfo : this.field_82655_a) {
            for (int i = flatLayerInfo.func_82656_d(); i < flatLayerInfo.func_82656_d() + flatLayerInfo.func_82657_a(); ++i) {
                BlockState blockState = flatLayerInfo.func_175900_c();
                if (blockState.func_203425_a(Blocks.field_150350_a)) continue;
                this.field_202245_D = false;
                this.field_202244_C[i] = blockState;
            }
        }
    }

    public static FlatGenerationSettings func_242869_a(Registry<Biome> registry) {
        DimensionStructuresSettings dimensionStructuresSettings = new DimensionStructuresSettings(Optional.of(DimensionStructuresSettings.field_236192_c_), Maps.newHashMap((Map)ImmutableMap.of(Structure.field_236381_q_, (Object)DimensionStructuresSettings.field_236191_b_.get(Structure.field_236381_q_))));
        FlatGenerationSettings \u26032 = new FlatGenerationSettings(dimensionStructuresSettings, registry);
        \u26032.field_82654_c = () -> registry.func_243576_d(Biomes.field_76772_c);
        \u26032.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_150357_h));
        \u26032.func_82650_c().add(new FlatLayerInfo(2, Blocks.field_150346_d));
        \u26032.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_196658_i));
        \u26032.func_82645_d();
        return \u26032;
    }
}

