/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.OceanMonumentPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OceanMonumentStructure
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> field_175803_h = ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200761_A, 1, 2, 4));

    public OceanMonumentStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Override
    protected boolean func_230365_b_() {
        return false;
    }

    @Override
    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider2, long l, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome, ChunkPos chunkPos, NoFeatureConfig noFeatureConfig) {
        BiomeProvider biomeProvider2;
        Set<Biome> set = biomeProvider2.func_225530_a_(n * 16 + 9, chunkGenerator.func_230356_f_(), n2 * 16 + 9, 16);
        for (Biome biome2 : set) {
            if (biome2.func_242440_e().func_242493_a(this)) continue;
            return false;
        }
        Set<Biome> \u26032 = biomeProvider2.func_225530_a_(n * 16 + 9, chunkGenerator.func_230356_f_(), n2 * 16 + 9, 29);
        for (Biome biome3 : \u26032) {
            if (biome3.func_201856_r() == Biome.Category.OCEAN || biome3.func_201856_r() == Biome.Category.RIVER) continue;
            return false;
        }
        return true;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    @Override
    public List<MobSpawnInfo.Spawners> func_202279_e() {
        return field_175803_h;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        private boolean field_175790_d;

        public Start(Structure<NoFeatureConfig> structure, int n, int n2, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_230364_a_(DynamicRegistries dynamicRegistries, ChunkGenerator chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome, NoFeatureConfig noFeatureConfig) {
            this.func_214633_b(n, n2);
        }

        private void func_214633_b(int n, int n2) {
            \u2603 = n * 16 - 29;
            \u2603 = n2 * 16 - 29;
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(this.field_214631_d);
            this.field_75075_a.add(new OceanMonumentPieces.MonumentBuilding(this.field_214631_d, \u2603, \u2603, direction));
            this.func_202500_a();
            this.field_175790_d = true;
        }

        @Override
        public void func_230366_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            if (!this.field_175790_d) {
                this.field_75075_a.clear();
                this.func_214633_b(this.func_143019_e(), this.func_143018_f());
            }
            super.func_230366_a_(iSeedReader, structureManager, chunkGenerator, random, mutableBoundingBox, chunkPos);
        }
    }
}

