/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OceanRuinPieces {
    private static final ResourceLocation[] field_204058_G = new ResourceLocation[]{new ResourceLocation("underwater_ruin/warm_1"), new ResourceLocation("underwater_ruin/warm_2"), new ResourceLocation("underwater_ruin/warm_3"), new ResourceLocation("underwater_ruin/warm_4"), new ResourceLocation("underwater_ruin/warm_5"), new ResourceLocation("underwater_ruin/warm_6"), new ResourceLocation("underwater_ruin/warm_7"), new ResourceLocation("underwater_ruin/warm_8")};
    private static final ResourceLocation[] field_204059_H = new ResourceLocation[]{new ResourceLocation("underwater_ruin/brick_1"), new ResourceLocation("underwater_ruin/brick_2"), new ResourceLocation("underwater_ruin/brick_3"), new ResourceLocation("underwater_ruin/brick_4"), new ResourceLocation("underwater_ruin/brick_5"), new ResourceLocation("underwater_ruin/brick_6"), new ResourceLocation("underwater_ruin/brick_7"), new ResourceLocation("underwater_ruin/brick_8")};
    private static final ResourceLocation[] field_204053_B = new ResourceLocation[]{new ResourceLocation("underwater_ruin/cracked_1"), new ResourceLocation("underwater_ruin/cracked_2"), new ResourceLocation("underwater_ruin/cracked_3"), new ResourceLocation("underwater_ruin/cracked_4"), new ResourceLocation("underwater_ruin/cracked_5"), new ResourceLocation("underwater_ruin/cracked_6"), new ResourceLocation("underwater_ruin/cracked_7"), new ResourceLocation("underwater_ruin/cracked_8")};
    private static final ResourceLocation[] field_204061_J = new ResourceLocation[]{new ResourceLocation("underwater_ruin/mossy_1"), new ResourceLocation("underwater_ruin/mossy_2"), new ResourceLocation("underwater_ruin/mossy_3"), new ResourceLocation("underwater_ruin/mossy_4"), new ResourceLocation("underwater_ruin/mossy_5"), new ResourceLocation("underwater_ruin/mossy_6"), new ResourceLocation("underwater_ruin/mossy_7"), new ResourceLocation("underwater_ruin/mossy_8")};
    private static final ResourceLocation[] field_204062_K = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_brick_1"), new ResourceLocation("underwater_ruin/big_brick_2"), new ResourceLocation("underwater_ruin/big_brick_3"), new ResourceLocation("underwater_ruin/big_brick_8")};
    private static final ResourceLocation[] field_204066_O = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_mossy_1"), new ResourceLocation("underwater_ruin/big_mossy_2"), new ResourceLocation("underwater_ruin/big_mossy_3"), new ResourceLocation("underwater_ruin/big_mossy_8")};
    private static final ResourceLocation[] field_204070_S = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_cracked_1"), new ResourceLocation("underwater_ruin/big_cracked_2"), new ResourceLocation("underwater_ruin/big_cracked_3"), new ResourceLocation("underwater_ruin/big_cracked_8")};
    private static final ResourceLocation[] field_204049_ab = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_warm_4"), new ResourceLocation("underwater_ruin/big_warm_5"), new ResourceLocation("underwater_ruin/big_warm_6"), new ResourceLocation("underwater_ruin/big_warm_7")};

    private static ResourceLocation func_204042_a(Random random) {
        return Util.func_240989_a_(field_204058_G, random);
    }

    private static ResourceLocation func_204043_b(Random random) {
        return Util.func_240989_a_(field_204049_ab, random);
    }

    public static void func_204041_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, List<StructurePiece> list, Random random, OceanRuinConfig oceanRuinConfig) {
        boolean bl = random.nextFloat() <= oceanRuinConfig.field_204032_b;
        float \u26032 = bl ? 0.9f : 0.8f;
        OceanRuinPieces.func_204045_a(templateManager, blockPos, rotation, list, random, oceanRuinConfig, bl, \u26032);
        if (bl && random.nextFloat() <= oceanRuinConfig.field_204033_c) {
            OceanRuinPieces.func_204047_a(templateManager, random, rotation, blockPos, oceanRuinConfig, list);
        }
    }

    private static void func_204047_a(TemplateManager templateManager, Random random, Rotation rotation, BlockPos blockPos, OceanRuinConfig oceanRuinConfig, List<StructurePiece> list) {
        int n = blockPos.func_177958_n();
        \u2603 = blockPos.func_177952_p();
        BlockPos \u26032 = Template.func_207669_a(new BlockPos(15, 0, 15), Mirror.NONE, rotation, BlockPos.field_177992_a).func_177982_a(n, 0, \u2603);
        MutableBoundingBox \u26033 = MutableBoundingBox.func_175899_a(n, 0, \u2603, \u26032.func_177958_n(), 0, \u26032.func_177952_p());
        BlockPos \u26034 = new BlockPos(Math.min(n, \u26032.func_177958_n()), 0, Math.min(\u2603, \u26032.func_177952_p()));
        List<BlockPos> \u26035 = OceanRuinPieces.func_204044_a(random, \u26034.func_177958_n(), \u26034.func_177952_p());
        \u2603 = MathHelper.func_76136_a(random, 4, 8);
        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
            if (\u26035.isEmpty() || (\u2603 = MutableBoundingBox.func_175899_a(\u2603 = (\u2603 = \u26035.remove(\u2603 = random.nextInt(\u26035.size()))).func_177958_n(), 0, \u2603 = \u2603.func_177952_p(), (\u2603 = Template.func_207669_a(new BlockPos(5, 0, 6), Mirror.NONE, \u2603 = Rotation.func_222466_a(random), BlockPos.field_177992_a).func_177982_a(\u2603, 0, \u2603)).func_177958_n(), 0, \u2603.func_177952_p())).func_78884_a(\u26033)) continue;
            OceanRuinPieces.func_204045_a(templateManager, \u2603, \u2603, list, random, oceanRuinConfig, false, 0.8f);
        }
    }

    private static List<BlockPos> func_204044_a(Random random, int n, int n2) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new BlockPos(n - 16 + MathHelper.func_76136_a(random, 1, 8), 90, n2 + 16 + MathHelper.func_76136_a(random, 1, 7)));
        arrayList.add(new BlockPos(n - 16 + MathHelper.func_76136_a(random, 1, 8), 90, n2 + MathHelper.func_76136_a(random, 1, 7)));
        arrayList.add(new BlockPos(n - 16 + MathHelper.func_76136_a(random, 1, 8), 90, n2 - 16 + MathHelper.func_76136_a(random, 4, 8)));
        arrayList.add(new BlockPos(n + MathHelper.func_76136_a(random, 1, 7), 90, n2 + 16 + MathHelper.func_76136_a(random, 1, 7)));
        arrayList.add(new BlockPos(n + MathHelper.func_76136_a(random, 1, 7), 90, n2 - 16 + MathHelper.func_76136_a(random, 4, 6)));
        arrayList.add(new BlockPos(n + 16 + MathHelper.func_76136_a(random, 1, 7), 90, n2 + 16 + MathHelper.func_76136_a(random, 3, 8)));
        arrayList.add(new BlockPos(n + 16 + MathHelper.func_76136_a(random, 1, 7), 90, n2 + MathHelper.func_76136_a(random, 1, 7)));
        arrayList.add(new BlockPos(n + 16 + MathHelper.func_76136_a(random, 1, 7), 90, n2 - 16 + MathHelper.func_76136_a(random, 4, 8)));
        return arrayList;
    }

    private static void func_204045_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, List<StructurePiece> list, Random random, OceanRuinConfig oceanRuinConfig2, boolean bl, float f) {
        OceanRuinConfig oceanRuinConfig2;
        if (oceanRuinConfig2.field_204031_a == OceanRuinStructure.Type.WARM) {
            ResourceLocation resourceLocation = bl ? OceanRuinPieces.func_204043_b(random) : OceanRuinPieces.func_204042_a(random);
            list.add(new Piece(templateManager, resourceLocation, blockPos, rotation, f, oceanRuinConfig2.field_204031_a, bl));
        } else if (oceanRuinConfig2.field_204031_a == OceanRuinStructure.Type.COLD) {
            ResourceLocation[] resourceLocationArray = bl ? field_204062_K : field_204059_H;
            \u2603 = bl ? field_204070_S : field_204053_B;
            \u2603 = bl ? field_204066_O : field_204061_J;
            int \u26032 = random.nextInt(resourceLocationArray.length);
            list.add(new Piece(templateManager, resourceLocationArray[\u26032], blockPos, rotation, f, oceanRuinConfig2.field_204031_a, bl));
            list.add(new Piece(templateManager, \u2603[\u26032], blockPos, rotation, 0.7f, oceanRuinConfig2.field_204031_a, bl));
            list.add(new Piece(templateManager, \u2603[\u26032], blockPos, rotation, 0.5f, oceanRuinConfig2.field_204031_a, bl));
        }
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final OceanRuinStructure.Type field_204036_d;
        private final float field_204037_e;
        private final ResourceLocation field_204038_f;
        private final Rotation field_204039_g;
        private final boolean field_204040_h;

        public Piece(TemplateManager templateManager, ResourceLocation resourceLocation, BlockPos blockPos, Rotation rotation, float f, OceanRuinStructure.Type type, boolean bl) {
            super(IStructurePieceType.field_214763_J, 0);
            this.field_204038_f = resourceLocation;
            this.field_186178_c = blockPos;
            this.field_204039_g = rotation;
            this.field_204037_e = f;
            this.field_204036_d = type;
            this.field_204040_h = bl;
            this.func_204034_a(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214763_J, compoundNBT);
            this.field_204038_f = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.field_204039_g = Rotation.valueOf(compoundNBT.func_74779_i("Rot"));
            this.field_204037_e = compoundNBT.func_74760_g("Integrity");
            this.field_204036_d = OceanRuinStructure.Type.valueOf(compoundNBT.func_74779_i("BiomeType"));
            this.field_204040_h = compoundNBT.func_74767_n("IsLarge");
            this.func_204034_a(templateManager);
        }

        private void func_204034_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.field_204038_f);
            PlacementSettings \u26032 = new PlacementSettings().func_186220_a(this.field_204039_g).func_186214_a(Mirror.NONE).func_215222_a(BlockIgnoreStructureProcessor.field_215206_c);
            this.func_186173_a(template, this.field_186178_c, \u26032);
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74778_a("Template", this.field_204038_f.toString());
            compoundNBT.func_74778_a("Rot", this.field_204039_g.name());
            compoundNBT.func_74776_a("Integrity", this.field_204037_e);
            compoundNBT.func_74778_a("BiomeType", this.field_204036_d.toString());
            compoundNBT.func_74757_a("IsLarge", this.field_204040_h);
        }

        @Override
        protected void func_186175_a(String string2, BlockPos blockPos, IServerWorld iServerWorld, Random random, MutableBoundingBox mutableBoundingBox) {
            String string2;
            if ("chest".equals(string2)) {
                iServerWorld.func_180501_a(blockPos, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a(ChestBlock.field_204511_c, iServerWorld.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a)), 2);
                TileEntity tileEntity = iServerWorld.func_175625_s(blockPos);
                if (tileEntity instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileEntity).func_189404_a(this.field_204040_h ? LootTables.field_204115_q : LootTables.field_204114_p, random.nextLong());
                }
            } else if ("drowned".equals(string2)) {
                DrownedEntity drownedEntity = EntityType.field_204724_o.func_200721_a(iServerWorld.func_201672_e());
                drownedEntity.func_110163_bv();
                drownedEntity.func_174828_a(blockPos, 0.0f, 0.0f);
                drownedEntity.func_213386_a(iServerWorld, iServerWorld.func_175649_E(blockPos), SpawnReason.STRUCTURE, null, null);
                iServerWorld.func_242417_l(drownedEntity);
                if (blockPos.func_177956_o() > iServerWorld.func_181545_F()) {
                    iServerWorld.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                } else {
                    iServerWorld.func_180501_a(blockPos, Blocks.field_150355_j.func_176223_P(), 2);
                }
            }
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.field_186177_b.func_215219_b().func_215222_a(new IntegrityProcessor(this.field_204037_e)).func_215222_a(BlockIgnoreStructureProcessor.field_215206_c);
            int n = iSeedReader.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, this.field_186178_c.func_177958_n(), this.field_186178_c.func_177952_p());
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), n, this.field_186178_c.func_177952_p());
            BlockPos \u26032 = Template.func_207669_a(new BlockPos(this.field_186176_a.func_186259_a().func_177958_n() - 1, 0, this.field_186176_a.func_186259_a().func_177952_p() - 1), Mirror.NONE, this.field_204039_g, BlockPos.field_177992_a).func_177971_a(this.field_186178_c);
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), this.func_204035_a(this.field_186178_c, iSeedReader, \u26032), this.field_186178_c.func_177952_p());
            return super.func_230383_a_(iSeedReader, structureManager, chunkGenerator, random, mutableBoundingBox, chunkPos, blockPos);
        }

        private int func_204035_a(BlockPos blockPos, IBlockReader iBlockReader, BlockPos blockPos2) {
            int n = blockPos.func_177956_o();
            \u2603 = 512;
            \u2603 = n - 1;
            \u2603 = 0;
            for (BlockPos blockPos3 : BlockPos.func_218278_a(blockPos, blockPos2)) {
                int n2 = blockPos3.func_177958_n();
                \u2603 = blockPos3.func_177952_p();
                \u2603 = blockPos.func_177956_o() - 1;
                BlockPos.Mutable \u26032 = new BlockPos.Mutable(n2, \u2603, \u2603);
                BlockState \u26033 = iBlockReader.func_180495_p(\u26032);
                FluidState \u26034 = iBlockReader.func_204610_c(\u26032);
                while ((\u26033.func_196958_f() || \u26034.func_206884_a(FluidTags.field_206959_a) || \u26033.func_177230_c().func_203417_a(BlockTags.field_205213_E)) && \u2603 > 1) {
                    \u26032.func_181079_c(n2, --\u2603, \u2603);
                    \u26033 = iBlockReader.func_180495_p(\u26032);
                    \u26034 = iBlockReader.func_204610_c(\u26032);
                }
                \u2603 = Math.min(\u2603, \u2603);
                if (\u2603 >= \u2603 - 2) continue;
                ++\u2603;
            }
            \u2603 = Math.abs(blockPos.func_177958_n() - blockPos2.func_177958_n());
            if (\u2603 - \u2603 > 2 && \u2603 > \u2603 - 2) {
                n = \u2603 + 1;
            }
            return n;
        }
    }
}

