/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.util.Optional;
import net.minecraftforge.eventbus.LogMarkers;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EventSubclassTransformer {
    private static final Logger LOGGER = LogManager.getLogger();

    public Optional<ClassNode> transform(ClassNode classNode, Type classType) {
        try {
            if (!this.buildEvents(classNode)) {
                return Optional.empty();
            }
        }
        catch (Exception e) {
            LOGGER.error(LogMarkers.EVENTBUS, "An error occurred building event handler", (Throwable)e);
        }
        return Optional.of(classNode);
    }

    private boolean buildEvents(ClassNode classNode) throws Exception {
        MethodNode method;
        Class<?> parent = null;
        try {
            parent = Thread.currentThread().getContextClassLoader().loadClass(classNode.superName.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(LogMarkers.EVENTBUS, "Could not find parent {} for class {} in classloader {} on thread {}", (Object)classNode.superName, (Object)classNode.name, (Object)Thread.currentThread().getContextClassLoader(), (Object)Thread.currentThread());
            throw e;
        }
        if (!Event.class.isAssignableFrom(parent)) {
            return false;
        }
        LOGGER.debug(LogMarkers.EVENTBUS, "Event transform begin: {}", (Object)classNode.name);
        Type tList = Type.getType((String)"Lnet/minecraftforge/eventbus/ListenerList;");
        Type tHelper = Type.getType((String)"Lnet/minecraftforge/eventbus/api/EventListenerHelper;");
        boolean hasGetListenerList = false;
        boolean hasDefaultCtr = false;
        boolean hasCancelable = false;
        boolean hasResult = false;
        String voidDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
        String boolDesc = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
        String listDesc = tList.getDescriptor();
        String listDescM = Type.getMethodDescriptor((Type)tList, (Type[])new Type[0]);
        String listInitDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{tList});
        String helperGetDesc = Type.getMethodDescriptor((Type)tList, (Type[])new Type[]{Type.getType(Class.class)});
        for (MethodNode method2 : classNode.methods) {
            if ((method2.access & 1) == 1) {
                if (method2.name.equals("getListenerList") && method2.desc.equals(listDescM)) {
                    hasGetListenerList = true;
                }
                if (method2.name.equals("isCancelable") && method2.desc.equals(boolDesc)) {
                    hasCancelable = true;
                }
                if (method2.name.equals("hasResult") && method2.desc.equals(boolDesc)) {
                    hasResult = true;
                }
            }
            if (!method2.name.equals("<init>") || !method2.desc.equals(voidDesc)) continue;
            hasDefaultCtr = true;
        }
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode node : classNode.visibleAnnotations) {
                if (!hasResult && node.desc.equals("Lnet/minecraftforge/eventbus/api/Event$HasResult;")) {
                    method = new MethodNode(1, "hasResult", boolDesc, null, null);
                    method.instructions.add((AbstractInsnNode)new InsnNode(4));
                    method.instructions.add((AbstractInsnNode)new InsnNode(172));
                    classNode.methods.add(method);
                    continue;
                }
                if (hasCancelable || !node.desc.equals("Lnet/minecraftforge/eventbus/api/Cancelable;")) continue;
                method = new MethodNode(1, "isCancelable", boolDesc, null, null);
                method.instructions.add((AbstractInsnNode)new InsnNode(4));
                method.instructions.add((AbstractInsnNode)new InsnNode(172));
                classNode.methods.add(method);
            }
        }
        Type tThis = Type.getObjectType((String)classNode.name);
        Type tSuper = Type.getObjectType((String)classNode.superName);
        if (!hasDefaultCtr) {
            method = new MethodNode(1, "<init>", voidDesc, null, null);
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "<init>", voidDesc, false));
            method.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(method);
        }
        if (hasGetListenerList) {
            LOGGER.debug(LogMarkers.EVENTBUS, "Transforming event complete - already done: {}", (Object)classNode.name);
            return true;
        }
        classNode.fields.add(new FieldNode(26, "LISTENER_LIST", listDesc, null, null));
        InsnList clinit = new InsnList();
        clinit.add((AbstractInsnNode)new TypeInsnNode(187, tList.getInternalName()));
        clinit.add((AbstractInsnNode)new InsnNode(89));
        clinit.add((AbstractInsnNode)new LdcInsnNode((Object)tThis));
        clinit.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Class", "getSuperclass", "()Ljava/lang/Class;", false));
        clinit.add((AbstractInsnNode)new MethodInsnNode(184, tHelper.getInternalName(), "getListenerList", helperGetDesc, false));
        clinit.add((AbstractInsnNode)new MethodInsnNode(183, tList.getInternalName(), "<init>", listInitDesc, false));
        clinit.add((AbstractInsnNode)new FieldInsnNode(179, tThis.getInternalName(), "LISTENER_LIST", tList.getDescriptor()));
        MethodNode method3 = classNode.methods.stream().filter(m -> "<clinit>".equals(m.name) && voidDesc.equals(m.desc)).findFirst().orElse(null);
        if (method3 == null) {
            method3 = new MethodNode(8, "<clinit>", voidDesc, null, null);
            method3.instructions.add(clinit);
            method3.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(method3);
        } else {
            method3.instructions.insert(clinit);
        }
        method3 = new MethodNode(1, "getListenerList", listDescM, null, null);
        method3.instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, "LISTENER_LIST", listDesc));
        method3.instructions.add((AbstractInsnNode)new InsnNode(176));
        classNode.methods.add(method3);
        LOGGER.debug(LogMarkers.EVENTBUS, "Event transform complete: {}", (Object)classNode.name);
        return true;
    }
}

