/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTypes;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompoundNBT
implements INBT {
    public static final Codec<CompoundNBT> field_240597_a_ = Codec.PASSTHROUGH.comapFlatMap(p_240598_0_ -> {
        INBT inbt = (INBT)p_240598_0_.convert((DynamicOps)NBTDynamicOps.field_210820_a).getValue();
        return inbt instanceof CompoundNBT ? DataResult.success((Object)((CompoundNBT)inbt)) : DataResult.error((String)("Not a compound tag: " + inbt));
    }, p_240599_0_ -> new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, p_240599_0_));
    private static final Logger field_191551_b = LogManager.getLogger();
    private static final Pattern field_193583_c = Pattern.compile("[A-Za-z0-9._+-]+");
    public static final INBTType<CompoundNBT> field_229675_a_ = new INBTType<CompoundNBT>(){

        public CompoundNBT func_225649_b_(DataInput p_225649_1_, int p_225649_2_, NBTSizeTracker p_225649_3_) throws IOException {
            byte b0;
            p_225649_3_.func_152450_a(384L);
            if (p_225649_2_ > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            HashMap map = Maps.newHashMap();
            while ((b0 = CompoundNBT.func_152447_a(p_225649_1_, p_225649_3_)) != 0) {
                String s = CompoundNBT.func_152448_b(p_225649_1_, p_225649_3_);
                p_225649_3_.func_152450_a(224 + 16 * s.length());
                p_225649_3_.func_152450_a(32L);
                INBT inbt = CompoundNBT.func_229680_b_(NBTTypes.func_229710_a_((int)b0), s, p_225649_1_, p_225649_2_ + 1, p_225649_3_);
                if (map.put(s, inbt) == null) continue;
                p_225649_3_.func_152450_a(288L);
            }
            return new CompoundNBT(map);
        }

        public String func_225648_a_() {
            return "COMPOUND";
        }

        public String func_225650_b_() {
            return "TAG_Compound";
        }
    };
    private final Map<String, INBT> field_74784_a;

    protected CompoundNBT(Map<String, INBT> p_i226075_1_) {
        this.field_74784_a = p_i226075_1_;
    }

    public CompoundNBT() {
        this(Maps.newHashMap());
    }

    public void func_74734_a(DataOutput p_74734_1_) throws IOException {
        for (String s : this.field_74784_a.keySet()) {
            INBT inbt = this.field_74784_a.get(s);
            CompoundNBT.func_150298_a(s, inbt, p_74734_1_);
        }
        p_74734_1_.writeByte(0);
    }

    public Set<String> func_150296_c() {
        return this.field_74784_a.keySet();
    }

    public byte func_74732_a() {
        return 10;
    }

    public INBTType<CompoundNBT> func_225647_b_() {
        return field_229675_a_;
    }

    public int func_186856_d() {
        return this.field_74784_a.size();
    }

    @Nullable
    public INBT func_218657_a(String p_218657_1_, INBT p_218657_2_) {
        if (p_218657_2_ == null) {
            throw new IllegalArgumentException("Invalid null NBT value with key " + p_218657_1_);
        }
        return this.field_74784_a.put(p_218657_1_, p_218657_2_);
    }

    public void func_74774_a(String p_74774_1_, byte p_74774_2_) {
        this.field_74784_a.put(p_74774_1_, (INBT)ByteNBT.func_229671_a_((byte)p_74774_2_));
    }

    public void func_74777_a(String p_74777_1_, short p_74777_2_) {
        this.field_74784_a.put(p_74777_1_, (INBT)ShortNBT.func_229701_a_((short)p_74777_2_));
    }

    public void func_74768_a(String p_74768_1_, int p_74768_2_) {
        this.field_74784_a.put(p_74768_1_, (INBT)IntNBT.func_229692_a_((int)p_74768_2_));
    }

    public void func_74772_a(String p_74772_1_, long p_74772_2_) {
        this.field_74784_a.put(p_74772_1_, (INBT)LongNBT.func_229698_a_((long)p_74772_2_));
    }

    public void func_186854_a(String p_186854_1_, UUID p_186854_2_) {
        this.field_74784_a.put(p_186854_1_, (INBT)NBTUtil.func_240626_a_((UUID)p_186854_2_));
    }

    public UUID func_186857_a(String p_186857_1_) {
        return NBTUtil.func_186860_b((INBT)this.func_74781_a(p_186857_1_));
    }

    public boolean func_186855_b(String p_186855_1_) {
        INBT inbt = this.func_74781_a(p_186855_1_);
        return inbt != null && inbt.func_225647_b_() == IntArrayNBT.field_229690_a_ && ((IntArrayNBT)inbt).func_150302_c().length == 4;
    }

    public void func_74776_a(String p_74776_1_, float p_74776_2_) {
        this.field_74784_a.put(p_74776_1_, (INBT)FloatNBT.func_229689_a_((float)p_74776_2_));
    }

    public void func_74780_a(String p_74780_1_, double p_74780_2_) {
        this.field_74784_a.put(p_74780_1_, (INBT)DoubleNBT.func_229684_a_((double)p_74780_2_));
    }

    public void func_74778_a(String p_74778_1_, String p_74778_2_) {
        this.field_74784_a.put(p_74778_1_, StringNBT.func_229705_a_(p_74778_2_));
    }

    public void func_74773_a(String p_74773_1_, byte[] p_74773_2_) {
        this.field_74784_a.put(p_74773_1_, (INBT)new ByteArrayNBT(p_74773_2_));
    }

    public void func_74783_a(String p_74783_1_, int[] p_74783_2_) {
        this.field_74784_a.put(p_74783_1_, (INBT)new IntArrayNBT(p_74783_2_));
    }

    public void func_197646_b(String p_197646_1_, List<Integer> p_197646_2_) {
        this.field_74784_a.put(p_197646_1_, (INBT)new IntArrayNBT(p_197646_2_));
    }

    public void func_197644_a(String p_197644_1_, long[] p_197644_2_) {
        this.field_74784_a.put(p_197644_1_, (INBT)new LongArrayNBT(p_197644_2_));
    }

    public void func_202168_c(String p_202168_1_, List<Long> p_202168_2_) {
        this.field_74784_a.put(p_202168_1_, (INBT)new LongArrayNBT(p_202168_2_));
    }

    public void func_74757_a(String p_74757_1_, boolean p_74757_2_) {
        this.field_74784_a.put(p_74757_1_, (INBT)ByteNBT.func_229672_a_((boolean)p_74757_2_));
    }

    @Nullable
    public INBT func_74781_a(String p_74781_1_) {
        return this.field_74784_a.get(p_74781_1_);
    }

    public byte func_150299_b(String p_150299_1_) {
        INBT inbt = this.field_74784_a.get(p_150299_1_);
        return inbt == null ? (byte)0 : inbt.func_74732_a();
    }

    public boolean func_74764_b(String p_74764_1_) {
        return this.field_74784_a.containsKey(p_74764_1_);
    }

    public boolean func_150297_b(String p_150297_1_, int p_150297_2_) {
        byte i = this.func_150299_b(p_150297_1_);
        if (i == p_150297_2_) {
            return true;
        }
        if (p_150297_2_ != 99) {
            return false;
        }
        return i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6;
    }

    public byte func_74771_c(String p_74771_1_) {
        try {
            if (this.func_150297_b(p_74771_1_, 99)) {
                return ((NumberNBT)this.field_74784_a.get(p_74771_1_)).func_150290_f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short func_74765_d(String p_74765_1_) {
        try {
            if (this.func_150297_b(p_74765_1_, 99)) {
                return ((NumberNBT)this.field_74784_a.get(p_74765_1_)).func_150289_e();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int func_74762_e(String p_74762_1_) {
        try {
            if (this.func_150297_b(p_74762_1_, 99)) {
                return ((NumberNBT)this.field_74784_a.get(p_74762_1_)).func_150287_d();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long func_74763_f(String p_74763_1_) {
        try {
            if (this.func_150297_b(p_74763_1_, 99)) {
                return ((NumberNBT)this.field_74784_a.get(p_74763_1_)).func_150291_c();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float func_74760_g(String p_74760_1_) {
        try {
            if (this.func_150297_b(p_74760_1_, 99)) {
                return ((NumberNBT)this.field_74784_a.get(p_74760_1_)).func_150288_h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double func_74769_h(String p_74769_1_) {
        try {
            if (this.func_150297_b(p_74769_1_, 99)) {
                return ((NumberNBT)this.field_74784_a.get(p_74769_1_)).func_150286_g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String func_74779_i(String p_74779_1_) {
        try {
            if (this.func_150297_b(p_74779_1_, 8)) {
                return this.field_74784_a.get(p_74779_1_).func_150285_a_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] func_74770_j(String p_74770_1_) {
        try {
            if (this.func_150297_b(p_74770_1_, 7)) {
                return ((ByteArrayNBT)this.field_74784_a.get(p_74770_1_)).func_150292_c();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_229677_a_(p_74770_1_, ByteArrayNBT.field_229667_a_, classcastexception));
        }
        return new byte[0];
    }

    public int[] func_74759_k(String p_74759_1_) {
        try {
            if (this.func_150297_b(p_74759_1_, 11)) {
                return ((IntArrayNBT)this.field_74784_a.get(p_74759_1_)).func_150302_c();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_229677_a_(p_74759_1_, IntArrayNBT.field_229690_a_, classcastexception));
        }
        return new int[0];
    }

    public long[] func_197645_o(String p_197645_1_) {
        try {
            if (this.func_150297_b(p_197645_1_, 12)) {
                return ((LongArrayNBT)this.field_74784_a.get(p_197645_1_)).func_197652_h();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_229677_a_(p_197645_1_, LongArrayNBT.field_229696_a_, classcastexception));
        }
        return new long[0];
    }

    public CompoundNBT func_74775_l(String p_74775_1_) {
        try {
            if (this.func_150297_b(p_74775_1_, 10)) {
                return (CompoundNBT)this.field_74784_a.get(p_74775_1_);
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_229677_a_(p_74775_1_, field_229675_a_, classcastexception));
        }
        return new CompoundNBT();
    }

    public ListNBT func_150295_c(String p_150295_1_, int p_150295_2_) {
        try {
            if (this.func_150299_b(p_150295_1_) == 9) {
                ListNBT listnbt = (ListNBT)this.field_74784_a.get(p_150295_1_);
                if (!listnbt.isEmpty() && listnbt.func_230528_d__() != p_150295_2_) {
                    return new ListNBT();
                }
                return listnbt;
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_229677_a_(p_150295_1_, ListNBT.field_229694_a_, classcastexception));
        }
        return new ListNBT();
    }

    public boolean func_74767_n(String p_74767_1_) {
        return this.func_74771_c(p_74767_1_) != 0;
    }

    public void func_82580_o(String p_82580_1_) {
        this.field_74784_a.remove(p_82580_1_);
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("{");
        Collection<String> collection = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(list);
            collection = list;
        }
        for (String s : collection) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            stringbuilder.append(CompoundNBT.func_193582_s(s)).append(':').append(this.field_74784_a.get(s));
        }
        return stringbuilder.append('}').toString();
    }

    public boolean isEmpty() {
        return this.field_74784_a.isEmpty();
    }

    private CrashReport func_229677_a_(String p_229677_1_, INBTType<?> p_229677_2_, ClassCastException p_229677_3_) {
        CrashReport crashreport = CrashReport.func_85055_a(p_229677_3_, "Reading NBT data");
        CrashReportCategory crashreportcategory = crashreport.func_85057_a("Corrupt NBT tag", 1);
        crashreportcategory.func_189529_a("Tag type found", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_74784_a.get(p_229677_1_).func_225647_b_().func_225648_a_()));
        crashreportcategory.func_189529_a("Tag type expected", (ICrashReportDetail<String>)((ICrashReportDetail)() -> p_229677_2_.func_225648_a_()));
        crashreportcategory.func_71507_a("Tag name", p_229677_1_);
        return crashreport;
    }

    public CompoundNBT func_74737_b() {
        HashMap map = Maps.newHashMap((Map)Maps.transformValues(this.field_74784_a, INBT::func_74737_b));
        return new CompoundNBT(map);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        return p_equals_1_ instanceof CompoundNBT && Objects.equals(this.field_74784_a, ((CompoundNBT)p_equals_1_).field_74784_a);
    }

    public int hashCode() {
        return this.field_74784_a.hashCode();
    }

    private static void func_150298_a(String p_150298_0_, INBT p_150298_1_, DataOutput p_150298_2_) throws IOException {
        p_150298_2_.writeByte(p_150298_1_.func_74732_a());
        if (p_150298_1_.func_74732_a() != 0) {
            p_150298_2_.writeUTF(p_150298_0_);
            p_150298_1_.func_74734_a(p_150298_2_);
        }
    }

    private static byte func_152447_a(DataInput p_152447_0_, NBTSizeTracker p_152447_1_) throws IOException {
        p_152447_1_.func_152450_a(8L);
        return p_152447_0_.readByte();
    }

    private static String func_152448_b(DataInput p_152448_0_, NBTSizeTracker p_152448_1_) throws IOException {
        return p_152448_1_.readUTF(p_152448_0_.readUTF());
    }

    private static INBT func_229680_b_(INBTType<?> p_229680_0_, String p_229680_1_, DataInput p_229680_2_, int p_229680_3_, NBTSizeTracker p_229680_4_) {
        try {
            return p_229680_0_.func_225649_b_(p_229680_2_, p_229680_3_, p_229680_4_);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.func_85055_a(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("NBT Tag");
            crashreportcategory.func_71507_a("Tag name", p_229680_1_);
            crashreportcategory.func_71507_a("Tag type", p_229680_0_.func_225648_a_());
            throw new ReportedException(crashreport);
        }
    }

    public CompoundNBT func_197643_a(CompoundNBT p_197643_1_) {
        for (String s : p_197643_1_.field_74784_a.keySet()) {
            INBT inbt = p_197643_1_.field_74784_a.get(s);
            if (inbt.func_74732_a() == 10) {
                if (this.func_150297_b(s, 10)) {
                    CompoundNBT compoundnbt = this.func_74775_l(s);
                    compoundnbt.func_197643_a((CompoundNBT)inbt);
                    continue;
                }
                this.func_218657_a(s, inbt.func_74737_b());
                continue;
            }
            this.func_218657_a(s, inbt.func_74737_b());
        }
        return this;
    }

    protected static String func_193582_s(String p_193582_0_) {
        return field_193583_c.matcher(p_193582_0_).matches() ? p_193582_0_ : StringNBT.func_197654_a(p_193582_0_);
    }

    protected static ITextComponent func_197642_t(String p_197642_0_) {
        if (field_193583_c.matcher(p_197642_0_).matches()) {
            return new StringTextComponent(p_197642_0_).func_240699_a_(field_197638_b);
        }
        String s = StringNBT.func_197654_a(p_197642_0_);
        String s1 = s.substring(0, 1);
        IFormattableTextComponent itextcomponent = new StringTextComponent(s.substring(1, s.length() - 1)).func_240699_a_(field_197638_b);
        return new StringTextComponent(s1).func_230529_a_((ITextComponent)itextcomponent).func_240702_b_(s1);
    }

    public ITextComponent func_199850_a(String p_199850_1_, int p_199850_2_) {
        if (this.field_74784_a.isEmpty()) {
            return new StringTextComponent("{}");
        }
        StringTextComponent iformattabletextcomponent = new StringTextComponent("{");
        Collection<String> collection = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(list);
            collection = list;
        }
        if (!p_199850_1_.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            IFormattableTextComponent iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)p_199850_1_, (int)(p_199850_2_ + 1))).func_230529_a_(CompoundNBT.func_197642_t(s)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.field_74784_a.get(s).func_199850_a(p_199850_1_, p_199850_2_ + 1));
            if (iterator.hasNext()) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(p_199850_1_.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (!p_199850_1_.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)p_199850_1_, (int)p_199850_2_));
        }
        iformattabletextcomponent.func_240702_b_("}");
        return iformattabletextcomponent;
    }

    protected Map<String, INBT> func_240600_h_() {
        return Collections.unmodifiableMap(this.field_74784_a);
    }
}

