/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.progress;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.fml.loading.progress.EarlyProgressVisualization;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.stb.STBEasyFont;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

class ClientVisualization
implements EarlyProgressVisualization.Visualization {
    private final int screenWidth = 854;
    private final int screenHeight = 480;
    private long window;
    private Thread renderThread = new Thread(this::renderThreadFunc);
    private boolean running = true;
    private GLFWFramebufferSizeCallback framebufferSizeCallback;
    private int[] fbSize;
    private static final float[] memorycolour = new float[]{0.0f, 0.0f, 0.0f};

    ClientVisualization() {
    }

    private void initWindow(@Nullable String mcVersion) {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        long glfwInitBegin = System.nanoTime();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        long glfwInitEnd = System.nanoTime();
        if ((double)(glfwInitEnd - glfwInitBegin) > 1.0E9) {
            LogManager.getLogger().fatal("WARNING : glfwInit took {} seconds to start.", (Object)((double)(glfwInitEnd - glfwInitBegin) / 1.0E9));
        }
        this.handleLastGLFWError((error, description) -> LogManager.getLogger().error(String.format("Suppressing Last GLFW error: [0x%X]%s", error, description)));
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)2);
        GLFW.glfwWindowHint((int)139267, (int)0);
        GLFW.glfwWindowHint((int)139272, (int)0);
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)1);
        if (mcVersion != null) {
            String vanillaWindowTitle = "Minecraft* " + mcVersion;
            GLFW.glfwWindowHintString((int)147457, (CharSequence)vanillaWindowTitle);
            GLFW.glfwWindowHintString((int)147458, (CharSequence)vanillaWindowTitle);
        }
        this.window = GLFW.glfwCreateWindow((int)854, (int)480, (CharSequence)"FML early loading progress", (long)0L, (long)0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        this.framebufferSizeCallback = GLFWFramebufferSizeCallback.create(this::fbResize);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            IntBuffer monPosLeft = stack.mallocInt(1);
            IntBuffer monPosTop = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.window, (IntBuffer)pWidth, (IntBuffer)pHeight);
            long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
            if (primaryMonitor != 0L) {
                // empty if block
            }
            if (!System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
                this.setWindowIcon(stack);
            }
        }
        int[] w = new int[1];
        int[] h = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.window, (int[])w, (int[])h);
        this.fbSize = new int[]{w[0], h[0]};
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, (GLFWFramebufferSizeCallbackI)this.framebufferSizeCallback);
        GLFW.glfwShowWindow((long)this.window);
        GLFW.glfwPollEvents();
    }

    private void setWindowIcon(MemoryStack stack) {
        IntBuffer iconWidth = stack.mallocInt(1);
        IntBuffer iconHeight = stack.mallocInt(1);
        IntBuffer iconChannels = stack.mallocInt(1);
        GLFWImage.Buffer glfwImages = GLFWImage.mallocStack((int)1, (MemoryStack)stack);
        try {
            byte[] icon = ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("forge_icon.png"));
            ByteBuffer iconBuf = stack.malloc(icon.length);
            iconBuf.put(icon);
            ((Buffer)iconBuf).position(0);
            ByteBuffer imgBuffer = STBImage.stbi_load_from_memory((ByteBuffer)iconBuf, (IntBuffer)iconWidth, (IntBuffer)iconHeight, (IntBuffer)iconChannels, (int)4);
            if (imgBuffer == null) {
                throw new NullPointerException("Failed to load window icon");
            }
            glfwImages.position(0);
            glfwImages.width(iconWidth.get(0));
            glfwImages.height(iconHeight.get(0));
            ((Buffer)imgBuffer).position(0);
            glfwImages.pixels(imgBuffer);
            glfwImages.position(0);
            GLFW.glfwSetWindowIcon((long)this.window, (GLFWImage.Buffer)glfwImages);
            STBImage.stbi_image_free((ByteBuffer)imgBuffer);
        }
        catch (IOException | NullPointerException e) {
            System.err.println("Failed to load forge logo");
        }
    }

    private void renderProgress() {
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)854.0, (double)480.0, (double)0.0, (double)-1000.0, (double)1000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glEnableClientState((int)32884);
        GL11.glEnable((int)3042);
        this.renderBackground();
        this.renderMessages();
        GLFW.glfwSwapBuffers((long)this.window);
    }

    private static float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    private static int clamp(int num, int min, int max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    private static int hsvToRGB(float hue, float saturation, float value) {
        float f6;
        float f5;
        float f4;
        int i = (int)(hue * 6.0f) % 6;
        float f = hue * 6.0f - (float)i;
        float f1 = value * (1.0f - saturation);
        float f2 = value * (1.0f - f * saturation);
        float f3 = value * (1.0f - (1.0f - f) * saturation);
        switch (i) {
            case 0: {
                f4 = value;
                f5 = f3;
                f6 = f1;
                break;
            }
            case 1: {
                f4 = f2;
                f5 = value;
                f6 = f1;
                break;
            }
            case 2: {
                f4 = f1;
                f5 = value;
                f6 = f3;
                break;
            }
            case 3: {
                f4 = f1;
                f5 = f2;
                f6 = value;
                break;
            }
            case 4: {
                f4 = f3;
                f5 = f1;
                f6 = value;
                break;
            }
            case 5: {
                f4 = value;
                f5 = f1;
                f6 = f2;
                break;
            }
            default: {
                throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
            }
        }
        int j = ClientVisualization.clamp((int)(f4 * 255.0f), 0, 255);
        int k = ClientVisualization.clamp((int)(f5 * 255.0f), 0, 255);
        int l = ClientVisualization.clamp((int)(f6 * 255.0f), 0, 255);
        return j << 16 | k << 8 | l;
    }

    private void renderBackground() {
        GL11.glBegin((int)7);
        GL11.glColor4f((float)0.9372549f, (float)0.19607843f, (float)0.23921569f, (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)480.0f);
        GL11.glVertex2f((float)854.0f, (float)480.0f);
        GL11.glVertex2f((float)854.0f, (float)0.0f);
        GL11.glEnd();
    }

    private void fbResize(long window, int width, int height) {
        if (window == this.window && width != 0 && height != 0) {
            this.fbSize = new int[]{width, height};
        }
    }

    private void handleLastGLFWError(BiConsumer<Integer, String> handler) {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int error = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (error != 0) {
                long pDescription = pointerbuffer.get();
                String description = pDescription == 0L ? "" : MemoryUtil.memUTF8((long)pDescription);
                handler.accept(error, description);
            }
        }
    }

    private void renderMessages() {
        List<Pair<Integer, StartupMessageManager.Message>> messages = StartupMessageManager.getMessages();
        for (int i = 0; i < messages.size(); ++i) {
            Pair<Integer, StartupMessageManager.Message> pair = messages.get(i);
            float fade = ClientVisualization.clamp((4000.0f - (float)((Integer)pair.getLeft()).intValue() - (float)(i - 4) * 1000.0f) / 5000.0f, 0.0f, 1.0f);
            if (fade < 0.01f) continue;
            StartupMessageManager.Message msg = (StartupMessageManager.Message)pair.getRight();
            this.renderMessage(msg.getText(), msg.getTypeColour(), 23 - i, fade);
        }
        this.renderMemoryInfo();
    }

    @Override
    public void updateFBSize(IntConsumer width, IntConsumer height) {
        width.accept(this.fbSize[0]);
        height.accept(this.fbSize[1]);
    }

    private void renderMemoryInfo() {
        MemoryUsage heapusage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage offheapusage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        float pctmemory = (float)heapusage.getUsed() / (float)heapusage.getMax();
        String memory = String.format("Memory Heap: %d / %d MB (%.1f%%)  OffHeap: %d MB", heapusage.getUsed() >> 20, heapusage.getMax() >> 20, (double)pctmemory * 100.0, offheapusage.getUsed() >> 20);
        int i = ClientVisualization.hsvToRGB((1.0f - (float)Math.pow(pctmemory, 1.5)) / 3.0f, 1.0f, 0.5f);
        ClientVisualization.memorycolour[2] = (float)(i & 0xFF) / 255.0f;
        ClientVisualization.memorycolour[1] = (float)(i >> 8 & 0xFF) / 255.0f;
        ClientVisualization.memorycolour[0] = (float)(i >> 16 & 0xFF) / 255.0f;
        this.renderMessage(memory, memorycolour, 1, 1.0f);
    }

    private void renderMessage(String message, float[] colour, int row, float alpha) {
        ByteBuffer charBuffer = MemoryUtil.memAlloc((int)(message.length() * 270));
        int quads = STBEasyFont.stb_easy_font_print((float)0.0f, (float)0.0f, (CharSequence)message, null, (ByteBuffer)charBuffer);
        GL11.glVertexPointer((int)3, (int)5126, (int)16, (ByteBuffer)charBuffer);
        GL11.glEnable((int)3042);
        GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
        GL11.glBlendFunc((int)32771, (int)32772);
        GL11.glColor3f((float)colour[0], (float)colour[1], (float)colour[2]);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)10.0f, (float)(row * 20), (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GL11.glDrawArrays((int)7, (int)0, (int)(quads * 4));
        GL11.glPopMatrix();
        MemoryUtil.memFree((Buffer)charBuffer);
    }

    private void renderThreadFunc() {
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)1);
        GL.createCapabilities();
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16384);
        while (this.running) {
            this.renderProgress();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
                break;
            }
        }
        GLFW.glfwMakeContextCurrent((long)0L);
    }

    @Override
    public Runnable start(@Nullable String mcVersion) {
        this.initWindow(mcVersion);
        this.renderThread.setDaemon(true);
        this.renderThread.start();
        return GLFW::glfwPollEvents;
    }

    @Override
    public long handOffWindow(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitorSupplier) {
        this.running = false;
        try {
            this.renderThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        GLFW.glfwSetWindowTitle((long)this.window, (CharSequence)title.get());
        GLFW.glfwSetWindowSize((long)this.window, (int)width.getAsInt(), (int)height.getAsInt());
        if (monitorSupplier.getAsLong() != 0L) {
            GLFW.glfwSetWindowMonitor((long)this.window, (long)monitorSupplier.getAsLong(), (int)0, (int)0, (int)width.getAsInt(), (int)height.getAsInt(), (int)-1);
        }
        GLFW.glfwMakeContextCurrent((long)this.window);
        GL.createCapabilities();
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16384);
        this.renderProgress();
        GLFW.glfwSwapInterval((int)0);
        GLFW.glfwSwapBuffers((long)this.window);
        GLFW.glfwSwapInterval((int)1);
        GLFWFramebufferSizeCallback previous = GLFW.glfwSetFramebufferSizeCallback((long)this.window, null);
        previous.free();
        return this.window;
    }
}

