/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.ClientBossInfo;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class RenderGameOverlayEvent
extends Event {
    private final MatrixStack mStack;
    private final float partialTicks;
    private final MainWindow window;
    private final ElementType type;

    public MatrixStack getMatrixStack() {
        return this.mStack;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public MainWindow getWindow() {
        return this.window;
    }

    public ElementType getType() {
        return this.type;
    }

    public RenderGameOverlayEvent(MatrixStack mStack, float partialTicks, MainWindow window) {
        this.mStack = mStack;
        this.partialTicks = partialTicks;
        this.window = window;
        this.type = null;
    }

    private RenderGameOverlayEvent(MatrixStack mStack, RenderGameOverlayEvent parent, ElementType type) {
        this.mStack = mStack;
        this.partialTicks = parent.getPartialTicks();
        this.window = parent.getWindow();
        this.type = type;
    }

    public static class Chat
    extends Pre {
        private int posX;
        private int posY;

        public Chat(MatrixStack mStack, RenderGameOverlayEvent parent, int posX, int posY) {
            super(mStack, parent, ElementType.CHAT);
            this.setPosX(posX);
            this.setPosY(posY);
        }

        public int getPosX() {
            return this.posX;
        }

        public void setPosX(int posX) {
            this.posX = posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public void setPosY(int posY) {
            this.posY = posY;
        }
    }

    public static class Text
    extends Pre {
        private final ArrayList<String> left;
        private final ArrayList<String> right;

        public Text(MatrixStack mStack, RenderGameOverlayEvent parent, ArrayList<String> left, ArrayList<String> right) {
            super(mStack, parent, ElementType.TEXT);
            this.left = left;
            this.right = right;
        }

        public ArrayList<String> getLeft() {
            return this.left;
        }

        public ArrayList<String> getRight() {
            return this.right;
        }
    }

    public static class BossInfo
    extends Pre {
        private final ClientBossInfo bossInfo;
        private final int x;
        private final int y;
        private int increment;

        public BossInfo(MatrixStack mStack, RenderGameOverlayEvent parent, ElementType type, ClientBossInfo bossInfo, int x, int y, int increment) {
            super(mStack, parent, type);
            this.bossInfo = bossInfo;
            this.x = x;
            this.y = y;
            this.increment = increment;
        }

        public ClientBossInfo getBossInfo() {
            return this.bossInfo;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getIncrement() {
            return this.increment;
        }

        public void setIncrement(int increment) {
            this.increment = increment;
        }
    }

    public static class Post
    extends RenderGameOverlayEvent {
        public Post(MatrixStack mStack, RenderGameOverlayEvent parent, ElementType type) {
            super(mStack, parent, type);
        }

        public boolean isCancelable() {
            return false;
        }
    }

    public static class Pre
    extends RenderGameOverlayEvent {
        public Pre(MatrixStack mStack, RenderGameOverlayEvent parent, ElementType type) {
            super(mStack, parent, type);
        }
    }

    public static enum ElementType {
        ALL,
        HELMET,
        PORTAL,
        CROSSHAIRS,
        BOSSHEALTH,
        BOSSINFO,
        ARMOR,
        HEALTH,
        FOOD,
        AIR,
        HOTBAR,
        EXPERIENCE,
        TEXT,
        HEALTHMOUNT,
        JUMPBAR,
        CHAT,
        PLAYER_LIST,
        DEBUG,
        POTION_ICONS,
        SUBTITLES,
        FPS_GRAPH,
        VIGNETTE;

    }
}

