/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class ItemMultiLayerBakedModel
implements IDynamicBakedModel {
    private final boolean smoothLighting;
    private final boolean shadedInGui;
    private final boolean sideLit;
    private final TextureAtlasSprite particle;
    private final ItemOverrideList overrides;
    private final ImmutableList<Pair<IBakedModel, RenderType>> layerModels;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms;

    public ItemMultiLayerBakedModel(boolean smoothLighting, boolean shadedInGui, boolean sideLit, TextureAtlasSprite particle, ItemOverrideList overrides, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms, ImmutableList<Pair<IBakedModel, RenderType>> layerModels) {
        this.smoothLighting = smoothLighting;
        this.shadedInGui = shadedInGui;
        this.sideLit = sideLit;
        this.particle = particle;
        this.overrides = overrides;
        this.layerModels = layerModels;
        this.cameraTransforms = cameraTransforms;
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
        ArrayList quads = Lists.newArrayList();
        this.layerModels.forEach(lm -> quads.addAll(((IBakedModel)lm.getFirst()).getQuads(state, side, rand, modelData)));
        return quads;
    }

    public boolean func_177555_b() {
        return this.smoothLighting;
    }

    public boolean func_177556_c() {
        return this.shadedInGui;
    }

    public boolean func_230044_c_() {
        return this.sideLit;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.cameraTransforms, cameraTransformType, mat);
    }

    public boolean isLayered() {
        return true;
    }

    public List<Pair<IBakedModel, RenderType>> getLayerModels(ItemStack itemStack, boolean fabulous) {
        return this.layerModels;
    }

    public static Builder builder(IModelConfiguration owner, TextureAtlasSprite particle, ItemOverrideList overrides, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms) {
        return new Builder(owner, particle, overrides, cameraTransforms);
    }

    public static class Builder {
        private final ImmutableList.Builder<Pair<IBakedModel, RenderType>> builder = ImmutableList.builder();
        private final List<BakedQuad> quads = Lists.newArrayList();
        private final ItemOverrideList overrides;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms;
        private final IModelConfiguration owner;
        private TextureAtlasSprite particle;
        private RenderType lastRt = null;

        private Builder(IModelConfiguration owner, TextureAtlasSprite particle, ItemOverrideList overrides, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms) {
            this.owner = owner;
            this.particle = particle;
            this.overrides = overrides;
            this.cameraTransforms = cameraTransforms;
        }

        private void addLayer(ImmutableList.Builder<Pair<IBakedModel, RenderType>> builder, List<BakedQuad> quads, RenderType rt) {
            BakedItemModel model = new BakedItemModel((ImmutableList<BakedQuad>)ImmutableList.copyOf(quads), this.particle, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)ImmutableMap.of(), ItemOverrideList.field_188022_a, true, this.owner.isSideLit());
            builder.add((Object)Pair.of((Object)model, (Object)rt));
        }

        private void flushQuads(RenderType rt) {
            if (rt != this.lastRt) {
                if (this.quads.size() > 0) {
                    this.addLayer(this.builder, this.quads, this.lastRt);
                    this.quads.clear();
                }
                this.lastRt = rt;
            }
        }

        public Builder setParticle(TextureAtlasSprite particleSprite) {
            this.particle = particleSprite;
            return this;
        }

        public Builder addQuads(RenderType rt, BakedQuad ... quadsToAdd) {
            this.flushQuads(rt);
            Collections.addAll(this.quads, quadsToAdd);
            return this;
        }

        public Builder addQuads(RenderType rt, Collection<BakedQuad> quadsToAdd) {
            this.flushQuads(rt);
            this.quads.addAll(quadsToAdd);
            return this;
        }

        public IBakedModel build() {
            if (this.quads.size() > 0) {
                this.addLayer(this.builder, this.quads, this.lastRt);
            }
            return new ItemMultiLayerBakedModel(this.owner.useSmoothLighting(), this.owner.isShadedInGui(), this.owner.isSideLit(), this.particle, this.overrides, this.cameraTransforms, (ImmutableList<Pair<IBakedModel, RenderType>>)this.builder.build());
        }
    }
}

